/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.collection.tenants;

import java.io.InputStream;
import java.security.Principal;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.TreeReader;
import oracle.dbtools.rt.home.StoreMode;
import oracle.dbtools.rt.home.tenants.MultiTenantEntity;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityTreeStorage;
import oracle.dbtools.rt.resource.collection.CollectionUriTemplates;
import oracle.dbtools.rt.resource.collection.PutResource;
import oracle.dbtools.rt.resource.templates.v2.EntityIds;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.ContentType;

public abstract class PutMultiTenantResource<T extends MultiTenantEntity>
extends PutResource<MultiTenantEntityPK, T> {
    @Reference
    private MultiTenantEntityTreeStorage storage;
    private final Class<T> type;

    protected PutMultiTenantResource(Class<T> type, CollectionUriTemplates uriTemplates, ContentType ... acceptable) {
        super(uriTemplates, acceptable);
        this.type = type;
    }

    protected abstract TreeReader<MultiTenantEntity> entityGraphReader();

    @Override
    protected final T existing(CompoundPrincipal principal, MultiTenantEntityPK id) {
        return (T)((MultiTenantEntity)this.type.cast(this.storage.entity((Transaction)null, principal, id, (Class<? extends MultiTenantEntity>)this.type)));
    }

    @Override
    protected MultiTenantEntityPK id(CompoundPrincipal principal, String idValue) {
        TenantPrincipal tenant = TenantPrincipal.tenant((Principal)principal);
        return EntityIds.entityId(tenant, idValue);
    }

    @Override
    protected String string(MultiTenantEntityPK id) {
        return EntityIds.string(id);
    }

    @Override
    protected void update(CompoundPrincipal principal, T existing, InputStream content) {
        this.storage.store(principal, existing.id(), content, this.entityGraphReader(), StoreMode.UPDATE);
    }
}

