/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.collection;

import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.resource.collection.CollectionUriTemplates;
import oracle.dbtools.rt.validation.Validator;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.HttpResources;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.Requests;

public abstract class PostResource<PK>
extends RequestHandler {
    @Reference
    protected Validator validator;
    private final CollectionUriTemplates uriTemplates;
    private final ContentType[] acceptable;

    protected PostResource(CollectionUriTemplates uriTemplates, ContentType ... acceptable) {
        super(HttpMethod.POST, SECURE_RESOURCE_TEMPLATE, uriTemplates.collection(), false);
        this.uriTemplates = uriTemplates;
        this.acceptable = acceptable;
    }

    @Override
    protected HttpResource dispatch(RequestEntity request) throws IOException {
        Requests.acceptable(request, this.acceptable);
        return HttpResources.created(this.create(request.principal(), request.contentType(), request.body()));
    }

    protected String create(CompoundPrincipal principal, ContentType contentType, InputStream content) throws IOException {
        PK id = this.create(principal, content);
        String location = null;
        if (id != null) {
            location = this.location(this.uriTemplates, id);
        }
        return location;
    }

    protected abstract PK create(CompoundPrincipal var1, InputStream var2);

    private String location(CollectionUriTemplates uriTemplates, PK id) {
        return uriTemplates.item().encode(new String[]{"id", this.string(id)});
    }

    protected String string(PK id) {
        return id.toString();
    }
}

