/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.paging;

import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.paging.Pagination;
import oracle.dbtools.rt.web.QueryString;
import oracle.dbtools.rt.web.ReTargetingDispatcher;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;

@Service(provides={RequestDispatcher.class})
public class PagingDispatcher
extends ReTargetingDispatcher<PageTarget> {
    @Override
    protected PageTarget target(RequestEntity request) {
        Pair<QueryString, Long> page = Pagination.paginate(request.path());
        if (page != null) {
            String target = ((QueryString)((Object)page.first())).toString();
            if (!request.path().equals(target)) {
                return new PageTarget(((QueryString)((Object)page.first())).toString(), (Long)page.second());
            }
        }
        return null;
    }

    @Override
    protected EntityHeaders forwardedHeaders(PageTarget target, RequestEntity request) {
        return Entities.headers("X-APEX-PAGE-OFFSET", Long.toString(target.pageOffset));
    }

    class PageTarget
    extends ReTargetingDispatcher.Target {
        private final long pageOffset;

        PageTarget(String target, long pageOffset) {
            super(target);
            this.pageOffset = pageOffset;
        }
    }
}

