/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.jdbc;

import java.io.Closeable;
import java.security.Principal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.common.jdbc.ConnectionPoolException;
import oracle.dbtools.common.jdbc.JDBCCall;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.jdbc.JDBCQuery;
import oracle.dbtools.common.jdbc.JDBCTransaction;
import oracle.dbtools.common.query.ColumnIterator;
import oracle.dbtools.common.query.QueryProvider;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.oauth.ApprovalRequest;
import oracle.dbtools.rt.oauth.BearerTokenVerification;
import oracle.dbtools.rt.oauth.OAuthAuthorization;
import oracle.dbtools.rt.oauth.OAuthDataAccess;
import oracle.dbtools.rt.oauth.OAuthException;
import oracle.dbtools.rt.oauth.jdbc.RowToOAuthScope;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

@Service(provides={JDBCOAuthDataAccess.class, OAuthDataAccess.class}, priority=1)
public class JDBCOAuthDataAccess
implements OAuthDataAccess {
    @Reference
    private JDBCCallProvider jdbc;
    @Reference
    private QueryProvider query;
    private static final String _APPROVAL_PROJECTION = "select a.security_group_id, a.id, a.user_name, c.id, a.status, c.name, c.description, c.response_type, c.client_id, c.client_secret, c.redirect_uri, c.support_email";
    private static final String _APPROVAL_SELECT = "select a.security_group_id, a.id, a.user_name, c.id, a.status, c.name, c.description, c.response_type, c.client_id, c.client_secret, c.redirect_uri, c.support_email from wwv_flow_rt$approvals a, wwv_flow_rt$clients c where c.id = a.client_id";
    private static final String APPROVAL_BY_APPROVAL_ID = "select a.security_group_id, a.id, a.user_name, c.id, a.status, c.name, c.description, c.response_type, c.client_id, c.client_secret, c.redirect_uri, c.support_email from wwv_flow_rt$approvals a, wwv_flow_rt$clients c where c.id = a.client_id and a.user_name =:user_id and c.client_id = :client_id";
    private static final String APPROVAL_BY_ID = "select a.security_group_id, a.id, a.user_name, c.id, a.status, c.name, c.description, c.response_type, c.client_id, c.client_secret, c.redirect_uri, c.support_email from wwv_flow_rt$approvals a, wwv_flow_rt$clients c where c.id = a.client_id and a.security_group_id = :tenant_id and a.id = :approval_id and a.user_name = :user_id";
    private static final Statement APPROVAL_BY_ID_STMT = StatementBuilder.query().append((CharSequence)"select a.security_group_id, a.id, a.user_name, c.id, a.status, c.name, c.description, c.response_type, c.client_id, c.client_secret, c.redirect_uri, c.support_email from wwv_flow_rt$approvals a, wwv_flow_rt$clients c where c.id = a.client_id and a.security_group_id = :tenant_id and a.id = :approval_id and a.user_name = :user_id").parameter("tenant_id", Long.class, ParameterAccess.IN).parameter("approval_id", Long.class, ParameterAccess.IN).parameter("user_id", String.class, ParameterAccess.IN).build();
    private static final String APPROVAL_BY_REFRESH_TOKEN = "select a.security_group_id, a.id, a.user_name, c.id, a.status, c.name, c.description, c.response_type, c.client_id, c.client_secret, c.redirect_uri, c.support_email from wwv_flow_rt$approvals a, wwv_flow_rt$clients c, wwv_flow_rt$user_sessions us where c.id = a.client_id and us.refresh_token = :refresh_token and a.id = us.approval_id";
    private static final Statement APPROVAL_BY_REFRESH_TOKEN_STMT = StatementBuilder.query().append((CharSequence)"select a.security_group_id, a.id, a.user_name, c.id, a.status, c.name, c.description, c.response_type, c.client_id, c.client_secret, c.redirect_uri, c.support_email from wwv_flow_rt$approvals a, wwv_flow_rt$clients c, wwv_flow_rt$user_sessions us where c.id = a.client_id and us.refresh_token = :refresh_token and a.id = us.approval_id").parameter("refresh_token", String.class, ParameterAccess.IN).build();
    private static final Statement APPROVAL_STMT = StatementBuilder.query((String)"select a.security_group_id, a.id, a.user_name, c.id, a.status, c.name, c.description, c.response_type, c.client_id, c.client_secret, c.redirect_uri, c.support_email from wwv_flow_rt$approvals a, wwv_flow_rt$clients c where c.id = a.client_id and a.user_name =:user_id and c.client_id = :client_id", (String[])new String[]{"user_id", "client_id"});
    private static final String BEARER_TOKEN = "select a.security_group_id, a.id, us.token_expiry, current_timestamp, a.user_name from wwv_flow_rt$approvals a, wwv_flow_rt$user_sessions us where us.bearer_token = :bearer_token and us.approval_id = a.id";
    private static final Statement BEARER_TOKEN_STMT = StatementBuilder.query((String)"select a.security_group_id, a.id, us.token_expiry, current_timestamp, a.user_name from wwv_flow_rt$approvals a, wwv_flow_rt$user_sessions us where us.bearer_token = :bearer_token and us.approval_id = a.id", (String[])new String[]{"bearer_token"});
    private static final String CREATE_APPROVAL = "insert into wwv_flow_rt$approvals (user_name,status,client_id,security_group_id,created_by,created_on,updated_by,updated_on) values(:user_id,'PENDING',:client_id,:tenant_id,upper(:user_id),:created,upper(:user_id),:created)";
    private static final String CREATE_APPROVAL_SCOPE = "insert into wwv_flow_rt$approval_privs (approval_id,privilege_id,security_group_id,created_by,created_on,updated_by,updated_on) values(:approval_id,:scope_id,:tenant_id,upper(:user_id),:created,upper(:user_id),:created)";
    private static final Statement CREATE_APPROVAL_SCOPE_STMT = StatementBuilder.call().append((CharSequence)"insert into wwv_flow_rt$approval_privs (approval_id,privilege_id,security_group_id,created_by,created_on,updated_by,updated_on) values(:approval_id,:scope_id,:tenant_id,upper(:user_id),:created,upper(:user_id),:created)").parameter("approval_id", Long.class, ParameterAccess.IN).parameter("privilege_id", Long.class, ParameterAccess.IN).parameter("tenant_id", Long.class, ParameterAccess.IN).parameter("created", Timestamp.class, ParameterAccess.IN).build();
    private static final Statement CREATE_APPROVAL_STMT = StatementBuilder.call().append((CharSequence)"insert into wwv_flow_rt$approvals (user_name,status,client_id,security_group_id,created_by,created_on,updated_by,updated_on) values(:user_id,'PENDING',:client_id,:tenant_id,upper(:user_id),:created,upper(:user_id),:created)").parameter("user_id", String.class, ParameterAccess.IN).parameter("client_id", Long.class, ParameterAccess.IN).parameter("tenant_id", Long.class, ParameterAccess.IN).parameter("created", Timestamp.class, ParameterAccess.IN).build();
    private static final String DELETE_APPROVAL = "delete from wwv_flow_rt$approvals where security_group_id = :tenant_id and id = :approval_id";
    private static final Statement DELETE_APPROVAL_STMT = StatementBuilder.call().append((CharSequence)"delete from wwv_flow_rt$approvals where security_group_id = :tenant_id and id = :approval_id").parameter("tenant_id", Long.class, ParameterAccess.IN).parameter("approval_id", Long.class, ParameterAccess.IN).build();
    private static final String GET_APPROVAL_SCOPES = "select s.id, s.security_group_id,s.name, s.label, s.description from wwv_flow_rt$privileges s, wwv_flow_rt$approval_privs p where s.id =  p.privilege_id and p.approval_id = :id";
    private static final Statement GET_APPROVAL_SCOPES_STMT = StatementBuilder.query().append((CharSequence)"select s.id, s.security_group_id,s.name, s.label, s.description from wwv_flow_rt$privileges s, wwv_flow_rt$approval_privs p where s.id =  p.privilege_id and p.approval_id = :id").parameter("id", Long.class, ParameterAccess.IN).build();
    private static final String GET_CLIENT_SCOPES = "select s.id, s.security_group_id,s.name, s.label, s.description from wwv_flow_rt$privileges s, wwv_flow_rt$client_privileges cs where s.id =  cs.privilege_id and cs.client_id = :id and s.security_group_id = :tenant_id";
    static final Statement GET_CLIENT_SCOPES_STMT = StatementBuilder.query().append((CharSequence)"select s.id, s.security_group_id,s.name, s.label, s.description from wwv_flow_rt$privileges s, wwv_flow_rt$client_privileges cs where s.id =  cs.privilege_id and cs.client_id = :id and s.security_group_id = :tenant_id").parameter("id", Long.class, ParameterAccess.IN).parameter("tenant_id", Long.class, ParameterAccess.IN).build();
    private static final String CREATE_USER_SESSION = "insert into wwv_flow_rt$user_sessions (approval_id,bearer_token,refresh_token,token_expiry,security_group_id,created_by,created_on,updated_by,updated_on) values(:approval_id,:bearer_token,:refresh_token,{fn timestampadd( SQL_TSI_HOUR, 1, CURRENT_TIMESTAMP)},:tenant_id,upper(:user_id),:created,upper(:user_id),:created)";
    private static final Statement CREATE_USER_SESSION_STMT = StatementBuilder.call().append((CharSequence)"insert into wwv_flow_rt$user_sessions (approval_id,bearer_token,refresh_token,token_expiry,security_group_id,created_by,created_on,updated_by,updated_on) values(:approval_id,:bearer_token,:refresh_token,{fn timestampadd( SQL_TSI_HOUR, 1, CURRENT_TIMESTAMP)},:tenant_id,upper(:user_id),:created,upper(:user_id),:created)").parameter("bearer_token", String.class, ParameterAccess.IN).parameter("refresh_token", String.class, ParameterAccess.IN).parameter("tenant_id", Long.class, ParameterAccess.IN).parameter("approval_id", Long.class, ParameterAccess.IN).build();
    private static final String UPDATE_STATUS = "update wwv_flow_rt$approvals set status = :status where security_group_id = :tenant_id and id = :approval_id";
    private static final Statement UPDATE_STATUS_STMT = StatementBuilder.call().append((CharSequence)"update wwv_flow_rt$approvals set status = :status where security_group_id = :tenant_id and id = :approval_id").parameter("status", String.class, ParameterAccess.IN).parameter("tenant_id", Long.class, ParameterAccess.IN).parameter("approval_id", Long.class, ParameterAccess.IN).build();
    private static final String VERIFY_CLIENT = "select security_group_id,id,name,description,auth_flow,response_type,client_id,client_secret,redirect_uri,support_email from wwv_flow_rt$clients where client_id = :client_id";
    private static final Statement VERIFY_CLIENT_STMT = StatementBuilder.query((String)"select security_group_id,id,name,description,auth_flow,response_type,client_id,client_secret,redirect_uri,support_email from wwv_flow_rt$clients where client_id = :client_id", (String[])new String[]{"client_id"});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BearerTokenVerification accessGranted(CompoundPrincipal principal, MultiTenantEntityPK scopeId, String bearerToken) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("bearer_token", bearerToken);
        Iterator<ResultRow> matches = null;
        try {
            matches = this.query(principal, BEARER_TOKEN_STMT, parameters);
            if (matches.hasNext()) {
                ResultRow match = matches.next();
                MultiTenantEntityPK id = MultiTenantEntityPK.key((Long)match.get(1, Long.class), (Long)match.get(2, Long.class));
                Timestamp expiry = (Timestamp)match.get(3, Timestamp.class);
                Timestamp now = (Timestamp)match.get(4, Timestamp.class);
                String userId = (String)match.get(5, String.class);
                List<ApprovalRequest.Scope> scopes = this.approvalScopes(principal, id);
                ArrayList<MultiTenantEntityPK> scopeIds = new ArrayList<MultiTenantEntityPK>(scopes.size());
                for (ApprovalRequest.Scope scope : scopes) {
                    scopeIds.add(scope.id());
                }
                BearerTokenVerification bearerTokenVerification = OAuthAuthorization.verifyApproval(scopeId, expiry, now, userId, scopeIds);
                return bearerTokenVerification;
            }
        }
        catch (ConnectionPoolException e) {
            BearerTokenVerification bearerTokenVerification = BearerTokenVerification.unknown();
            return bearerTokenVerification;
        }
        finally {
            Closeables.close(matches);
        }
        return BearerTokenVerification.unknown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApprovalRequest approvalRequest(CompoundPrincipal principal, String userId, String clientId) {
        ApprovalRequest existing = null;
        Iterator<ResultRow> matches = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("user_id", userId);
            parameters.put("client_id", clientId);
            matches = this.query(principal, APPROVAL_STMT, parameters);
            if (matches.hasNext()) {
                ResultRow row = matches.next();
                existing = this.approvalRequest(row);
            }
            if (existing != null) {
                List<ApprovalRequest.Scope> scopes = this.approvalScopes(principal, existing.id());
                existing.scopes().addAll(scopes);
            }
        }
        catch (ConnectionPoolException e) {
            ApprovalRequest approvalRequest = null;
            return approvalRequest;
        }
        finally {
            Closeables.close(matches);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApprovalRequest approvalRequest(CompoundPrincipal principal, Transaction txn, OAuthAuthorization.OAuthClient client, String refreshToken) {
        ApprovalRequest existing;
        block7: {
            existing = null;
            Iterator<ResultRow> matches = null;
            try {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("refresh_token", refreshToken);
                matches = this.query(principal, APPROVAL_BY_REFRESH_TOKEN_STMT, parameters);
                if (matches.hasNext()) {
                    ResultRow row = matches.next();
                    existing = this.approvalRequest(row);
                    if (existing != null) {
                        List<ApprovalRequest.Scope> scopes = this.approvalScopes(principal, existing.id());
                        existing.scopes().addAll(scopes);
                    }
                    break block7;
                }
                throw OAuthException.error(OAuthException.Error.INVALID_GRANT);
            }
            catch (ConnectionPoolException e) {
                ApprovalRequest approvalRequest = null;
                return approvalRequest;
            }
            finally {
                Closeables.close(matches);
            }
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OAuthAuthorization.OAuthClient client(Transaction txn, CompoundPrincipal principal, String clientId) {
        OAuthAuthorization.OAuthClient expected = null;
        Iterator<ResultRow> matches = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("client_id", clientId);
            matches = this.query(principal, VERIFY_CLIENT_STMT, parameters);
            if (matches.hasNext()) {
                expected = new OAuthAuthorization.OAuthClient();
                ResultRow row = matches.next();
                ColumnIterator columns = new ColumnIterator(row);
                expected.id = MultiTenantEntityPK.key((Long)columns.next(Long.class), (Long)columns.next(Long.class));
                expected.name = (String)columns.next(String.class);
                expected.description = (String)columns.next(String.class);
                expected.authFlow = ApprovalRequest.AuthFlow.valueOf((String)columns.next(String.class));
                expected.responseType = ApprovalRequest.ResponseType.valueOf((String)columns.next(String.class));
                expected.clientId = (String)columns.next(String.class);
                expected.secret = (String)columns.next(String.class);
                expected.redirectUri = (String)columns.next(String.class);
                expected.email = (String)columns.next(String.class);
                expected.scopes = this.clientScopes(txn, principal, expected.id);
            }
        }
        catch (ConnectionPoolException e) {
            OAuthAuthorization.OAuthClient oAuthClient = null;
            return oAuthClient;
        }
        finally {
            Closeables.close(matches);
        }
        return expected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createApprovalRequest(CompoundPrincipal principal, ApprovalRequest ar) {
        long tenantId = TenantPrincipal.id(TenantPrincipal.tenant((Principal)principal));
        JDBCTransaction txn = null;
        JDBCCall insert = null;
        try {
            Timestamp created = new Timestamp(System.currentTimeMillis());
            txn = this.jdbc.transaction((Principal)ApexListenerJDBCPrincipal.apexListener(principal));
            insert = this.jdbc.insert((Transaction)txn, CREATE_APPROVAL_STMT, new String[]{"ID"});
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("user_id", ar.userId());
            params.put("client_id", ar.clientKey().entityId());
            params.put("tenant_id", tenantId);
            params.put("created", created);
            insert.bind(params);
            Map keys = insert.execute();
            long approvalId = ((Number)keys.get("ID")).longValue();
            ar.id(MultiTenantEntityPK.key(tenantId, approvalId));
            JDBCCall insertScope = null;
            try {
                for (ApprovalRequest.Scope scope : ar.scopes()) {
                    insertScope = this.jdbc.insert((Transaction)txn, CREATE_APPROVAL_SCOPE_STMT, new String[0]);
                    HashMap<String, Comparable<Long>> parameters = new HashMap<String, Comparable<Long>>();
                    parameters.put("tenant_id", Long.valueOf(tenantId));
                    parameters.put("created", created);
                    parameters.put("approval_id", Long.valueOf(approvalId));
                    parameters.put("scope_id", Long.valueOf(scope.id().entityId()));
                    insertScope.bind(parameters);
                    insertScope.batch();
                }
                insertScope.execute();
            }
            finally {
                Closeables.close(insertScope);
            }
        }
        catch (SQLException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Closeable[]{insert, txn});
                throw throwable;
            }
        }
        Closeables.close((Object[])new Closeable[]{insert, txn});
    }

    @Override
    public void deleteApprovalRequest(CompoundPrincipal principal, MultiTenantEntityPK id) {
        JDBCTransaction txn = null;
        JDBCCall stmt = null;
        try {
            txn = this.jdbc.transaction((Principal)ApexListenerJDBCPrincipal.apexListener(principal));
            stmt = this.jdbc.call((Transaction)txn, DELETE_APPROVAL_STMT);
            HashMap<String, Long> parameters = new HashMap<String, Long>();
            parameters.put("tenant_id", id.tenantId());
            parameters.put("approval_id", id.entityId());
            stmt.bind(parameters);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Closeable[]{stmt, txn});
                throw throwable;
            }
        }
        Closeables.close((Object[])new Closeable[]{stmt, txn});
    }

    @Override
    public Transaction newTransaction(CompoundPrincipal principal) {
        try {
            return this.jdbc.transaction((Principal)ApexListenerJDBCPrincipal.apexListener(principal));
        }
        catch (SQLException e) {
            throw JDBCException.wrap((SQLException)e);
        }
    }

    @Override
    public ApprovalRequest updateStatus(CompoundPrincipal principal, MultiTenantEntityPK id, String expectedUserId, ApprovalRequest.Status newStatus, ApprovalRequest.Status ... expectedStatus) {
        JDBCCall update;
        Iterator matches;
        JDBCQuery query;
        JDBCTransaction txn;
        ApprovalRequest ar;
        block5: {
            ar = null;
            txn = null;
            query = null;
            matches = null;
            update = null;
            try {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("tenant_id", id.tenantId());
                parameters.put("approval_id", id.entityId());
                parameters.put("user_id", expectedUserId);
                txn = this.jdbc.transaction((Principal)ApexListenerJDBCPrincipal.apexListener(principal));
                query = this.jdbc.query((Transaction)txn, APPROVAL_BY_ID_STMT, false);
                query.bind(parameters);
                matches = query.execute();
                if (!matches.hasNext()) break block5;
                ResultRow row = (ResultRow)matches.next();
                ar = this.approvalRequest(row).userId(expectedUserId);
                if (this.expectedStatus(ar.status(), expectedStatus)) {
                    parameters.put("status", newStatus.toString());
                    update = this.jdbc.call((Transaction)txn, UPDATE_STATUS_STMT);
                    update.bind(parameters);
                    update.execute();
                    ar.status(newStatus);
                    break block5;
                }
                throw WebException.badRequest(new Reason[0]);
            }
            catch (SQLException e) {
                try {
                    throw WebException.internalError(e, new Reason[0]);
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new Object[]{update, matches, query, txn});
                    throw throwable;
                }
            }
        }
        Closeables.close((Object[])new Object[]{update, matches, query, txn});
        return ar;
    }

    @Override
    public Pair<String, String> createUserSession(CompoundPrincipal principal, String bearerToken, String refreshToken, ApprovalRequest ar) {
        Pair pair;
        JDBCTransaction txn = null;
        JDBCCall setBearer = null;
        try {
            txn = this.jdbc.transaction((Principal)ApexListenerJDBCPrincipal.apexListener(principal));
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("tenant_id", ar.id().tenantId());
            parameters.put("approval_id", ar.id().entityId());
            parameters.put("bearer_token", bearerToken);
            parameters.put("refresh_token", refreshToken);
            setBearer = this.jdbc.call((Transaction)txn, CREATE_USER_SESSION_STMT);
            setBearer.bind(parameters);
            setBearer.execute();
            pair = Pair.pair((Object)bearerToken, (Object)refreshToken);
        }
        catch (SQLException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Closeable[]{setBearer, txn});
                throw throwable;
            }
        }
        Closeables.close((Object[])new Closeable[]{setBearer, txn});
        return pair;
    }

    private ApprovalRequest approvalRequest(ResultRow row) {
        return ApprovalRequest.approvalRequest(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ApprovalRequest.Scope> approvalScopes(CompoundPrincipal principal, MultiTenantEntityPK id) {
        ArrayList<ApprovalRequest.Scope> scopes = new ArrayList<ApprovalRequest.Scope>();
        Iterator<ResultRow> matches = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("id", id.entityId());
            matches = this.query(principal, GET_APPROVAL_SCOPES_STMT, parameters);
            Iterator allScopes = null;
            allScopes = Iterators.transform(matches, (Transform)new RowToOAuthScope());
            Iterators.add(scopes, (Iterator)allScopes, (boolean)false);
        }
        finally {
            Closeables.close(matches);
        }
        return scopes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ApprovalRequest.Scope> clientScopes(Transaction txn, CompoundPrincipal principal, MultiTenantEntityPK id) {
        ArrayList<ApprovalRequest.Scope> scopes = new ArrayList<ApprovalRequest.Scope>();
        Iterator<ResultRow> matches = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("tenant_id", id.tenantId());
            parameters.put("id", id.entityId());
            matches = this.query(principal, GET_CLIENT_SCOPES_STMT, parameters);
            Iterator allScopes = null;
            allScopes = Iterators.transform(matches, (Transform)new RowToOAuthScope());
            Iterators.add(scopes, (Iterator)allScopes, (boolean)false);
        }
        finally {
            Closeables.close(matches);
        }
        return scopes;
    }

    private boolean expectedStatus(ApprovalRequest.Status actualStatus, ApprovalRequest.Status ... expectedStatuses) {
        for (ApprovalRequest.Status expectedStatus : expectedStatuses) {
            if (!expectedStatus.equals((Object)actualStatus)) continue;
            return true;
        }
        return false;
    }

    private Iterator<ResultRow> query(CompoundPrincipal principal, Statement stmt, Map<String, Object> parameters) {
        return this.query.query((Principal)ApexListenerJDBCPrincipal.apexListener(principal), stmt, parameters);
    }
}

