/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.client;

import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.oauth.OAuthProfile;
import oracle.dbtools.rt.oauth.client.Client;
import oracle.dbtools.rt.oauth.client.Clients;
import oracle.dbtools.rt.resource.collection.tenants.DeleteMultiTenantResource;
import oracle.dbtools.rt.web.RequestDispatcher;

@Service(provides={RequestDispatcher.class})
public class DeleteClient
extends DeleteMultiTenantResource<Client> {
    @Reference
    private Clients clients;

    public DeleteClient() {
        super(OAuthProfile.CLIENT_URI_TEMPLATES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void delete(CompoundPrincipal principal, Client existing) {
        Transaction txn = null;
        try {
            txn = this.clients.newTransaction(principal);
            this.clients.delete(txn, principal, existing.id());
        }
        catch (Throwable throwable) {
            Closeables.close(txn);
            throw throwable;
        }
        Closeables.close((Object)txn);
    }

    @Override
    protected Client existing(CompoundPrincipal principal, MultiTenantEntityPK id) {
        return this.clients.entity((Transaction)null, principal, id);
    }
}

