/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.client;

import java.io.IOException;
import java.util.Map;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.rt.locale.LocalePreference;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.TemplateResourceGenerator;

@Service(provides={RequestDispatcher.class})
public class ClientHandler
extends RequestHandler {
    static final String URI_PREFIX = "ui/oauth2/clients/";
    private static final URITemplate URI_TEMPLATE = new URITemplate("ui/oauth2/clients/{id}");
    private static final TemplateResourceGenerator TEMPLATE = TemplateResourceGenerator.templateFromUrl(ContentTypes.HTML, "ui/oauth2/clients/client.html");

    public ClientHandler() {
        super(HttpMethod.GET, SECURE_SESSION, URI_TEMPLATE, false);
    }

    @Override
    protected HttpResource dispatch(RequestEntity request) throws IOException {
        Map<String, String> properties = URI_TEMPLATE.decode(request.path());
        properties = TemplateResourceGenerator.globalProperties(properties);
        LocalePreference localePreference = LocalePreference.preference(request);
        return TEMPLATE.generate(localePreference, properties);
    }
}

