/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.bdb;

import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.oauth.ApprovalRequest;

class BuiltInScope {
    private final String description;
    private final MultiTenantEntityPK id;
    private final String name;
    private final ApprovalRequest.Scope scope;
    static final long _BUILTIN_TENANT = -2L;

    BuiltInScope(String name, String description, long id) {
        this.name = name;
        this.description = description;
        this.id = MultiTenantEntityPK.key(-2L, id);
        this.scope = ApprovalRequest.scope(this.name, this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuiltInScope other = (BuiltInScope)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BuiltInScope [description=");
        builder.append(this.description);
        builder.append(", id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append("]");
        return builder.toString();
    }

    String description() {
        return this.description;
    }

    MultiTenantEntityPK id() {
        return this.id;
    }

    String name() {
        return this.name;
    }

    ApprovalRequest.Scope scope() {
        return this.scope;
    }
}

