/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.bdb;

import com.sleepycat.persist.SecondaryIndex;
import java.util.ArrayList;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.home.DataStore;
import oracle.dbtools.rt.home.tenants.BaseMultiTenantEntityStorageProvider;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.oauth.ApprovalRequest;
import oracle.dbtools.rt.oauth.OAuthScopeProvider;
import oracle.dbtools.rt.oauth.scope.Scope;
import oracle.dbtools.rt.oauth.scope.ScopesProvider;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplate;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplates;

@Service(provides={BDBScopesProvider.class, ScopesProvider.class, OAuthScopeProvider.class})
public class BDBScopesProvider
extends BaseMultiTenantEntityStorageProvider<Scope>
implements OAuthScopeProvider,
ScopesProvider {
    @Reference
    private ResourceTemplates resourceTemplates;
    private SecondaryIndex<MultiTenantEntityPK, MultiTenantEntityPK, Scope> scopeByModuleId;
    private SecondaryIndex<String, MultiTenantEntityPK, Scope> scopeByName;

    @Override
    public Scope exists(Transaction txn, CompoundPrincipal principal, Scope instance) {
        return (Scope)this.scopeByName.get(DataStore.unwrap(txn), (Object)instance.name(), null);
    }

    @Override
    public MultiTenantEntityPK scopeForPath(CompoundPrincipal principal, String path) {
        Scope scope;
        MultiTenantEntityPK moduleId;
        MultiTenantEntityPK scopeId = null;
        ResourceTemplate match = this.resourceTemplates.resourceTemplate(principal, path);
        if (match != null && (moduleId = match.parentId()) != null && (scope = (Scope)this.scopeByModuleId.get((Object)moduleId)) != null) {
            scopeId = scope.id();
        }
        return scopeId;
    }

    @Override
    public Iterable<ApprovalRequest.Scope> scopes(CompoundPrincipal principal) {
        Transaction txn = this.store.newTransaction();
        ArrayList<ApprovalRequest.Scope> scopes = new ArrayList<ApprovalRequest.Scope>();
        Iterable allScopes = null;
        try {
            allScopes = this.entities.entities(txn, principal);
            for (Scope scope : allScopes) {
                MultiTenantEntityPK id = scope.id();
                String name = scope.name();
                ApprovalRequest.Scope s = new ApprovalRequest.Scope(id);
                s.description(scope.description());
                s.name(name);
                s.title(scope.name());
                scopes.add(s);
            }
        }
        catch (RuntimeException e) {
            try {
                txn.rollbackOnly();
                throw e;
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Object[]{allScopes, txn});
                throw throwable;
            }
        }
        Closeables.close((Object[])new Object[]{allScopes, txn});
        return scopes;
    }

    @Override
    protected void activate(ServiceProperties props) {
        super.activate(props);
        this.scopeByModuleId = this.entities.getSecondaryIndex(MultiTenantEntityPK.class, "modules");
        this.scopeByName = this.entities.getSecondaryIndex(String.class, "name");
    }

    @Override
    protected Class<Scope> entityType() {
        return Scope.class;
    }
}

