/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth.bdb;

import com.sleepycat.persist.SecondaryIndex;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Property;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.home.DataStore;
import oracle.dbtools.rt.home.EntityStorage;
import oracle.dbtools.rt.home.ExistingEntity;
import oracle.dbtools.rt.home.tenants.BaseMultiTenantEntityStorageProvider;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.oauth.bdb.Approval;

@Service(provides={Approvals.class, EntityStorage.class, ExistingEntity.class}, properties={@Property(name="oracle.dbtools.rt.home.ExistingEntity", value="oracle.dbtools.rt.oauth.bdb.Approval")})
public class Approvals
extends BaseMultiTenantEntityStorageProvider<Approval>
implements ExistingEntity<Approval> {
    private SecondaryIndex<String, MultiTenantEntityPK, Approval> approvalsbyBearerToken;
    private SecondaryIndex<String, MultiTenantEntityPK, Approval> approvalsbyRefreshToken;
    private SecondaryIndex<String, MultiTenantEntityPK, Approval> approvalsbyUserId;

    @Override
    protected Class<Approval> entityType() {
        return Approval.class;
    }

    public Approval byBearerToken(Transaction txn, String bearerToken) {
        Approval approval = (Approval)this.approvalsbyBearerToken.get(DataStore.unwrap(txn), (Object)bearerToken, null);
        return approval;
    }

    public Approval byRefreshToken(Transaction txn, String refreshToken) {
        Approval approval = (Approval)this.approvalsbyRefreshToken.get(DataStore.unwrap(txn), (Object)refreshToken, null);
        return approval;
    }

    public Iterable<Approval> forUserId(Transaction txn, String userId) {
        return this.approvalsbyUserId.entities(DataStore.unwrap(txn), (Object)userId, true, (Object)userId, true, null);
    }

    @Override
    protected void activate(ServiceProperties props) {
        super.activate(props);
        this.approvalsbyBearerToken = this.entities.getSecondaryIndex(String.class, "bearerToken");
        this.approvalsbyRefreshToken = this.entities.getSecondaryIndex(String.class, "refreshToken");
        this.approvalsbyUserId = this.entities.getSecondaryIndex(String.class, "userId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Approval exists(Transaction txn, CompoundPrincipal principal, Approval instance) {
        Iterable<Approval> forUserId = this.forUserId(txn, instance.userId());
        try {
            for (Approval approval : forUserId) {
                if (approval.clientId() != instance.clientId()) continue;
                Approval approval2 = approval;
                return approval2;
            }
            Approval approval = null;
            return approval;
        }
        finally {
            Closeables.close(forUserId);
        }
    }
}

