/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import java.io.IOException;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.oauth.OAuthProvider;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.SecurityConstraint;

@Service(provides={RequestDispatcher.class})
public class TokenHandler
extends RequestHandler {
    @Reference
    private OAuthProvider oauth;
    private static final RequestHandler.SecurityConfig CLIENT_AUTH = new RequestHandler.SecurityConfig(SecurityConstraint.SECURE, AuthenticationRealm.OAUTH_CLIENT, null);
    private static final URITemplate URI_TEMPLATE = new URITemplate("oauth2/token");

    public TokenHandler() {
        super(HttpMethod.POST, CLIENT_AUTH, URI_TEMPLATE, false);
    }

    @Override
    protected HttpResource dispatch(final RequestEntity request) throws IOException {
        return new HttpResource(){

            @Override
            public String version() {
                return null;
            }

            @Override
            public Entity response() throws IOException {
                return TokenHandler.this.oauth.tokenRequest(request);
            }
        };
    }
}

