/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.authentication.Authenticates;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.AuthenticatorBase;
import oracle.dbtools.rt.authentication.Principals;
import oracle.dbtools.rt.authentication.RealmAuthenticator;
import oracle.dbtools.rt.oauth.CompoundPrincipalCallback;
import oracle.dbtools.rt.oauth.bdb.BDBClientsProvider;
import oracle.dbtools.rt.oauth.client.Client;
import oracle.dbtools.rt.oauth.client.Clients;
import oracle.dbtools.rt.oauth.client.ClientsProvider;

@Service
@Authenticates(value=AuthenticationRealm.OAUTH_CLIENT)
public class OAuthClientAuthenticator
extends AuthenticatorBase
implements RealmAuthenticator {
    @Override
    public Iterable<Principal> authenticate(CallbackHandler callbackHandler) {
        Clients clients;
        NameCallback n = new NameCallback("username");
        PasswordCallback p = new PasswordCallback("password", false);
        CompoundPrincipalCallback cp = new CompoundPrincipalCallback();
        Callback[] callbacks = new Callback[]{n, p, cp};
        try {
            callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw this.wrap(e);
        }
        catch (UnsupportedCallbackException e) {
            throw this.wrap(e);
        }
        String name = n.getName();
        CompoundPrincipal requestPrincipal = cp.getPrincipal();
        char[] pwd = p.getPassword();
        if (name != null && requestPrincipal != null && pwd != null && (clients = (Clients)ServiceLocator.acquire(Clients.class)) != null) {
            String password;
            Client client = clients.byClientId(null, requestPrincipal, name);
            if (client == null) {
                ClientsProvider builtIn = (ClientsProvider)ServiceLocator.acquire(BDBClientsProvider.class);
                client = builtIn.byClientId(null, requestPrincipal, name);
            }
            if (client != null && (password = new String(pwd)).equals(client.clientSecret())) {
                return this.principals(Principals.user(name));
            }
        }
        return null;
    }
}

