/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.ServiceLocatorException;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Collections;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Identifiers;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.AuthenticationService;
import oracle.dbtools.rt.authentication.BaseHandler;
import oracle.dbtools.rt.authorization.AuthorizationPolicy;
import oracle.dbtools.rt.authorization.ScopeAuthorizationPolicy;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.json.JSONBuilder;
import oracle.dbtools.rt.json.JSONFormatter;
import oracle.dbtools.rt.locale.LocalePreference;
import oracle.dbtools.rt.oauth.ApprovalRequest;
import oracle.dbtools.rt.oauth.BearerTokenVerification;
import oracle.dbtools.rt.oauth.OAuthDataAccess;
import oracle.dbtools.rt.oauth.OAuthException;
import oracle.dbtools.rt.oauth.OAuthProvider;
import oracle.dbtools.rt.oauth.OAuthScopeProvider;
import oracle.dbtools.rt.oauth.bdb.BDBOAuthDataAccess;
import oracle.dbtools.rt.oauth.bdb.BuiltInScopes;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;

@Service
public class OAuthAuthorization
implements OAuthProvider {
    @Reference
    private OAuthDataAccess data;
    private OAuthDataAccess builtIn;
    private static final String NATIVE_CLIENT_REDIRECT = "urn:ietf:wg:oauth:2.0:oob";

    @Override
    public final void approveRequest(RequestEntity request) {
        ApprovalRequest.Status expectedStatus = ApprovalRequest.Status.PENDING;
        ApprovalRequest.Status newStatus = ApprovalRequest.Status.DENIED;
        String userId = Requests.remoteUser(request);
        MultiTenantEntityPK id = null;
        List<Pair<String, Object>> formFields = Requests.formFields(request);
        for (Pair<String, Object> field : formFields) {
            String name = (String)field.first();
            String text = field.second().toString();
            if ("user_client_id".equalsIgnoreCase(name)) {
                id = MultiTenantEntityPK.valueOf(text);
            }
            if (!"decision".equalsIgnoreCase(name) || !"allow_access".equalsIgnoreCase(text)) continue;
            newStatus = ApprovalRequest.Status.APPROVED;
        }
        CompoundPrincipal principal = request.principal();
        ApprovalRequest ar = this.data.updateStatus(principal, id, userId, newStatus, expectedStatus);
        try {
            if (ar == null) {
                throw WebException.badRequest(new Reason[0]);
            }
            if (ar.status() != ApprovalRequest.Status.APPROVED) {
                throw this.accessDenied(ar);
            }
            this.setBearerTokenAndRedirect(principal, ar);
        }
        catch (OAuthException e) {
            throw this.redirect(ar, e);
        }
    }

    @Override
    public final ApprovalRequest pendingRequest(RequestEntity request) {
        ApprovalRequest ar = ApprovalRequest.approvalRequest(request);
        try {
            this.verifyClient(this.data, request.principal(), ar);
            String userId = Requests.remoteUser(request);
            CompoundPrincipal principal = request.principal();
            if (!this.authorizeScopes(principal, ar.scopes())) {
                throw this.accessDenied(ar);
            }
            ar.userId(userId);
            ApprovalRequest.Status status = this.checkForExistingApproval(this.data, principal, ar);
            if (status == null) {
                this.data.createApprovalRequest(principal, ar);
            } else {
                switch (status) {
                    case PENDING: {
                        break;
                    }
                    case DENIED: {
                        throw this.accessDenied(ar);
                    }
                    case APPROVED: {
                        this.setBearerTokenAndRedirect(principal, ar);
                    }
                }
            }
            return ar;
        }
        catch (OAuthException e) {
            throw this.redirect(ar, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Entity tokenRequest(RequestEntity request) {
        LocalePreference localePreference = LocalePreference.preference(request);
        Transaction txn = null;
        try {
            Entity response = null;
            TokenRequest tokenRequest = new TokenRequest();
            String clientId = Requests.remoteUser(request);
            Pair<OAuthClient, Transaction> clientAndTxn = this.client(request.principal(), clientId);
            tokenRequest.client = (OAuthClient)clientAndTxn.first();
            txn = (Transaction)clientAndTxn.second();
            List<Pair<String, Object>> formFields = Requests.formFields(request);
            for (Pair<String, Object> field : formFields) {
                String name = (String)field.first();
                String text = field.second().toString();
                if ("grant_type".equals(name)) {
                    tokenRequest.grantType = GrantType.valueOf(text.toUpperCase());
                    continue;
                }
                if ("code".equals(name)) {
                    tokenRequest.code = text;
                    continue;
                }
                if ("redirect_uri".equals(name)) {
                    tokenRequest.redirectUri = text;
                    continue;
                }
                if ("username".equals(name)) {
                    tokenRequest.username = text;
                    continue;
                }
                if ("password".equals(name)) {
                    tokenRequest.password = text.toCharArray();
                    continue;
                }
                if ("scope".equals(name)) {
                    tokenRequest.scopes = Arrays.asList(Text.spaceDelimited((String)text));
                    continue;
                }
                if (!"refresh_token".equals(name)) continue;
                tokenRequest.refreshToken = text;
            }
            switch (tokenRequest.grantType) {
                case PASSWORD: {
                    response = this.resourceOwnerCredentials(txn, tokenRequest, request);
                    break;
                }
                case REFRESH_TOKEN: {
                    response = this.refreshToken(txn, tokenRequest, request);
                    break;
                }
                default: {
                    throw WebException.serviceUnavailable();
                }
            }
            Entity entity = response;
            Closeables.close((Object)txn);
            return entity;
        }
        catch (OAuthException e) {
            Entity entity = OAuthException.render(e, localePreference);
            return entity;
        }
        finally {
            Closeables.close(txn);
        }
    }

    private Pair<OAuthClient, Transaction> client(CompoundPrincipal principal, String clientId) {
        Transaction txn = this.data.newTransaction(principal);
        OAuthClient client = this.data.client(txn, principal, clientId);
        if (client == null) {
            Closeables.close((Object)txn);
        }
        if (client == null && this.builtIn != null) {
            txn = this.builtIn.newTransaction(principal);
            client = this.builtIn.client(txn, principal, clientId);
        }
        return Pair.pair((Object)client, (Object)txn);
    }

    @Override
    public final BearerTokenVerification validateBearerToken(CompoundPrincipal principal, MultiTenantEntityPK scopeId, String bearerToken) {
        if (this.builtIn != null && BuiltInScopes.isBuiltIn(scopeId)) {
            return this.builtIn.accessGranted(principal, scopeId, bearerToken);
        }
        return this.data.accessGranted(principal, scopeId, bearerToken);
    }

    protected Map<MultiTenantEntityPK, ApprovalRequest.Scope> scopes(CompoundPrincipal principal) {
        ArrayList allScopes = new ArrayList();
        Iterable scopeProviders = ServiceLocator.acquireAll(OAuthScopeProvider.class, (String[])new String[0]);
        for (OAuthScopeProvider scopeProvider : scopeProviders) {
            Iterables.add(allScopes, scopeProvider.scopes(principal));
        }
        HashMap<MultiTenantEntityPK, ApprovalRequest.Scope> scopes = new HashMap<MultiTenantEntityPK, ApprovalRequest.Scope>();
        for (ApprovalRequest.Scope scope : allScopes) {
            scopes.put(scope.id(), scope);
        }
        return scopes;
    }

    private final OAuthException accessDenied(ApprovalRequest ar) {
        return OAuthException.error(OAuthException.Error.ACCESS_DENIED);
    }

    private Pair<String, String> assignTokens(OAuthDataAccess data, CompoundPrincipal principal, ApprovalRequest ar) {
        String bearerToken = Identifiers.randomIdentifier();
        String refreshToken = null;
        if (ar.responseType() == ApprovalRequest.ResponseType.CODE) {
            refreshToken = Identifiers.randomIdentifier();
        }
        return data.createUserSession(principal, bearerToken, refreshToken, ar);
    }

    private boolean authorizeScope(CompoundPrincipal principal, MultiTenantEntityPK scopeId) {
        AuthorizationPolicy.Access access = AuthorizationPolicy.Access.PRINCIPAL_UNKNOWN;
        for (ScopeAuthorizationPolicy policy : ServiceLocator.acquireAll(ScopeAuthorizationPolicy.class, (String[])new String[0])) {
            AuthorizationPolicy.Access result = policy.authorize((Principal)principal, scopeId);
            if (AuthorizationPolicy.Access.PRINCIPAL_UNKNOWN == result) continue;
            access = result;
            break;
        }
        return AuthorizationPolicy.Access.NONE != access && AuthorizationPolicy.Access.PRINCIPAL_UNKNOWN != access;
    }

    private boolean authorizeScopes(CompoundPrincipal principal, Collection<ApprovalRequest.Scope> requestedScopes) {
        boolean allAuthorized = false;
        for (ApprovalRequest.Scope requestedScope : requestedScopes) {
            boolean authorized;
            allAuthorized = authorized = this.authorizeScope(principal, requestedScope.id());
            if (authorized) continue;
            break;
        }
        return allAuthorized;
    }

    private final ApprovalRequest.Status checkForExistingApproval(OAuthDataAccess data, CompoundPrincipal principal, ApprovalRequest ar) {
        ApprovalRequest existing = data.approvalRequest(principal, ar.userId(), ar.clientId());
        if (existing != null) {
            boolean sameScopes = OAuthAuthorization.sameScopes(existing.scopes(), ar.scopes());
            ApprovalRequest.Status status = existing.status();
            switch (status) {
                case PENDING: {
                    break;
                }
                case DENIED: 
                case APPROVED: {
                    if (sameScopes) break;
                    data.deleteApprovalRequest(principal, existing.id());
                    return null;
                }
            }
            ar.id(existing.id());
            return status;
        }
        return null;
    }

    private Entity generateTokens(OAuthDataAccess data, CompoundPrincipal principal, ApprovalRequest ar) {
        Pair<String, String> tokens = this.assignTokens(data, principal, ar);
        String bearerToken = (String)tokens.first();
        String refreshToken = (String)tokens.second();
        String[] parameters = new String[]{"access_token", bearerToken, "token_type", "bearer", "refresh_token", refreshToken};
        return OAuthAuthorization.jsonEntity(parameters);
    }

    private OAuthException invalidRequest(ApprovalRequest ar) {
        return OAuthException.error(OAuthException.Error.INVALID_REQUEST);
    }

    private WebException redirect(ApprovalRequest ar, OAuthException e) {
        boolean fragment = ApprovalRequest.ResponseType.TOKEN == ar.responseType();
        String redirectUri = ar.redirectUri();
        return OAuthException.redirect(fragment, redirectUri, e);
    }

    private void redirectToClient(String bearerToken, ApprovalRequest ar) {
        ArrayList<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();
        parameters.add(Pair.pair((Object)"token_type", (Object)"bearer"));
        parameters.add(Pair.pair((Object)"access_token", (Object)bearerToken));
        String state = ar.state();
        if (state != null) {
            parameters.add(Pair.pair((Object)"state", (Object)state));
        }
        boolean useFragment = ar.responseType().equals((Object)ApprovalRequest.ResponseType.TOKEN);
        String redirectUri = this.redirectUri(ar);
        throw OAuthException.redirect(useFragment, redirectUri, parameters);
    }

    private String redirectUri(ApprovalRequest ar) {
        String redirectUri = ar.redirectUri();
        if (NATIVE_CLIENT_REDIRECT.equals(redirectUri)) {
            return "oauth2/native";
        }
        return redirectUri;
    }

    private Entity refreshToken(Transaction txn, TokenRequest tokenRequest, RequestEntity request) {
        ApprovalRequest ar = this.data.approvalRequest(request.principal(), txn, tokenRequest.client, tokenRequest.refreshToken);
        if (ar == null) {
            throw OAuthException.error(OAuthException.Error.INVALID_GRANT);
        }
        return this.generateTokens(this.data, request.principal(), ar);
    }

    private CompoundPrincipal replace(CompoundPrincipal principal, CompoundPrincipal existingPrincipal, Class<? extends Principal> type) {
        Principal existing = existingPrincipal.principal(type);
        if (existing != null) {
            principal = principal.replace(type, existing);
        }
        return principal;
    }

    private Entity resourceOwnerCredentials(Transaction txn, TokenRequest tokenRequest, RequestEntity request) {
        Pair credentials = Pair.pair((Object)tokenRequest.username, (Object)tokenRequest.password);
        BaseHandler cb = new BaseHandler(request, credentials){};
        AuthenticationService auth = (AuthenticationService)ServiceLocator.acquire(AuthenticationService.class);
        Subject subject = auth.authenticate(AuthenticationRealm.RESOURCE_OWNER, cb);
        CompoundPrincipal principal = CompoundPrincipal.compound(AuthenticationService.principals(subject));
        if (principal != null) {
            ApprovalRequest.Builder b = ApprovalRequest.builder();
            b.clientId(tokenRequest.client.clientId);
            b.clientSecret(new String(tokenRequest.password));
            b.userId(tokenRequest.username);
            ApprovalRequest ar = b.build();
            List<ApprovalRequest.Scope> requestedScopes = tokenRequest.client.scopes;
            CompoundPrincipal existingPrincipal = request.principal();
            principal = this.replace(principal, existingPrincipal, JDBCPrincipal.class);
            principal = this.replace(principal, existingPrincipal, TenantPrincipal.class);
            boolean builtInScope = this.builtInScopeOnly(requestedScopes);
            OAuthDataAccess data = this.data;
            if (builtInScope) {
                data = this.builtIn;
            }
            if (this.authorizeScopes(principal, requestedScopes)) {
                this.verifyClient(data, existingPrincipal, ar);
                ApprovalRequest.Status status = this.checkForExistingApproval(data, principal, ar);
                if (status == null) {
                    data.createApprovalRequest(principal, ar);
                }
                ar = data.updateStatus(principal, ar.id(), ar.userId(), ApprovalRequest.Status.APPROVED, ApprovalRequest.Status.PENDING, ApprovalRequest.Status.APPROVED);
                return this.generateTokens(data, principal, ar);
            }
            throw this.accessDenied(ar);
        }
        throw OAuthException.error(OAuthException.Error.INVALID_GRANT).description(new TranslatableMessage(ResourceTemplateMessages.class, "OQuthAuthorization.0", "Invalid resource owner credentials", new Object[0]));
    }

    private boolean builtInScopeOnly(List<ApprovalRequest.Scope> requestedScopes) {
        boolean builtInOnly = false;
        for (ApprovalRequest.Scope scope : requestedScopes) {
            builtInOnly = BuiltInScopes.isBuiltIn(scope.id());
        }
        return builtInOnly;
    }

    private void setBearerTokenAndRedirect(CompoundPrincipal principal, ApprovalRequest ar) {
        String bearerToken = Identifiers.randomIdentifier();
        String refreshToken = Identifiers.randomIdentifier();
        Pair<String, String> tokens = this.data.createUserSession(principal, bearerToken, refreshToken, ar);
        this.redirectToClient((String)tokens.first(), ar);
    }

    private void verifyClient(OAuthDataAccess data, CompoundPrincipal principal, ApprovalRequest ar) {
        String clientId = ar.clientId();
        OAuthClient expected = data.client(null, principal, clientId);
        if (expected == null) {
            throw this.invalidRequest(ar);
        }
        if (!expected.responseType.equals((Object)ar.responseType())) {
            throw this.invalidRequest(ar);
        }
        if (ApprovalRequest.ResponseType.TOKEN == ar.responseType()) {
            this.verifyUri(expected.redirectUri, ar);
        }
        ar.scopes().clear();
        ar.scopes().addAll(expected.scopes);
        ar.clientKey(expected.id).name(expected.name).description(expected.description).email(expected.email);
    }

    private void verifyUri(String expectedRedirect, ApprovalRequest ar) {
        URI expectedUri = URIs.create((String)expectedRedirect);
        String actualRedirect = ar.redirectUri();
        if (NullOrEmpty.nullOrEmpty((CharSequence)actualRedirect)) {
            ar.redirectUri(expectedRedirect);
        } else {
            if (NullOrEmpty.nullOrEmpty((CharSequence)expectedRedirect)) {
                throw this.accessDenied(ar);
            }
            URI actualUri = URIs.create((String)actualRedirect);
            if (!URIs.within((URI)expectedUri, (URI)actualUri)) {
                throw this.accessDenied(ar);
            }
        }
    }

    public static BearerTokenVerification verifyApproval(MultiTenantEntityPK scopeId, Timestamp expiry, Timestamp now, String userId, List<MultiTenantEntityPK> scopes) {
        boolean authorized = false;
        boolean expired = true;
        for (MultiTenantEntityPK approvedScope : scopes) {
            if (!scopeId.equals(approvedScope)) continue;
            authorized = true;
            if (!expiry.after(now)) break;
            expired = false;
            break;
        }
        BearerTokenVerification.Status status = BearerTokenVerification.Status.EXPIRED;
        if (!expired) {
            status = BearerTokenVerification.Status.VALID;
        } else if (!authorized) {
            status = BearerTokenVerification.Status.INSUFFICENT_AUTHORITY;
        }
        return BearerTokenVerification.verification(userId, status);
    }

    static Entity jsonEntity(String ... parameters) {
        JSONBuilder json = JSONBuilder.o();
        for (int i = 0; i < parameters.length; ++i) {
            String value;
            String name = parameters[i];
            if ((value = parameters[++i]) == null) continue;
            json.p(name, JSONBuilder.v(value));
        }
        StringWriter text = new StringWriter();
        JSONBuilder.render(new JSONFormatter(text), json.build());
        try {
            return Entities.entity(StreamCopy.toInputStream((String)text.toString()), Entities.headers(HttpHeader.CONTENT_TYPE, ContentTypes.JSON));
        }
        catch (IOException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    private static boolean sameScopes(Set<ApprovalRequest.Scope> expected, Collection<ApprovalRequest.Scope> actual) {
        if (expected.size() == actual.size()) {
            Set difference = (Set)Collections.clone(expected);
            difference.removeAll(actual);
            return difference.size() == 0;
        }
        return false;
    }

    protected void activate(ServiceProperties properties) {
        try {
            this.builtIn = (OAuthDataAccess)ServiceLocator.acquire(BDBOAuthDataAccess.class);
        }
        catch (ServiceLocatorException e) {
            this.builtIn = null;
        }
    }

    private static class TokenRequest {
        public List<String> scopes;
        OAuthClient client;
        String code;
        GrantType grantType;
        char[] password;
        String redirectUri;
        String refreshToken;
        String username;

        private TokenRequest() {
        }
    }

    public static class OAuthClient {
        public ApprovalRequest.AuthFlow authFlow;
        public String clientId;
        public String description;
        public String email;
        public MultiTenantEntityPK id;
        public String name;
        public String redirectUri;
        public ApprovalRequest.ResponseType responseType;
        public List<ApprovalRequest.Scope> scopes;
        public String secret;
    }

    public static enum GrantType {
        AUTHORIZATION_CODE,
        CLIENT_CREDENTIALS,
        PASSWORD,
        REFRESH_TOKEN;

    }
}

