/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import java.io.IOException;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.oauth.OAuthProvider;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.WebException;

@Service(provides={RequestDispatcher.class})
public class ApprovalHandler
extends RequestHandler {
    @Reference
    private OAuthProvider oauth;
    public static final String PATH = "oauth2/approval";
    private static final URITemplate URI_TEMPLATE = new URITemplate("oauth2/approval");

    public ApprovalHandler() {
        super(HttpMethod.POST, SECURE_SESSION, URI_TEMPLATE, true);
    }

    @Override
    protected HttpResource dispatch(RequestEntity request) throws IOException {
        this.oauth.approveRequest(request);
        throw WebException.badRequest(Reason.reason("user_client_id", new TranslatableMessage(ResourceTemplateMessages.class, "ApprovalHandler.0", "Bad user client id", new Object[0])));
    }
}

