/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.x3p.X3PElement;
import oracle.dbtools.common.x3p.X3PFactory;
import oracle.dbtools.common.x3p.X3PPath;
import oracle.dbtools.common.x3p.X3PReader;
import oracle.dbtools.common.x3p.X3PSelector;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.entity.EntityHeadersBuilder;
import oracle.dbtools.rt.json.xml.JSONProfile;
import oracle.dbtools.rt.json.xml.XMLToJSONStream;
import oracle.dbtools.rt.transcode.Transcoder;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.QueryString;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

@Service(provides={XMLToJSON.class, Transcoder.class})
public class XMLToJSON
implements Transcoder {
    private final List<X3PPath> multiples = new ArrayList<X3PPath>();
    private final List<X3PSelector> rewrites = new ArrayList<X3PSelector>();
    private final Profile profile = new Profile();
    private static final String ALT = "alt";
    private static final String JSON = "json";

    public Entity apply(Entity entity) {
        try {
            ContentType contentType;
            EntityHeaders headers = entity.headers();
            EntityHeader mediaType = headers.header(HttpHeader.CONTENT_TYPE);
            if (mediaType != null && (contentType = ContentType.contentType(headers.header(HttpHeader.CONTENT_TYPE).value())).matches(ContentTypes.XML_TYPES)) {
                EntityHeader documentBase = entity.headers().header("X-APEX-DOC-BASE");
                String docBase = null;
                if (documentBase == null) {
                    throw new IllegalStateException("X-APEX-DOC-BASE header is missing");
                }
                docBase = documentBase.value();
                JSONProfile profile = this.profile();
                X3PReader r = X3PFactory.newReader((InputStream)entity.body());
                XMLToJSONStream s = new XMLToJSONStream(r, docBase, profile);
                return Entities.entity((InputStream)((Object)s), this.transform(headers, profile));
            }
            return entity;
        }
        catch (IOException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    @Override
    public boolean canTransform(ContentType from, ContentType ... to) {
        return from.matches(ContentTypes.XML_TYPES) && ContentType.matches(ContentTypes.JSON_TYPES, to);
    }

    public XMLToJSON multipleElements(X3PPath ... paths) {
        Collections.addAll(this.multiples, paths);
        return this;
    }

    public XMLToJSON rewritePath(X3PSelector ... selectors) {
        Collections.addAll(this.rewrites, selectors);
        return this;
    }

    private EntityHeadersBuilder mutatePath(EntityHeader location, EntityHeadersBuilder b) {
        if (location != null) {
            String path = location.value();
            path = XMLToJSON.mutatePath(path);
            b.header((CharSequence)location.name(), path);
        }
        return b;
    }

    static String mutatePath(String path) {
        QueryString existing = QueryString.parse(path);
        QueryString json = existing.replace(ALT, JSON);
        return json.toString();
    }

    private JSONProfile profile() {
        return this.profile;
    }

    private EntityHeaders transform(EntityHeaders headers, JSONProfile profile) {
        EntityHeader location = headers.header(HttpHeader.LOCATION);
        EntityHeadersBuilder b = Entities.headers();
        this.mutatePath(location, b);
        b.header((CharSequence)HttpHeader.CONTENT_TYPE, ContentTypes.JSON);
        return Entities.merge(headers, b.build());
    }

    static String match(String path) {
        QueryString existing = QueryString.parse(path);
        if (JSON.equals(existing.get(ALT))) {
            return existing.remove(ALT, JSON).toString();
        }
        return null;
    }

    private final class Profile
    implements JSONProfile {
        private Profile() {
        }

        @Override
        public boolean hasMultipleElements(X3PPath path) {
            return XMLToJSON.this.multiples.contains(path);
        }

        @Override
        public boolean rewriteHref(X3PElement element) {
            return Iterables.select((Iterable)XMLToJSON.this.rewrites, (Selector)element) != null;
        }
    }
}

