/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json;

import java.io.IOException;
import java.io.Reader;
import oracle.dbtools.common.util.StreamCopy;

abstract class JSONEncoder {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private JSONEncoder() {
    }

    public static CharSequence encode(Reader text) {
        try {
            return JSONEncoder.encode(StreamCopy.string((Reader)text));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static CharSequence encode(CharSequence text) {
        int charCount;
        StringBuilder b = new StringBuilder();
        int pos = 0;
        int len = text.length();
        block9: for (int i = 0; i < len; i += charCount) {
            int codePoint = Character.codePointAt(text, i);
            charCount = Character.charCount(codePoint);
            if (!JSONEncoder.isControlCharacter(codePoint) && !JSONEncoder.mustEscape(codePoint)) continue;
            b.append(text, pos, i);
            pos = i + charCount;
            switch (codePoint) {
                case 8: {
                    b.append("\\b");
                    continue block9;
                }
                case 9: {
                    b.append("\\t");
                    continue block9;
                }
                case 10: {
                    b.append("\\n");
                    continue block9;
                }
                case 12: {
                    b.append("\\f");
                    continue block9;
                }
                case 13: {
                    b.append("\\r");
                    continue block9;
                }
                case 92: {
                    b.append("\\\\");
                    continue block9;
                }
                case 34: {
                    b.append("\\\"");
                    continue block9;
                }
                default: {
                    JSONEncoder.toHex(b, codePoint);
                }
            }
        }
        b.append(text, pos, len);
        return b;
    }

    private static boolean isControlCharacter(int codePoint) {
        return codePoint < 32 || codePoint == 8232 || codePoint == 8233 || codePoint >= 127 && codePoint <= 159;
    }

    private static boolean mustEscape(int codepoint) {
        if (!Character.isSupplementaryCodePoint(codepoint)) {
            char c = (char)codepoint;
            return '\"' == c || '\\' == c;
        }
        return false;
    }

    private static void toHex(StringBuilder b, int codePoint) {
        if (Character.isSupplementaryCodePoint(codePoint)) {
            char[] surrogates = Character.toChars(codePoint);
            JSONEncoder.toHex(b, surrogates[0]);
            JSONEncoder.toHex(b, surrogates[1]);
            return;
        }
        b.append("\\u").append(HEX_CHARS[codePoint >>> 12 & 0xF]).append(HEX_CHARS[codePoint >>> 8 & 0xF]).append(HEX_CHARS[codePoint >>> 4 & 0xF]).append(HEX_CHARS[codePoint & 0xF]);
    }
}

