/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json;

import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.StringBuilders;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.json.FalseValue;
import oracle.dbtools.rt.json.JSONArray;
import oracle.dbtools.rt.json.JSONFormatter;
import oracle.dbtools.rt.json.JSONNode;
import oracle.dbtools.rt.json.JSONObject;
import oracle.dbtools.rt.json.JSONProperty;
import oracle.dbtools.rt.json.JSONValue;
import oracle.dbtools.rt.json.NullValue;
import oracle.dbtools.rt.json.TrueValue;

public final class JSONBuilder {
    private final JSONNode root;
    public static final String TEXT = "$t";
    private static final ObjectToJsonValue OBJECT_TO_JSON_VALUE = new ObjectToJsonValue();

    private JSONBuilder(JSONNode root) {
        this.root = root;
    }

    public JSONNode build() {
        return this.root;
    }

    public <T> JSONBuilder p(QName name, JSONValue<T> value) {
        this.object().add(name, value);
        return this;
    }

    public <T> JSONBuilder p(String name, JSONValue<T> value) {
        return this.p(new QName(name), value);
    }

    public String toString() {
        return JSONBuilder.render(this.root);
    }

    private final JSONObject object() {
        if (this.root.getType() == JSONNode.Type.OBJECT) {
            return (JSONObject)this.root;
        }
        throw new IllegalStateException("This is an array");
    }

    public static <T> JSONBuilder a(T ... values) {
        return JSONBuilder.a(Iterables.transform(Arrays.asList(values), (Transform)new Transform<T, JSONValue<?>>(){

            public JSONValue<?> apply(T x) {
                return JSONBuilder.v(x);
            }
        }));
    }

    public static JSONBuilder a(Iterable<JSONValue<?>> values) {
        return new JSONBuilder(new JSONArray(values));
    }

    public static JSONBuilder o() {
        return new JSONBuilder(new JSONObject());
    }

    public static void render(JSONFormatter w, JSONNode node) {
        if (node.getType() == JSONNode.Type.OBJECT) {
            JSONObject object = (JSONObject)node;
            w.start();
            Collection<JSONProperty> properties = object.properties();
            JSONBuilder.render(w, properties);
            w.end();
        } else {
            Iterable<JSONValue<?>> values = ((JSONArray)node).values();
            w.startArray();
            for (JSONValue<?> i : values) {
                JSONBuilder.render(w, i);
            }
            w.endArray();
        }
    }

    public static void render(JSONFormatter w, Iterable<JSONProperty> properties) {
        for (JSONProperty p : properties) {
            JSONValue<?> value = p.value();
            if (value.type() == JSONValue.Type.NULL || value.value() == null) continue;
            w.name(p.name());
            JSONBuilder.render(w, value);
        }
    }

    public static String render(JSONNode object) {
        byte[] octets = JSONBuilder.toByteArray(object);
        return new String(octets, Charset.forName("UTF-8"));
    }

    public static byte[] toByteArray(JSONNode object) {
        StringBuilder b = new StringBuilder();
        JSONFormatter w = new JSONFormatter(b);
        JSONBuilder.render(w, object);
        w.flush();
        byte[] octets = StringBuilders.bytes((StringBuilder)b);
        return octets;
    }

    public static JSONValue<?> v(Boolean value) {
        return value != false ? TrueValue.TRUE : FalseValue.FALSE;
    }

    public static JSONValue<?> v(JSONBuilder value) {
        return new JSONValue(JSONValue.Type.NODE, value.build());
    }

    public static JSONValue<?> v(Number value) {
        return new JSONValue(JSONValue.Type.NUMBER, value);
    }

    public static JSONValue<?> v(Object value) {
        if (value == null) {
            return NullValue.NULL;
        }
        if (value.getClass().equals(Boolean.class)) {
            return JSONBuilder.v((Boolean)value);
        }
        if (value instanceof Number) {
            return JSONBuilder.v((Number)value);
        }
        if (value.getClass().equals(JSONBuilder.class)) {
            return JSONBuilder.v((JSONBuilder)value);
        }
        if (value.getClass().isArray()) {
            Object[] arrayValues = (Object[])value;
            return JSONBuilder.v(JSONBuilder.a(Iterables.transform((Iterable)Iterables.iterable((Object[])arrayValues), (Transform)OBJECT_TO_JSON_VALUE)));
        }
        if (value instanceof Reader) {
            return JSONBuilder.v((Reader)value);
        }
        return JSONBuilder.v(value.toString());
    }

    public static JSONValue<?> v(Reader value) {
        return new JSONValue(JSONValue.Type.STRING, value);
    }

    public static JSONValue<?> v(String value) {
        return new JSONValue(JSONValue.Type.STRING, value);
    }

    private static void render(JSONFormatter w, JSONValue<?> value) {
        Object theValue = value.value();
        switch (value.type()) {
            case FALSE: 
            case TRUE: {
                w.value((Boolean)theValue);
                break;
            }
            case NULL: {
                w.value((CharSequence)null);
                break;
            }
            case NUMBER: {
                w.value((Number)theValue);
                break;
            }
            case NODE: {
                JSONBuilder.render(w, (JSONNode)theValue);
                break;
            }
            default: {
                if (theValue == null) {
                    w.value((CharSequence)null);
                    break;
                }
                if (theValue instanceof Reader) {
                    w.value((Reader)theValue);
                    break;
                }
                w.value(theValue.toString());
            }
        }
    }

    private static class ObjectToJsonValue
    implements Transform<Object, JSONValue<?>> {
        private ObjectToJsonValue() {
        }

        public JSONValue<?> apply(Object x) {
            return JSONBuilder.v(x);
        }
    }
}

