/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.home;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.HashSet;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Tree;
import oracle.dbtools.common.util.TreeReader;
import oracle.dbtools.common.util.UUIDs;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.home.EntityStores;
import oracle.dbtools.rt.home.EntityType;
import oracle.dbtools.rt.home.ExistingEntities;
import oracle.dbtools.rt.home.GenericEntity;
import oracle.dbtools.rt.home.HasParent;
import oracle.dbtools.rt.home.StoreMode;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

public abstract class EntityTreeStorageBase<PK, T extends GenericEntity<PK>> {
    private ExistingEntities<PK, T> checker;
    private EntityStores<PK, T> stores;

    protected EntityTreeStorageBase() {
    }

    public PK store(CompoundPrincipal principal, PK entityId, InputStream content, TreeReader<T> reader, StoreMode mode) {
        try {
            Tree entities = reader.read(principal, content);
            return this.store(principal, entityId, entities, mode);
        }
        catch (IOException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    public PK store(CompoundPrincipal principal, PK entityId, Tree<? extends T> entities, StoreMode mode) {
        Transaction txn = this.newTransaction(principal, entities);
        try {
            PK id;
            PK PK = id = this.store(principal, txn, entityId, entities, mode);
            return PK;
        }
        catch (RuntimeException e) {
            txn.rollbackOnly();
            throw e;
        }
        finally {
            Closeables.close((Object)txn);
        }
    }

    protected void activate(ServiceProperties props) {
        this.checker = new ExistingEntities();
        this.stores = new EntityStores();
    }

    protected T entity(Transaction txn, CompoundPrincipal principal, PK entityId, Class<? extends T> type) {
        if (entityId == null) {
            return null;
        }
        return this.stores.entity(txn, principal, type, entityId);
    }

    protected abstract PK newId(Principal var1);

    protected Transaction newTransaction(CompoundPrincipal principal, Tree<? extends T> entities) {
        GenericEntity instance = (GenericEntity)entities.node();
        return this.stores.newTransaction(principal, instance);
    }

    protected String user(Principal principal) {
        String user = null;
        if (principal != null) {
            user = principal.getName();
        }
        return user;
    }

    private WebException alreadyExists() {
        return WebException.badRequest(Reason.reason("duplicateEntity", new TranslatableMessage(ResourceTemplateMessages.class, "EntityTreeStorageBase.0", "Entity already exists", new Object[0])));
    }

    private boolean isBuiltIn(T existing) {
        EntityType type = existing.metadata().entityType();
        return type != null && type == EntityType.BUILTIN;
    }

    private void parentId(PK id, Tree<? extends T> child) {
        if (child.node() instanceof HasParent) {
            ((HasParent)child.node()).parentId(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PK store(CompoundPrincipal principal, Transaction txn, PK entityId, Tree<? extends T> entities, StoreMode mode) {
        long now = System.currentTimeMillis();
        String user = this.user((Principal)principal);
        GenericEntity instance = (GenericEntity)entities.node();
        Class<GenericEntity> type = this.typeOf(instance);
        if (StoreMode.UPDATE == mode) {
            instance.id(entityId);
        }
        GenericEntity current = this.entity(txn, principal, entityId, type);
        GenericEntity existing = this.checker.exists(txn, principal, instance);
        Object id = null;
        switch (mode) {
            case CREATE: {
                if (existing != null) {
                    throw this.alreadyExists();
                }
                instance.metadata().entityType(EntityType.LOCAL).guid(UUIDs.uuid()).createdBy(user, now);
                break;
            }
            case UPDATE: {
                if (current == null) {
                    throw WebException.notFound();
                }
                if (existing != null && !current.id().equals(existing.id())) {
                    throw this.alreadyExists();
                }
                id = current.id();
                if (!id.equals(instance.id())) {
                    throw this.alreadyExists();
                }
                instance.metadata().createdBy(current.metadata().createdBy(), current.metadata().created());
            }
            case OVERWRITE: {
                if (existing == null) {
                    instance.metadata().entityType(EntityType.LOCAL).createdBy(user, now);
                    break;
                }
                if (this.isBuiltIn(existing)) {
                    throw WebException.forbidden();
                }
                instance.metadata().updatedBy(user, now);
                break;
            }
            case BUILTIN: {
                instance.metadata().entityType(EntityType.BUILTIN);
            }
        }
        if (id == null) {
            id = existing != null ? (Object)existing.id() : (Object)this.newId((Principal)principal);
            instance.id(id);
        }
        id = this.stores.store(mode, txn, principal, instance).id();
        StoreMode childMode = StoreMode.OVERWRITE;
        if (mode == StoreMode.CACHE || mode == StoreMode.BUILTIN) {
            childMode = mode;
        }
        HashSet currentChildren = new HashSet();
        Iterable<Object> childIds = null;
        try {
            childIds = this.stores.childIds(txn, principal, type, id);
            Iterables.add(currentChildren, childIds);
        }
        finally {
            Closeables.close(childIds);
        }
        for (Tree child : entities) {
            this.parentId(id, child);
            Object childId = this.store(principal, txn, null, child, childMode);
            currentChildren.remove(childId);
        }
        for (Object removed : currentChildren) {
            this.stores.delete(txn, principal, type, removed);
        }
        return (PK)id;
    }

    private Class<T> typeOf(T instance) {
        return instance.getClass();
    }
}

