/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.entity;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.EntityHeader;

public abstract class EntityHeaderBase
implements EntityHeader {
    private final String name;
    private static final DateFormat RFC_822_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");

    protected EntityHeaderBase(CharSequence name) {
        this.name = ((Object)name).toString();
    }

    @Override
    public int compareTo(EntityHeader eh2) {
        return Entities.compareTo(this, eh2);
    }

    @Override
    public long dateValue() {
        return EntityHeaderBase.toDateLong(this.value());
    }

    @Override
    public int intValue() {
        return EntityHeaderBase.toInt(this.value());
    }

    @Override
    public Iterator<String> iterator() {
        return this.values().iterator();
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        return Entities.string(this);
    }

    @Override
    public String value() {
        return (String)Iterables.first(this.values());
    }

    @Override
    public abstract Iterable<String> values();

    static long toDateLong(String value) {
        try {
            if (null == value) {
                return -1L;
            }
            Date d = RFC_822_FORMAT.parse(value);
            return d.getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    static int toInt(String value) {
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }
}

