/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.cors;

import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeadersBuilder;
import oracle.dbtools.rt.web.RequestEntity;

@Service
public class CrossOriginResourceSharing {
    public Entity process(RequestEntity request, Entity response, boolean isPublicResource) {
        EntityHeadersBuilder builder = Entities.headers();
        if (isPublicResource) {
            builder.header((CharSequence)"Access-Control-Allow-Origin", "*");
        } else {
            String origin = this.hasOrigin(request);
            if (origin != null) {
                builder.header((CharSequence)"Access-Control-Allow-Origin", origin);
            }
        }
        response = Entities.merge(response, builder.build());
        return response;
    }

    private String hasOrigin(RequestEntity request) {
        EntityHeader origin = request.headers().header("Origin");
        if (origin != null) {
            return origin.value();
        }
        return null;
    }
}

