/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.config.Configurations;
import oracle.dbtools.common.config.ConfigurationsProvider;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.rt.config.GetConfigurations;
import oracle.dbtools.rt.config.ZipConfigurations;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.HttpResources;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;

@Service(provides={RequestDispatcher.class})
public class PutConfigurations
extends RequestHandler {
    public static final URITemplate URI_TEMPLATE = GetConfigurations.URI_TEMPLATE;

    public PutConfigurations() {
        super(HttpMethod.PUT, SECURE_RESOURCE_TEMPLATE, URI_TEMPLATE, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResource dispatch(RequestEntity request) throws IOException {
        HttpResource httpResource;
        Requests.acceptable(request, ContentTypes.ZIP);
        InputStream body = null;
        ZipConfigurations zip = null;
        try {
            body = request.body();
            zip = new ZipConfigurations(body){

                @Override
                protected boolean handleNonConfigurationFile(String name, InputStream content) {
                    if (PutConfigurations.this.isUrlMapping(name)) {
                        PutConfigurations.this.urlMapping(content);
                        return true;
                    }
                    return false;
                }
            };
            try {
                ConfigurationsProvider.INSTANCE.update((Configurations)zip);
            }
            catch (IllegalArgumentException e) {
                throw WebException.badRequest(Reason.reason("defaults", new TranslatableMessage(e.getMessage())));
            }
            httpResource = HttpResources.noContent();
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new Closeable[]{zip, body});
            throw throwable;
        }
        Closeables.close((Object[])new Closeable[]{zip, body});
        return httpResource;
    }

    private void urlMapping(InputStream content) {
    }

    private boolean isUrlMapping(String name) {
        return "url-mapping.xml".equals(name);
    }
}

