/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import oracle.dbtools.common.config.Configuration;
import oracle.dbtools.common.config.Configurations;
import oracle.dbtools.common.config.ConfigurationsProvider;
import oracle.dbtools.common.config.db.UrlMappings;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.ConfigFiles;
import oracle.dbtools.common.util.ZipBuilder;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;

@Service(provides={RequestDispatcher.class})
public class GetConfigurations
extends RequestHandler {
    public static final URITemplate URI_TEMPLATE = new URITemplate("_/conf");

    public GetConfigurations() {
        super(HttpMethod.GET, SECURE_RESOURCE_TEMPLATE, URI_TEMPLATE, false);
    }

    @Override
    protected HttpResource dispatch(RequestEntity request) throws IOException {
        return new HttpResource(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Entity response() throws IOException {
                InputStream urlMappings = null;
                try {
                    urlMappings = UrlMappings.urlMappings().content();
                    InputStream zipStream = GetConfigurations.this.compressedConfigurations((Configurations)ConfigurationsProvider.INSTANCE, urlMappings);
                    Entity entity = Entities.entity(zipStream, Entities.headers(HttpHeader.CONTENT_TYPE, ContentTypes.ZIP, "Content-Disposition", "attachment; filename=confs.zip"));
                    return entity;
                }
                finally {
                    Closeables.close((Object)urlMappings);
                }
            }

            @Override
            public String version() {
                return null;
            }
        };
    }

    private InputStream asXmlPropertyFile(Configuration conf) throws IOException {
        return ConfigFiles.toInputStream((Properties)AssociativeArrays.asProperties((AssociativeArray)AssociativeArrays.unmerge((AssociativeArray)conf)));
    }

    private InputStream compressedConfigurations(Configurations confs, InputStream urlMappings) throws IOException {
        ZipBuilder zip = ZipBuilder.builder();
        for (String name : confs) {
            Configuration conf = confs.get(name);
            String entryName = this.entryName(name);
            zip.addEntry(entryName, this.asXmlPropertyFile(conf));
        }
        if (urlMappings != null) {
            zip.addEntry("url-mapping.xml", urlMappings);
        }
        return zip.build();
    }

    private String entryName(String name) {
        StringBuilder b = new StringBuilder();
        if (!"defaults".equals(name)) {
            b.append("conf/");
        }
        b.append(name);
        b.append(".xml");
        return b.toString();
    }
}

