/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authorization.apex;

import java.security.Principal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.jdbc.JDBCQuery;
import oracle.dbtools.common.jdbc.JDBCTransaction;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.authorization.AuthorizationPolicy;
import oracle.dbtools.rt.authorization.BaseScopeAuthorizationPolicy;
import oracle.dbtools.rt.authorization.ScopeAuthorizationPolicy;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.tenants.TenantPrincipal;

@Service(provides={ScopeAuthorizationPolicy.class})
public class ApexScopeAuthorization
extends BaseScopeAuthorizationPolicy {
    @Reference
    private JDBCCallProvider jdbc;
    private static final String IS_USER_AUTHORIZED = "select 1 is_authorized from wwv_flow_rt$apex_account_privs\nwhere security_group_id = :tenant_id\n  and privilege_id      = :scope_id\n  and user_name         = upper(:user_id)\n";
    private static final Statement IS_USER_AUTHORIZED_STMT = StatementBuilder.query().append((CharSequence)"select 1 is_authorized from wwv_flow_rt$apex_account_privs\nwhere security_group_id = :tenant_id\n  and privilege_id      = :scope_id\n  and user_name         = upper(:user_id)\n").parameter("tenant_id", Long.class, ParameterAccess.IN).parameter("scope_id", Long.class, ParameterAccess.IN).parameter("user_id", String.class, ParameterAccess.IN).build();

    @Override
    protected AuthorizationPolicy.Access authorize(CompoundPrincipal principal, MultiTenantEntityPK scopeId) {
        JDBCQuery call;
        block4: {
            AuthorizationPolicy.Access access;
            JDBCPrincipal apexListener = ApexListenerJDBCPrincipal.apexListener(principal);
            long tenantId = TenantPrincipal.id(TenantPrincipal.tenant((Principal)principal));
            call = null;
            JDBCTransaction txn = null;
            Iterator matches = null;
            try {
                txn = this.jdbc.transaction((Principal)apexListener);
                call = this.jdbc.query((Transaction)txn, IS_USER_AUTHORIZED_STMT, true);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("tenant_id", tenantId);
                params.put("scope_id", scopeId.entityId());
                params.put("user_id", principal.getName());
                call.bind(params);
                matches = call.execute();
                if (!matches.hasNext()) break block4;
                access = AuthorizationPolicy.Access.READ_WRITE;
            }
            catch (SQLException e) {
                try {
                    throw JDBCException.wrap((SQLException)e);
                }
                catch (Throwable throwable) {
                    Closeables.close(call);
                    throw throwable;
                }
            }
            Closeables.close((Object)call);
            return access;
        }
        Closeables.close((Object)call);
        return AuthorizationPolicy.Access.PRINCIPAL_UNKNOWN;
    }
}

