/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication.jaas;

import com.sun.security.auth.login.ConfigFile;
import java.io.File;
import java.net.URI;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import oracle.dbtools.common.config.GlobalConfiguration;
import oracle.dbtools.common.config.file.ConfigurationFolder;
import oracle.dbtools.common.service.NotAvailableException;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.rt.authentication.Authenticator;
import oracle.dbtools.rt.authentication.AuthenticatorBase;

@Service(provides={Authenticator.class}, priority=5)
public class JaasAuthenticator
extends AuthenticatorBase {
    private Configuration conf;
    static final String JAAS_APP_NAME = "listener";
    private static final Log LOG = Log.get(JaasAuthenticator.class);

    @Override
    public Iterable<Principal> authenticate(CallbackHandler callbackHandler) {
        Subject subject = new Subject();
        try {
            LoginContext ctx = new LoginContext(JAAS_APP_NAME, subject, callbackHandler, this.conf);
            ctx.login();
        }
        catch (LoginException e) {
            LOG.fine((Throwable)e);
        }
        return subject.getPrincipals();
    }

    protected void activate(ServiceProperties properties) {
        Configuration conf = null;
        try {
            URI uri;
            File confFolder;
            File confFile;
            String jaasConf = GlobalConfiguration.globalConfiguration().get("security.jaas.configFile");
            if (jaasConf != null && (confFile = Files.file((File)(confFolder = ConfigurationFolder.INSTANCE.getFolder()), (String)jaasConf)).exists() && (uri = confFile.toURI()) != null) {
                try {
                    conf = new ConfigFile(uri);
                }
                catch (SecurityException e) {
                    LOG.warning((Throwable)e);
                }
            }
        }
        catch (IllegalStateException e) {
            LOG.fine((Throwable)e);
        }
        if (conf == null) {
            try {
                conf = Configuration.getConfiguration();
            }
            catch (SecurityException e) {
                LOG.fine((Throwable)e);
            }
        }
        if (conf == null || conf.getAppConfigurationEntry(JAAS_APP_NAME) == null) {
            throw new NotAvailableException(JaasAuthenticator.class);
        }
        this.conf = conf;
    }
}

