/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication.file;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import oracle.dbtools.common.util.Base64;
import oracle.dbtools.common.util.Identifiers;

class SSHA {
    static final int HASH_LENGTH = 64;
    static final Charset UTF8 = Charset.forName("UTF-8");
    private static final MessageDigest md = SSHA.messageDigest();
    private static final int SALT_SIZE = 8;
    private static final String SSHA_TAG = "{SSHA-512}";

    SSHA() {
    }

    static byte[] decode(String encoded, byte[] hashResult) {
        String ssha = encoded.substring(SSHA_TAG.length());
        byte[] result = Base64.base64ToByteArray((String)ssha);
        byte[] salt = new byte[result.length - 64];
        System.arraycopy(result, 0, hashResult, 0, 64);
        System.arraycopy(result, 64, salt, 0, result.length - 64);
        return salt;
    }

    static String encode(byte[] salt, byte[] hash) {
        assert (hash.length == 64);
        byte[] res = new byte[64 + salt.length];
        System.arraycopy(hash, 0, res, 0, 64);
        System.arraycopy(salt, 0, res, 64, salt.length);
        String encoded = Base64.byteArrayToBase64((byte[])res);
        String out = SSHA_TAG + encoded;
        return out;
    }

    static byte[][] encode(char[] credentials) {
        SecureRandom rng = Identifiers.rng();
        byte[] salt = new byte[8];
        rng.nextBytes(salt);
        byte[] hash = SSHA.compute(salt, SSHA.bytes(credentials));
        return new byte[][]{salt, hash};
    }

    static boolean verify(byte[] salt, byte[] hash, char[] credentials) {
        byte[] newHash = SSHA.compute(salt, SSHA.bytes(credentials));
        return Arrays.equals(hash, newHash);
    }

    private static byte[] bytes(char[] credentials) {
        CharBuffer charBuf = CharBuffer.wrap(credentials);
        byte[] bytes = UTF8.encode(charBuf).array();
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] compute(byte[] salt, byte[] password) {
        byte[] buff = new byte[password.length + salt.length];
        System.arraycopy(password, 0, buff, 0, password.length);
        System.arraycopy(salt, 0, buff, password.length, salt.length);
        byte[] hash = null;
        Class<SSHA> clazz = SSHA.class;
        synchronized (SSHA.class) {
            md.reset();
            hash = md.digest(buff);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return hash;
        }
    }

    private static MessageDigest messageDigest() {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return md;
    }
}

