/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.security.Principal;
import java.util.ArrayList;
import javax.security.auth.callback.CallbackHandler;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.rt.authentication.Authenticates;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.LogonAuthenticatorBase;
import oracle.dbtools.rt.authentication.RealmAuthenticator;
import oracle.dbtools.rt.session.ServletSessionPrincipal;
import oracle.dbtools.rt.session.SessionState;

@Service
@Authenticates(value=AuthenticationRealm.LOGON)
public class SessionAuthenticator
extends LogonAuthenticatorBase
implements RealmAuthenticator {
    @Override
    public Iterable<Principal> authenticate(CallbackHandler callbackHandler) {
        Iterable<Principal> principals = super.authenticate(callbackHandler);
        if (!NullOrEmpty.nullOrEmpty(principals)) {
            return this.session(principals);
        }
        return principals;
    }

    private Iterable<Principal> session(Iterable<Principal> principals) {
        CompoundPrincipal principal = CompoundPrincipal.compound(principals);
        if (principal == null) {
            return null;
        }
        SessionState session = new SessionState(principal);
        ArrayList<Principal> all = new ArrayList<Principal>();
        Iterables.add(all, principals);
        all.add(new ServletSessionPrincipal("_com.oracle.al", session));
        return all;
    }
}

