/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.security.Principal;
import java.util.ArrayList;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.rt.authentication.RolePrincipal;
import oracle.dbtools.rt.authentication.UserPrincipal;

public abstract class Principals {
    private Principals() {
    }

    public static UserPrincipal user(String name) {
        if (!NullOrEmpty.nullOrEmpty((CharSequence)(name = name.trim()))) {
            return new UserPrincipalImpl(name);
        }
        return null;
    }

    public static RolePrincipal[] roles(String ... roles) {
        ArrayList<RolePrincipal> principals = new ArrayList<RolePrincipal>(roles.length);
        for (int i = 0; i < roles.length; ++i) {
            String role = roles[i].trim();
            if (NullOrEmpty.nullOrEmpty((CharSequence)role)) continue;
            principals.add(Principals.role(roles[i]));
        }
        return principals.toArray(new RolePrincipal[principals.size()]);
    }

    public static Principal[] principals(String userName, String ... roles) {
        UserPrincipal user = Principals.user(userName);
        RolePrincipal[] rolePrincipals = Principals.roles(roles);
        Principal[] principals = new Principal[1 + roles.length];
        principals[0] = user;
        for (int i = 1; i < principals.length; ++i) {
            principals[i] = rolePrincipals[i - 1];
        }
        return principals;
    }

    public static RolePrincipal role(String role) {
        if (!NullOrEmpty.nullOrEmpty((CharSequence)(role = role.trim()))) {
            return new RolePrincipalImpl(role);
        }
        return null;
    }

    private static abstract class PrincipalBase
    implements Comparable<Principal> {
        private final String name;

        protected PrincipalBase(String name) {
            this.name = name;
        }

        @Override
        public int compareTo(Principal o) {
            return this.getName().compareTo(o.getName());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrincipalBase other = (PrincipalBase)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            builder.append(" [name=");
            builder.append(this.name);
            builder.append("]");
            return builder.toString();
        }
    }

    private static final class RolePrincipalImpl
    extends PrincipalBase
    implements RolePrincipal {
        private RolePrincipalImpl(String name) {
            super(name);
        }
    }

    private static final class UserPrincipalImpl
    extends PrincipalBase
    implements UserPrincipal {
        private UserPrincipalImpl(String name) {
            super(name);
        }
    }
}

