/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.security.Principal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.AnonymousPrincipal;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.Base64;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.authentication.Authenticates;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.LogonFormHandler;
import oracle.dbtools.rt.authentication.RealmAuthenticator;
import oracle.dbtools.rt.authentication.ServletSessionAndHttpAuthorizationHandler;
import oracle.dbtools.rt.oauth.LogonForm;
import oracle.dbtools.rt.session.ServletSessionPrincipal;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RedirectException;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestPaths;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;

@Service
public class AuthenticationService {
    private final Map<AuthenticationRealm, RealmAuthenticator> authenticators = new HashMap<AuthenticationRealm, RealmAuthenticator>();

    public Subject authenticate(AuthenticationRealm scope, CallbackHandler cb) {
        Subject subject = new Subject();
        RealmAuthenticator authenticator = this.authenticators.get((Object)scope);
        if (authenticator == null) {
            throw WebException.internalError(new IllegalStateException(), new Reason[0]);
        }
        Iterable<Principal> principals = authenticator.authenticate(cb);
        if (principals != null) {
            Iterables.add(subject.getPrincipals(), principals);
        }
        return subject;
    }

    public void logoff(RequestEntity request, String redirect) {
        Requests.invalidateSession(request);
        throw RedirectException.temporaryRedirect(redirect);
    }

    public void logon(RequestEntity request) {
        String referrer = this.referrer(request);
        LogonFormHandler cb = new LogonFormHandler(request);
        Subject subject = this.authenticate(AuthenticationRealm.LOGON, cb);
        if (AuthenticationService.hasUserPrincipal(subject)) {
            throw this.logonSuccessful(subject, referrer);
        }
        throw this.logonRetry(referrer);
    }

    public CompoundPrincipal verify(AuthenticationRealm scope, RequestEntity request) {
        ServletSessionAndHttpAuthorizationHandler cb = new ServletSessionAndHttpAuthorizationHandler(request);
        Subject subject = this.authenticate(scope, cb);
        CompoundPrincipal principal = CompoundPrincipal.compound(AuthenticationService.principals(subject));
        if (principal == null && AnonymousPrincipal.ANONYMOUS != Iterables.first(subject.getPrincipals())) {
            throw this.invalidSession(scope, request);
        }
        return principal;
    }

    public static Iterable<Principal> principals(Subject subject) {
        Set<Principal> principals = subject.getPrincipals();
        Principal first = (Principal)Iterables.first(principals);
        if (first instanceof CompoundPrincipal) {
            return (CompoundPrincipal)first;
        }
        return principals;
    }

    protected void activate(ServiceProperties properties) throws Exception {
        for (RealmAuthenticator authenticator : ServiceLocator.acquireAll(RealmAuthenticator.class, (String[])new String[0])) {
            Authenticates target = authenticator.getClass().getAnnotation(Authenticates.class);
            if (target == null) continue;
            this.authenticators.put(target.value(), authenticator);
        }
    }

    private AssociativeArray<String, Object> session(Subject subject) {
        LinkedHashMap<String, Object> session = new LinkedHashMap<String, Object>();
        for (ServletSessionPrincipal p : subject.getPrincipals(ServletSessionPrincipal.class)) {
            session.put(p.getAttributeName(), p.getValue());
        }
        return AssociativeArrays.fromMap(session);
    }

    private WebException invalidSession(AuthenticationRealm scope, RequestPaths request) {
        String referrer = request.path();
        if (AuthenticationRealm.RESOURCE_TEMPLATES.equals((Object)scope)) {
            return WebException.notAuthorized();
        }
        return LogonForm.redirectToLogonForm(referrer);
    }

    private WebException logonRetry(String referrer) {
        if (referrer == null) {
            return WebException.notAuthorized();
        }
        return LogonForm.redirectToLogonForm(referrer);
    }

    private WebException logonSuccessful(Subject subject, String referrer) {
        return RedirectException.temporaryRedirect(referrer).session(this.session(subject));
    }

    private String referrer(RequestEntity request) {
        List<Pair<String, Object>> fields = Requests.formFields(request);
        String referrer = request.base();
        for (Pair<String, Object> field : fields) {
            if (!"referrer".equals(field.first())) continue;
            referrer = AuthenticationService.decode((String)field.second());
        }
        return referrer;
    }

    public static boolean hasUserPrincipal(Subject subject) {
        boolean hasPrincipal = AuthenticationService.hasPrincipal(subject);
        if (hasPrincipal) {
            Principal p = (Principal)Iterables.first(subject.getPrincipals());
            hasPrincipal = !(p instanceof AnonymousPrincipal);
        }
        return hasPrincipal;
    }

    private static String decode(String referrer) {
        return new String(Base64.safeBase64ToByteArray((String)referrer), Text.defaultCharset());
    }

    private static boolean hasPrincipal(Subject subject) {
        boolean hasPrincipal = subject != null && !subject.getPrincipals().isEmpty();
        return hasPrincipal;
    }
}

