/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.peek;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ide.extension.ElementName;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.hover.HoverActivator;
import oracle.ide.hover.HoverFlavor;
import oracle.javatools.data.HashStructure;

public final class PeekHookHandler
extends HashStructureHook {
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "hover");
    private Collection<HoverFlavor> hoverFlavors;

    public static PeekHookHandler get() {
        return (PeekHookHandler)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
    }

    Collection<HoverFlavor> hoverFlavors() {
        if (this.hoverFlavors == null) {
            List flavors = this.getHashStructure().getAsList("flavor");
            if (flavors == null) {
                return Collections.emptyList();
            }
            ArrayList<HoverFlavor> result = new ArrayList<HoverFlavor>(flavors.size());
            for (Object o : flavors) {
                HashStructure hsProvider = (HashStructure)o;
                String id = hsProvider.getString("id");
                String name = hsProvider.getString("name");
                String desc = hsProvider.getString("description");
                String activator = hsProvider.getString("activator");
                int priority = hsProvider.getInt("priority", 100);
                boolean smartEnable = hsProvider.getBoolean("smart-enabled", true);
                assert (id != null);
                assert (name != null);
                assert (desc != null);
                HoverActivator hoverActivator = activator == null ? HoverActivator.NONE : HoverActivator.valueOf(activator);
                result.add(new HoverFlavor(id, name, desc, hoverActivator, priority, smartEnable));
            }
            this.hoverFlavors = result;
            this.dispose();
        }
        return this.hoverFlavors;
    }

    public HoverFlavor getFlavor(String id) {
        for (HoverFlavor flavor : this.hoverFlavors) {
            if (!flavor.getId().equals(id)) continue;
            return flavor;
        }
        return null;
    }
}

