/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.peek;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import oracle.ide.hover.HoverActivator;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverOptions;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.peek.PeekBundle;
import oracle.ideimpl.peek.PeekHookHandler;
import oracle.javatools.ui.Reorderable;
import oracle.javatools.ui.ReorderableBar;
import oracle.javatools.ui.RichHintLabel;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.ReorderableTable;
import oracle.javatools.ui.table.ReorderableTableModel;
import oracle.javatools.ui.table.RolloverTableRenderer;

final class HoverOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JTable table;
    final JLabel smartShortcutLabel = new JLabel(PeekBundle.get("PEEK_OPTIONS_PANEL_SMART_HOVER_SHORTCUT"));
    private JCheckBox smartCheckBox = new JCheckBox(PeekBundle.get("PEEK_OPTIONS_PANEL_SMART_HOVER_CHECK"));
    private JComboBox smartComboBox;

    public HoverOptionsPanel() {
        this.setHelpID("f1_pref_hoverpage_html");
        this.initializeComponent();
    }

    private static HoverOptions getOptions(TraversableContext tc) {
        return HoverOptions.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        this.loadSettingsFrom(HoverOptionsPanel.getOptions(tc));
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        this.saveSettingsTo(HoverOptionsPanel.getOptions(tc));
    }

    public void apply(ApplyEvent event) {
    }

    public void cancel(ApplyEvent e) {
    }

    void loadSettingsFrom(HoverOptions options) {
        HoverTableModel model = (HoverTableModel)this.table.getModel();
        ArrayList<HoverFlavor> flavorList = new ArrayList<HoverFlavor>(options.getFlavorPriority());
        PeekHookHandler handler = PeekHookHandler.get();
        for (HoverFlavor flavor : handler.hoverFlavors()) {
            if (flavorList.contains(flavor)) continue;
            flavorList.add(flavor);
        }
        model.setFlavors(flavorList, options);
        this.smartCheckBox.setSelected(options.isSmartEnabled());
        this.smartComboBox.setSelectedItem((Object)options.getSmartActivator());
        this.smartShortcutLabel.setEnabled(options.isSmartEnabled());
        this.smartComboBox.setEnabled(options.isSmartEnabled());
    }

    void saveSettingsTo(HoverOptions options) throws TraversalException {
        options.setFlavorPriority(((HoverTableModel)this.table.getModel()).flavorList);
        options.setSmartEnabled(this.smartCheckBox.isSelected());
        options.setSmartActivator((HoverActivator)((Object)this.smartComboBox.getSelectedItem()));
    }

    private void initializeComponent() {
        HoverTableModel model = new HoverTableModel();
        this.table = new GenericTable((TableModel)model);
        this.table.setSelectionMode(0);
        this.table.setFillsViewportHeight(true);
        this.table.setAutoResizeMode(1);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(77);
        this.table.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new RolloverTableRenderer((TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value != null) {
                    label.setText(((HoverActivator)((Object)value)).getDisplayName());
                }
                return label;
            }
        }));
        JComboBox<HoverActivator> shortcutCombo = new JComboBox<HoverActivator>(HoverActivator.values());
        shortcutCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                label.setText(((HoverActivator)((Object)value)).getDisplayName());
                return label;
            }
        });
        this.table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(shortcutCombo){

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                JComboBox combo = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
                combo.setSelectedItem(value);
                return combo;
            }
        });
        ReorderableTable reorderableTable = new ReorderableTable(this.table);
        ReorderableBar reorderableBar = new ReorderableBar((Reorderable)reorderableTable, true);
        RichHintLabel hintLabel = new RichHintLabel();
        hintLabel.setHtmlText(PeekBundle.get("PEEK_OPTIONS_PANEL_SMART_HOVER_HINT"));
        Vector<HoverActivator> autoOptions = new Vector<HoverActivator>();
        for (HoverActivator a : HoverActivator.values()) {
            if (a == HoverActivator.OFF) continue;
            autoOptions.add(a);
        }
        this.smartComboBox = new JComboBox(autoOptions);
        this.smartComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof HoverActivator) {
                    label.setText(((HoverActivator)((Object)value)).getDisplayName());
                }
                return label;
            }
        });
        this.smartCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HoverOptionsPanel.this.smartShortcutLabel.setEnabled(HoverOptionsPanel.this.smartCheckBox.isSelected());
                HoverOptionsPanel.this.smartComboBox.setEnabled(HoverOptionsPanel.this.smartCheckBox.isSelected());
            }
        });
        this.setLayout((LayoutManager)new MigLayout("nogrid, ins 0, aligny top, gapy 0"));
        this.add(new JScrollPane(this.table), "growx, h 200");
        this.add((Component)reorderableBar, "wrap, growx 0");
        this.add((Component)hintLabel, "gaptop 12, gapbottom 4, growx, span, wrap");
        this.add(this.smartCheckBox, "split");
        this.smartCheckBox.setSelected(true);
        this.add(this.smartShortcutLabel, "gapleft 8");
        this.add(this.smartComboBox, "wrap");
    }

    private class HoverTableModel
    extends AbstractTableModel
    implements ReorderableTableModel {
        private List<HoverFlavor> flavorList = new ArrayList<HoverFlavor>();
        private HoverOptions options;

        HoverTableModel() {
        }

        void setFlavors(List<HoverFlavor> flavors, HoverOptions options) {
            this.options = options;
            this.flavorList.clear();
            this.flavorList.addAll(flavors);
            this.fireTableDataChanged();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 3) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.flavorList.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            HoverFlavor flavor = this.flavorList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return flavor.getName();
                }
                case 1: {
                    return this.options.getFlavorActivator(flavor);
                }
                case 2: {
                    return flavor.getDescription();
                }
                case 3: {
                    return this.options.isFlavorSmartEnabled(flavor);
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            assert (value != null);
            HoverFlavor flavor = this.flavorList.get(rowIndex);
            if (columnIndex == 3) {
                this.options.setFlavorSmartEnabled(flavor, (Boolean)value);
            } else if (columnIndex == 1) {
                this.options.setFlavorActivator(flavor, (HoverActivator)((Object)value));
            }
        }

        public void moveRow(int start, int end, int to) {
            if (start > to) {
                int temp = start;
                start = to;
                to = temp;
            }
            HoverFlavor bFlavor = this.flavorList.remove(to);
            HoverFlavor aFlavor = this.flavorList.remove(start);
            this.flavorList.add(start, bFlavor);
            this.flavorList.add(to, aFlavor);
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return PeekBundle.get("PEEK_OPTIONS_PANEL_COL_NAME");
                }
                case 1: {
                    return PeekBundle.get("PEEK_OPTIONS_PANEL_COL_SHORTCUT");
                }
                case 2: {
                    return PeekBundle.get("PEEK_OPTIONS_PANEL_COL_DESCRIPTION");
                }
                case 3: {
                    return PeekBundle.get("PEEK_OPTIONS_PANEL_COL_SMART");
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1 || columnIndex == 3;
        }
    }
}

