/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.hover;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.ide.hover.HoverActivator;
import oracle.ide.hover.HoverFlavor;
import oracle.ideimpl.peek.PeekHookHandler;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public final class HoverOptions
extends HashStructureAdapter {
    private static final String DATA_KEY = "oracle.ide.hover.HoverOptions";
    private static final String flavorPattern = "%s-%s";
    private static final String HOVER_ACTIVATOR = "flavorShortcut";
    private static final String FLAVOR_SMART_ENABLED = "flavorEnabled";
    private static final String HOVER_PRIORITY = "flavorPriority";
    private static final String SMART_ENABLED = "smartEnabled";
    private static final String SMART_ACTIVATOR = "smartShortcut";

    private HoverOptions(HashStructure hash) {
        super(hash);
    }

    public static HoverOptions getInstance(PropertyStorage prefs) {
        return new HoverOptions(HoverOptions.findOrCreate((PropertyStorage)prefs, (String)DATA_KEY));
    }

    private static String getFlavorName(String property, HoverFlavor hoverFlavor) {
        return String.format(flavorPattern, property, hoverFlavor.getName());
    }

    public HoverActivator getFlavorActivator(HoverFlavor hoverFlavor) {
        String name = this._hash.getString(HoverOptions.getFlavorName(HOVER_ACTIVATOR, hoverFlavor), HoverActivator.OFF.name());
        return HoverActivator.valueOf(name);
    }

    public void setFlavorActivator(HoverFlavor hoverFlavor, HoverActivator hoverActivator) {
        this._hash.putString(HoverOptions.getFlavorName(HOVER_ACTIVATOR, hoverFlavor), hoverActivator.name());
    }

    public boolean isFlavorSmartEnabled(HoverFlavor hoverFlavor) {
        return this._hash.getBoolean(HoverOptions.getFlavorName(FLAVOR_SMART_ENABLED, hoverFlavor), true);
    }

    public void setFlavorSmartEnabled(HoverFlavor hoverFlavor, boolean isEnabled) {
        this._hash.putBoolean(HoverOptions.getFlavorName(FLAVOR_SMART_ENABLED, hoverFlavor), isEnabled);
    }

    public List<HoverFlavor> getFlavorPriority() {
        ListStructure idList = this._hash.getListStructure(HOVER_PRIORITY);
        if (idList == null) {
            return Collections.EMPTY_LIST;
        }
        PeekHookHandler handler = PeekHookHandler.get();
        ArrayList<HoverFlavor> list = new ArrayList<HoverFlavor>();
        for (String id : idList) {
            HoverFlavor flavor = handler.getFlavor(id);
            if (flavor == null) continue;
            list.add(flavor);
        }
        return list;
    }

    public void setFlavorPriority(List<HoverFlavor> flavorList) {
        if (flavorList == null || flavorList.isEmpty()) {
            return;
        }
        ListStructure list = ListStructure.newInstance();
        for (HoverFlavor flavor : flavorList) {
            list.add((Object)flavor.getId());
        }
        this._hash.putListStructure(HOVER_PRIORITY, list);
    }

    public boolean isSmartEnabled() {
        return this._hash.getBoolean(SMART_ENABLED, false);
    }

    public void setSmartEnabled(boolean isEnabled) {
        this._hash.putBoolean(SMART_ENABLED, isEnabled);
    }

    public HoverActivator getSmartActivator() {
        String name = this._hash.getString(SMART_ACTIVATOR, HoverActivator.NONE.name());
        return HoverActivator.valueOf(name);
    }

    public void setSmartActivator(HoverActivator hoverActivator) {
        this._hash.putString(SMART_ACTIVATOR, hoverActivator.name());
    }
}

