/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.hover;

import java.util.ArrayList;
import java.util.Collection;
import oracle.ide.hover.HoverActivator;

public final class HoverFlavor {
    private static Collection<HoverFlavor> flavors = new ArrayList<HoverFlavor>();
    private String name;
    private String description;
    private String id;
    private HoverActivator defaultActivator;
    private int defaultPriority;
    private boolean defaultSmartEnable;

    public HoverFlavor(String id, String name, String description, HoverActivator defaultActivator, int defaultPriority, boolean defaultSmartEnable) {
        if (flavors.contains(id)) {
            throw new IllegalStateException("Duplicate HoverFlavor: " + id);
        }
        this.name = name;
        this.id = id;
        this.description = description;
        this.defaultActivator = defaultActivator;
        this.defaultPriority = defaultPriority;
        this.defaultSmartEnable = defaultSmartEnable;
        flavors.add(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id + " : " + this.name + " - " + this.description;
    }

    public static HoverFlavor getFlavor(String id) {
        for (HoverFlavor flavor : flavors) {
            if (!flavor.getId().equals(id)) continue;
            return flavor;
        }
        return null;
    }

    public HoverActivator getDefaultHoverActivator() {
        return this.defaultActivator;
    }

    public int getDefaultPriority() {
        return this.defaultPriority;
    }

    public boolean isDefaultSmartEnable() {
        return this.defaultSmartEnable;
    }
}

