/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.credentialstore.spi;

import java.io.Serializable;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import oracle.adf.share.ADFContext;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityRuntimeException;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.CredentialNotFoundException;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.SecurityEnv;
import oracle.adf.share.security.credentialstore.Credential;
import oracle.adf.share.security.credentialstore.spi.CredentialStorage2;
import oracle.adf.share.security.identitymanagement.UserManager;

public abstract class GenericCredentialStore
implements CredentialStorage2 {
    protected String _applicationUser = null;
    private boolean isApplicationUserSupported = true;
    protected String _contextName = null;
    protected static final String MAP_CREDENTIAL_SEPARATOR = "#";
    private static ADFLogger sLogger = ADFSecurityUtil.getADFLogger();
    private static final String CLASS_NAME = GenericCredentialStore.class.getName();

    @Override
    public abstract void initialize(Hashtable var1);

    @Override
    public abstract void storeCredential(Credential var1, String var2);

    @Override
    public void storeCredential(Credential cred, String mapName, String adfCredKey, String credKey) {
    }

    @Override
    public abstract Credential fetchCredential(String var1) throws CredentialNotFoundException;

    @Override
    public Credential fetchCredential(String mapName, String adfCredKey, String credKey) throws CredentialNotFoundException {
        return null;
    }

    @Override
    public abstract Serializable fetchSerializableCredential(String var1) throws CredentialNotFoundException;

    @Override
    public Serializable fetchSerializableCredential(String mapName, String adfCredKey, String credKey) throws CredentialNotFoundException {
        return null;
    }

    @Override
    public Serializable fetchSerializableCredentialForCurrentUser(String credKey) throws CredentialNotFoundException {
        throw new ADFSecurityRuntimeException("EXC_UNSUPPORTED_CREDENTIAL_OPERATION");
    }

    @Override
    public Serializable fetchSerializableCredentialForCurrentUser(String mapName, String adfCredKey, String credKey) throws CredentialNotFoundException {
        throw new ADFSecurityRuntimeException("EXC_UNSUPPORTED_CREDENTIAL_OPERATION");
    }

    @Override
    public abstract void removeCredential(String var1) throws CredentialNotFoundException;

    @Override
    public void removeCredential(String mapName, String adfCredKey, String credKey) throws CredentialNotFoundException {
    }

    public String getApplicationUserName() {
        if (this._applicationUser == null && this.isApplicationUserSupported) {
            try {
                this._applicationUser = System.getProperty("oracle.adf.security.credentialstore.default.user");
                if (this._applicationUser == null) {
                    String configUser = this.getConfigCredentialStoreUser();
                    this._applicationUser = configUser != null && configUser.length() > 0 ? configUser : SecurityEnv.CREDENTIAL_STORE_USER_DEFAULT;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._applicationUser;
    }

    String getConfigCredentialStoreUser() {
        String configUser = null;
        try {
            configUser = (String)this.getSecurityContext().getEnvironment().get("oracle.adf.security.credentialstore.default.user");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configUser;
    }

    protected SecurityContext getSecurityContext() {
        SecurityContext secCtx = null;
        if (this._contextName == null) {
            secCtx = ADFContext.getCurrent().getSecurityContext();
        } else {
            try {
                secCtx = ADFContext.get(this._contextName).getSecurityContext();
            }
            catch (Exception e) {
                throw new ADFSecurityRuntimeException("EXC_CREDENTIAL_STORE_INIT");
            }
        }
        return secCtx;
    }

    protected Principal getUserPrincipal() {
        Principal p = null;
        SecurityContext secCtx = this.getSecurityContext();
        if (secCtx != null && (p = secCtx.getUserPrincipal()) == null) {
            p = this.getDefaultUser();
        }
        return p;
    }

    protected Principal getDefaultUser() {
        UserManager usrMgr = new UserManager();
        String defaultUserName = this.getApplicationUserName();
        Principal principal = usrMgr.getPrincipal(defaultUserName);
        if (principal == null) {
            return usrMgr.getAnonymousUser();
        }
        return principal;
    }

    protected static String getCredStoreAbsoluteLocation(String location, String contextName) {
        String METHOD_NAME = "getCredStoreAbsoluteLocation";
        String path = location;
        if (location == null) {
            return null;
        }
        if (location.charAt(0) == '.') {
            try {
                URL url = null;
                if (contextName != null) {
                    url = ADFContext.get(contextName).getURL();
                } else {
                    ClassLoader cl = ClassUtils.getClassLoader();
                    url = cl.getResource("META-INF/adf-config.xml");
                }
                String baseName = url.toString();
                int parentX = baseName.lastIndexOf(47);
                if (parentX != -1) {
                    path = new URL(baseName.substring(0, parentX + 1) + location).toString();
                }
            }
            catch (Exception e) {
                sLogger.logp(ADFLogger.WARNING, CLASS_NAME, "getCredStoreAbsoluteLocation", "WARN_ERR_CONSTRUCTING_CREDSTORE_PATH", (Object[])new String[]{location}, (Throwable)e);
                return null;
            }
        }
        return GenericCredentialStore.removeRelativeItems(path);
    }

    private static String removeRelativeItems(String path) {
        if (path.indexOf("/./") == -1 && path.indexOf("/../") == -1) {
            return path;
        }
        String replacedPath = path.replace('\\', '/');
        ArrayList<String> segments = new ArrayList<String>(Arrays.asList(replacedPath.split("/")));
        for (int i = 0; i < segments.size(); ++i) {
            String elem = segments.get(i);
            if (elem.equals(".")) {
                segments.remove(i--);
                continue;
            }
            if (!elem.equals("..")) continue;
            segments.remove(i--);
            segments.remove(i--);
        }
        StringBuilder returnThis = new StringBuilder(replacedPath.length());
        for (String seg : segments) {
            returnThis.append(seg + "/");
        }
        return returnThis.substring(0, returnThis.length() - 1);
    }
}

