/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import oracle.adf.share.ADFContext;
import oracle.adf.share.Environment;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityRuntimeException;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.PermissionELType;
import oracle.adf.share.security.PermissionEvaluator;
import oracle.adf.share.security.PermissionState;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.SecurityContextMap;
import oracle.adf.share.security.UserRoleEvaluator;
import oracle.adf.share.security.identitymanagement.UserProfile;

public class SecurityContextImpl
extends SecurityContextMap
implements SecurityContext {
    protected static ADFLogger _adfSecLogger = ADFSecurityUtil.getADFLogger();
    public static final String ADF_SECURITY_SHOW_PRINCIPALS_LOGGER_NAME = "oracle.adfinternal.share.security.SecurityContextImpl.ShowPrincipals";
    protected static ADFLogger _adfShowPrincipalsLogger = ADFLogger.createADFLogger((String)"oracle.adfinternal.share.security.SecurityContextImpl.ShowPrincipals");
    private static final int ENV_SIZE = 10;
    protected Hashtable mEnv = new Hashtable(10);
    protected Hashtable mNames = new Hashtable();
    protected String mNamedContext = null;
    protected PermissionState mPermissionState = null;
    protected boolean _isJEE;
    private boolean mPageSecurityMetadataEnabled = false;
    private boolean mSecurity1013Mode = false;
    private boolean mWildcardPermission = false;
    private boolean mCachePermission = false;
    private long _timeMillis = 0L;
    private boolean _cacheSubject = false;
    private static final String SECURITYCONTEXT_PRINCIPAL = "__securitycontext_principal__";
    private static final String SECURITYCONTEXT_AUTH_TIMESTAMP = "__securitycontext_auth_timestamp__";
    private static final Object __LOCK__ = new Object();
    private static final ThreadLocal<StringBuilder> _STRING_BUILDER = new ThreadLocal();
    private static final String USER_AUTHENTICATED = "authenticated";
    private static final String USER_IN_ROLE = "userInRole";
    private static final String USER_IN_ALL_ROLES = "userInAllRoles";
    private static final String USER_NAME = "userName";

    public SecurityContextImpl() {
        this(null);
    }

    public SecurityContextImpl(Map env) {
        if (env != null) {
            this.mEnv = new Hashtable(env);
            this.mNamedContext = (String)this.mEnv.get("named.adf.context");
            try {
                this._isJEE = this.mNamedContext == null ? ADFContext.getCurrent().isJEE() : ADFContext.get(this.mNamedContext).isJEE();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mEnv.put("oracle.adf.security.authentication.j2se", Boolean.valueOf(!this._isJEE).toString());
            this.initialize();
        }
    }

    public SecurityContextImpl(Hashtable env) {
        this((Map)env);
    }

    void initialize() {
        Object value = this.mEnv.get("pageSecurityMetadata");
        this.mPageSecurityMetadataEnabled = value != null ? !value.equals(Boolean.FALSE.toString()) : false;
        value = this.mEnv.get("oracle.adf.security.metadata");
        this.mSecurity1013Mode = value != null ? value.equals(Boolean.FALSE.toString()) : false;
        value = this.mEnv.get("cacheSubject");
        this._cacheSubject = value != null ? !value.equals(Boolean.FALSE.toString()) : false;
        value = this.mEnv.get("oracle.adf.security.wildcard.enable");
        this.mWildcardPermission = value != null ? !value.equals(Boolean.FALSE.toString()) : true;
        value = this.mEnv.get("oracle.adf.security.authorization.cache");
        this.mCachePermission = value != null ? !value.equals(Boolean.FALSE.toString()) : true;
    }

    @Override
    public Principal getUserPrincipal() {
        return (Principal)this.mEnv.get("java.naming.security.principal");
    }

    @Override
    public UserProfile getUserProfile() {
        if (this.getUserName() == null) {
            throw new ADFSecurityRuntimeException("EXC_NO_AUTHENTICATED_USER");
        }
        return new UserProfile(this.getUserName());
    }

    @Override
    public String getUserName() {
        Principal p = this.getUserPrincipal();
        return p != null ? p.getName() : null;
    }

    @Override
    public boolean isAuthorizationEnabled() {
        Object value = this.mEnv.get("oracle.adf.security.authorization.enforce");
        return value != null ? !value.equals(Boolean.FALSE.toString()) : false;
    }

    @Override
    public boolean isAuthenticationEnabled() {
        Object value = this.mEnv.get("oracle.adf.security.authentication.require");
        return value != null ? !value.equals(Boolean.FALSE.toString()) : false;
    }

    @Override
    public boolean hasPermission(Permission permission) {
        if (!this.isAuthorizationEnabled()) {
            if (_adfSecLogger.isFinest()) {
                _adfSecLogger.log(Level.FINEST, "Authorization is disable.");
            }
            return true;
        }
        return this.internalHasPermission(permission);
    }

    protected boolean internalHasPermission(Permission permission) {
        Subject subject = this.getSubject();
        if (subject == null) {
            return false;
        }
        return this.doCheckPermission(permission, subject);
    }

    private boolean doCheckPermission(final Permission permission, Subject subject) {
        boolean bOk = false;
        try {
            Subject.doAsPrivileged(subject, new PrivilegedAction(){

                public Object run() {
                    AccessController.checkPermission(permission);
                    return null;
                }
            }, null);
            bOk = true;
        }
        catch (SecurityException e) {
            // empty catch block
        }
        return bOk;
    }

    @Override
    public PermissionState getPermissionState() {
        return this.mPermissionState;
    }

    @Override
    public void setPermissionState(PermissionState permissionState) {
        this.mPermissionState = permissionState;
    }

    @Override
    public boolean isPageSecurityMetadataEnabled() {
        return this.mPageSecurityMetadataEnabled;
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        if (name.equals("")) {
            return new NameList(this.mNames.keySet().iterator(), true);
        }
        return new NameList(name, true);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        if (name.equals("")) {
            return new NameList(this.mNames.keySet().iterator(), false);
        }
        return new NameList(name, false);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        if (oldName == null || oldName.equals("") || newName == null || newName.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        Object obj = null;
        Object v = this.mNames.get(oldName);
        obj = v;
        if (v == null) {
            throw new NameNotFoundException(oldName + " not bound.");
        }
        if (this.mNames.get(newName) != null) {
            throw new NameAlreadyBoundException(newName + " already bound.");
        }
        this.mNames.remove(oldName);
        this.mNames.put(newName, obj);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        if (oldName == null || newName == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.rename(oldName.toString(), newName.toString());
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        if (name == null || name.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        if (this.mNames.get(name) != null) {
            throw new NameAlreadyBoundException(name + " already bound.");
        }
        this.mNames.put(name, obj);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.bind(name.toString(), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        if (name == null || name.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        this.mNames.put(name, obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.rebind(name.toString(), obj);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.unbind(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.destroySubcontext(name.toString());
    }

    @Override
    public void unbind(String name) throws NamingException {
        if (name == null || name.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        this.mNames.remove(name);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.unbind(name.toString());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("Subcontext not supported.");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.createSubcontext(name.toString());
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.mNames.get(name);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.lookup(name.toString());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.lookupLink(name.toString());
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        throw new OperationNotSupportedException("getNameParser not supported.");
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.getNameParser(name.toString());
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (propName == null || propName.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        if (propName == "java.naming.security.principal") {
            this.setPrincipal(propVal);
            return propVal;
        }
        return propVal != null ? this.mEnv.put(propName, propVal) : null;
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        if (propName == null || propName.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        if (this.mEnv == null) {
            return null;
        }
        return this.mEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.mEnv == null) {
            throw new NamingException("Null Environment");
        }
        return this.mEnv;
    }

    @Override
    public void close() throws NamingException {
        if (this.mEnv != null) {
            this.mEnv.clear();
        }
        this.mEnv = null;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPrincipal(Object principal) {
        if (principal != null && !Principal.class.isAssignableFrom(principal.getClass())) {
            return;
        }
        Object object = __LOCK__;
        synchronized (object) {
            RuntimePermission p = new RuntimePermission("setPrincipal");
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(p);
            }
            if (principal == null) {
                this.mEnv.remove("java.naming.security.principal");
            } else {
                this.mEnv.put("java.naming.security.principal", principal);
            }
            if (this.isAuthorizationEnabled() || ADFSecurityUtil.isAuthenticationRequired()) {
                if (this._isJEE) {
                    Map scopeMap = ADFContext.getCurrent().getSessionScope();
                    if (scopeMap != null) {
                        Object obj = scopeMap.get(SECURITYCONTEXT_PRINCIPAL);
                        if (obj == principal || obj != null && principal != null && ((Principal)obj).getName().equals(((Principal)principal).getName())) {
                            return;
                        }
                        if (principal != null) {
                            scopeMap.put(SECURITYCONTEXT_PRINCIPAL, principal);
                        } else {
                            scopeMap.remove(SECURITYCONTEXT_PRINCIPAL);
                        }
                        this._timeMillis = System.currentTimeMillis();
                        scopeMap.put(SECURITYCONTEXT_AUTH_TIMESTAMP, new Long(this._timeMillis));
                    }
                } else {
                    this._timeMillis = System.currentTimeMillis();
                }
            }
        }
    }

    @Override
    public boolean isAuthenticated() {
        Principal p = (Principal)this.mEnv.get("java.naming.security.principal");
        return p != null && (p == null || !p.getName().equals("anonymous"));
    }

    @Override
    public boolean isUserInRole(String roleName) {
        boolean userInRole = false;
        if (this._isJEE) {
            try {
                Environment env = this.mNamedContext == null ? ADFContext.getCurrent().getEnvironment() : ADFContext.get(this.mNamedContext).getEnvironment();
                Object req = env.getRequest();
                if (req != null) {
                    userInRole = ((HttpServletRequest)req).isUserInRole(roleName);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (userInRole) {
            return true;
        }
        Subject s = this.getSubject();
        if (s != null) {
            for (Principal p : s.getPrincipals()) {
                String principalName = p.getName();
                int ix = principalName.indexOf("/");
                if ((ix <= 0 || !roleName.regionMatches(0, principalName, ix + 1, roleName.length())) && !roleName.equals(principalName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] getUserRoles() {
        ArrayList<String> list = new ArrayList<String>();
        String userName = this.getUserName();
        Subject s = this.getSubject();
        if (s != null) {
            for (Principal p : s.getPrincipals()) {
                String principalName = p.getName();
                int ix = principalName.indexOf("/");
                if (ix > 0 && userName.regionMatches(0, principalName, ix + 1, userName.length()) || userName.equals(principalName)) continue;
                list.add(principalName);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Subject getSubject() {
        Subject s = null;
        Object value = this.mEnv.get("oracle.adf.security.authenticated");
        if (this._cacheSubject || value != null && value.equals(Boolean.TRUE.toString()) || !this._isJEE) {
            s = (Subject)this.mEnv.get("jaas.subject");
        }
        if (s == null) {
            s = Subject.getSubject(AccessController.getContext());
            if (this._cacheSubject && s != null) {
                this.mEnv.put("jaas.subject", s);
            }
        }
        return s;
    }

    @Override
    public boolean isAnyoneEnabled() {
        Object value = this.mEnv.get("oracle.adf.security.anyone.enable");
        return value != null ? value.equals("true") : false;
    }

    @Override
    public Permission createPermissionInstance(Hashtable values) {
        Permission p = null;
        String permClassName = (String)values.get("permissionClass");
        ArrayList<String> paramList = (ArrayList<String>)values.get("PermissionParams");
        if (paramList == null) {
            paramList = PermissionEvaluator.getPermissionParamList(PermissionEvaluator.PERMISSION_PARAMS, values);
        }
        if (paramList.size() == 0) {
            return null;
        }
        try {
            Class cls = ClassUtils.forName((String)permClassName);
            Class strClass = ClassUtils.forName((String)"java.lang.String");
            Class[] clsParams = new Class[paramList.size()];
            for (int i = 0; i < clsParams.length; ++i) {
                clsParams[i] = strClass;
            }
            Constructor ctr = cls.getConstructor(clsParams);
            p = (Permission)ctr.newInstance(paramList.toArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new IllegalStateException(e.getMessage());
        }
        return p;
    }

    @Override
    public boolean isXSMode() {
        return false;
    }

    @Override
    public boolean attachToLightweightSession(Connection conn) {
        return false;
    }

    @Override
    public boolean detachFromLightweightSession() {
        return false;
    }

    @Override
    public Object getAttachedLightweightSession() {
        return null;
    }

    @Override
    public boolean isReAuthenticated(long time) {
        Long _time;
        Map scopeMap;
        if (this._timeMillis == 0L && (scopeMap = ADFContext.getCurrent().getSessionScope()) != null && (_time = (Long)scopeMap.get(SECURITYCONTEXT_AUTH_TIMESTAMP)) != null) {
            this._timeMillis = _time;
        }
        return this._timeMillis > time;
    }

    protected void showPrincipals() {
        if (_adfShowPrincipalsLogger.isFinest()) {
            Subject subject = this.getSubject();
            if (subject != null && subject.getPrincipals() != null) {
                _adfShowPrincipalsLogger.log(Level.FINEST, "---- principals ");
                Iterator<Principal> principalIterator = subject.getPrincipals().iterator();
                while (principalIterator.hasNext()) {
                    StringBuilder s = _STRING_BUILDER.get();
                    if (s == null) {
                        s = new StringBuilder(100);
                        _STRING_BUILDER.set(s);
                    }
                    s.setLength(0);
                    Principal p = principalIterator.next();
                    s.append("\t---- name: ").append(p.getName()).append(", class: ").append(p.getClass().getName());
                    _adfSecLogger.log(Level.FINEST, s.toString());
                }
            } else {
                _adfShowPrincipalsLogger.log(Level.FINEST, "---- no subject, principals ");
            }
        }
    }

    boolean isSecurity1013Mode() {
        return this.mSecurity1013Mode;
    }

    boolean isWildcardPermissionEnabled() {
        return this.mWildcardPermission;
    }

    boolean isPermissionCacheEnabled() {
        return this.mCachePermission;
    }

    @Override
    protected Object internalGet(String key) {
        if (USER_AUTHENTICATED == (key = key.intern())) {
            return this.isAuthenticated();
        }
        if (USER_NAME == key) {
            return this.getUserName();
        }
        if (USER_IN_ROLE == key) {
            return new UserRoleEvaluator(this, false);
        }
        if (USER_IN_ALL_ROLES == key) {
            return new UserRoleEvaluator(this, true);
        }
        for (PermissionELType ptype : PermissionELType.values()) {
            if (ptype.name() != key) continue;
            return new PermissionEvaluator(this, ptype.getPermissionClassName());
        }
        return null;
    }

    class NameList
    implements NamingEnumeration {
        Iterator names;
        boolean isNameClassPair;

        NameList(String name, boolean ncpair) {
            ArrayList<String> vec = new ArrayList<String>(1);
            if (SecurityContextImpl.this.mNames.get(name) != null) {
                vec.add(name);
            }
            this.names = vec.iterator();
            this.isNameClassPair = ncpair;
        }

        NameList(Iterator namesEnum, boolean ncpair) {
            this.names = namesEnum;
            this.isNameClassPair = ncpair;
        }

        @Override
        public boolean hasMoreElements() {
            return this.names.hasNext();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public Object nextElement() {
            String name = (String)this.names.next();
            if (this.isNameClassPair) {
                return new NameClassPair(name, SecurityContextImpl.this.mNames.get(name).getClass().getName());
            }
            return new Binding(name, SecurityContextImpl.this.mNames.get(name));
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public void close() throws NamingException {
            this.names = null;
        }
    }
}

