/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.logging.Level;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.jndi.DocumentBackingStore;
import oracle.adf.share.logging.ADFLogger;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;

public class ResourceBackingStore
extends DocumentBackingStore {
    private String mResourcePath;
    private ADFLogger mLogger = null;

    public ResourceBackingStore() {
    }

    @Override
    public void initialize(Hashtable contextEnv, String url) throws Exception {
        Object o;
        super.initialize(contextEnv, url);
        if (this.getLogger().isFinest()) {
            this.getLogger().log(Level.FINEST, "ResourceBackingStore is being initialized");
        }
        if ((o = contextEnv.get("java.naming.provider.url")) instanceof String) {
            this.mResourcePath = (String)o;
        }
    }

    public ResourceBackingStore(String resourcePath) {
        this.mResourcePath = resourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document readDocument(String url) throws Exception {
        InputStream is = this.getDocumentStream();
        if (is == null) {
            throw new Exception("Unable to find resource " + this.mResourcePath);
        }
        try {
            DOMParser parser = new DOMParser();
            parser.parse(is);
            XMLDocument xMLDocument = parser.getDocument();
            return xMLDocument;
        }
        finally {
            is.close();
        }
    }

    @Override
    public boolean documentExists(String url) throws Exception {
        ClassLoader cl = ClassUtils.getClassLoader();
        URL urlPath = cl.getResource(this.mResourcePath);
        if (urlPath == null && this.mResourcePath.startsWith("/")) {
            this.mResourcePath = this.mResourcePath.substring(1);
            urlPath = cl.getResource(this.mResourcePath);
        }
        if (this.getLogger().isFine()) {
            this.getLogger().log(Level.FINE, "Resource read: " + this.mResourcePath + " " + urlPath);
        }
        return urlPath != null;
    }

    @Override
    public Document createDocument(String url) throws Exception {
        throw new UnsupportedOperationException("ReadOnly");
    }

    @Override
    public void writeDocument(Document doc, String url) throws Exception {
        throw new UnsupportedOperationException("ReadOnly");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public ADFLogger getLogger() {
        if (this.mLogger == null) {
            this.mLogger = ADFLogger.createADFLogger(this.getClass());
        }
        return this.mLogger;
    }

    private InputStream getDocumentStream() {
        ClassLoader cl = ClassUtils.getClassLoader();
        InputStream is = cl.getResourceAsStream(this.mResourcePath);
        if (is == null && this.mResourcePath.startsWith("/")) {
            this.mResourcePath = this.mResourcePath.substring(1);
            is = cl.getResourceAsStream(this.mResourcePath);
        }
        return is;
    }
}

