/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import oracle.adf.share.jndi.ConnectionException;
import oracle.adf.share.jndi.ContextImpl;

class NameClassEnumerator
implements NamingEnumeration {
    private static final String NAME_KEY_SEP = "@$$@";
    protected Iterator mRefIterator;
    protected ContextImpl mCtx;

    NameClassEnumerator(ContextImpl ctx) {
        this.mCtx = ctx;
    }

    @Override
    public boolean hasMoreElements() {
        try {
            return this.hasMore();
        }
        catch (NamingException ex) {
            return false;
        }
    }

    @Override
    public boolean hasMore() throws NamingException {
        this.ensureIterator();
        return this.mRefIterator.hasNext();
    }

    public Object next() throws NamingException {
        Map.Entry<String, Reference> refEntry = this.nextReference();
        if (refEntry != null) {
            Reference ref = refEntry.getValue();
            if (ref != null && ref instanceof Reference) {
                Reference refer = ref;
                return new NameClassPair(refEntry.getKey(), refer.getClassName());
            }
            if (ref instanceof ConnectionException) {
                ConnectionException cex = (ConnectionException)((Object)ref);
                return new NameClassPair(refEntry.getKey(), cex.getClassName());
            }
        }
        return null;
    }

    @Override
    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "", e);
            e.printStackTrace();
            throw new NoSuchElementException(e.toString());
        }
    }

    @Override
    public void close() {
        this.mRefIterator = null;
    }

    void ensureIterator() throws NamingException {
        if (this.mRefIterator == null) {
            HashMap<String, Reference> references = new HashMap<String, Reference>(this.mCtx.getReferenceMap());
            String appData = (String)this.mCtx.getEnvironment().get("__adf_share_ref_app_data__");
            if (appData != null && appData.length() > 0) {
                Iterator ei = references.entrySet().iterator();
                while (ei.hasNext()) {
                    Map.Entry ent = ei.next();
                    String k = (String)ent.getKey();
                    int ksi = k.indexOf(NAME_KEY_SEP);
                    if (ksi != -1) {
                        if (k.endsWith(NAME_KEY_SEP + appData)) continue;
                        ei.remove();
                        continue;
                    }
                    if (!references.containsKey(k + NAME_KEY_SEP + appData)) continue;
                    ei.remove();
                }
            }
            this.mRefIterator = references.entrySet().iterator();
        }
    }

    Map.Entry<String, Reference> nextReference() throws NamingException {
        this.ensureIterator();
        return (Map.Entry)this.mRefIterator.next();
    }

    ContextImpl getOwningContext() {
        return this.mCtx;
    }
}

