/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.PartialResultException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.event.NamingListener;
import oracle.adf.share.ADFContext;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.jndi.AdfJndiContext;
import oracle.adf.share.jndi.BindingsEnumerator;
import oracle.adf.share.jndi.ConnectionEventContext;
import oracle.adf.share.jndi.ConnectionReference;
import oracle.adf.share.jndi.ContextSaveListener;
import oracle.adf.share.jndi.DocumentBackingStore;
import oracle.adf.share.jndi.DocumentHelper;
import oracle.adf.share.jndi.EventContextHelper;
import oracle.adf.share.jndi.FileSystemBackingStore;
import oracle.adf.share.jndi.NameClassEnumerator;
import oracle.adf.share.jndi.NameParserImpl;
import oracle.adf.share.jndi.ProviderProperties;
import oracle.adf.share.jndi.ReferenceStoreHelper;
import oracle.adf.share.jndi.xml.v2.ObjectFactory;
import oracle.adf.share.jndi.xml.v2.ReferenceListType;
import oracle.adf.share.logging.ADFLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ContextImpl
implements AdfJndiContext,
ProviderProperties,
ConnectionEventContext {
    private Hashtable mEnv = null;
    private transient DocumentBackingStore mStore = null;
    private transient Hashtable mBindings;
    private transient ObjectFactory objectFactory = null;
    private transient Object mRefStoreLock = new Object();
    private transient ReferenceStoreHelper mRefStore = new ReferenceStoreHelper();
    private static final String JAR_CONNECTIONS_XML = "META-INF/jar-connections.xml";
    private ADFLogger mLogger = null;
    private EventContextHelper eventCtxHelper = null;
    public static final String APPLICATION_LEVEL_CACHE_KEY = "_cache_application_scope_";
    private transient Map referencesMap = null;
    private static final String resourceBundle = "oracle.adf.share.jndi.resources.Messages";
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("oracle.adf.share.jndi.resources.Messages");
    private static final String NAME_KEY_SEP = "@$$@";

    ContextImpl(Hashtable env) throws NamingException {
        this.mEnv = env;
        this.init();
    }

    public boolean hasChanged() throws NamingException {
        boolean hasChanged = false;
        if (this.mStore != null) {
            hasChanged = this.mStore.hasChanged(this.getDocumentUrl());
        }
        return hasChanged;
    }

    private Exists[] getExists(Name name) throws NamingException {
        Exists[] ret = new Exists[2];
        String id = this.getMyComponents(name);
        int i = id.indexOf(NAME_KEY_SEP);
        String appData = (String)this.mEnv.get("__adf_share_ref_app_data__");
        if (i != -1) {
            ret[0] = new Exists(id);
            if (this.exists(id)) {
                ret[0].exists = true;
                return ret;
            }
            name = NameParserImpl.getInstance().parse(id.substring(0, i));
        } else if (appData != null && appData.length() > 0) {
            String bigId = id + NAME_KEY_SEP + appData;
            ret[0] = new Exists(bigId);
            if (this.exists(bigId)) {
                ret[0].exists = true;
                return ret;
            }
        }
        ret[1] = new Exists(id);
        ret[1].exists = this.exists(id);
        return ret;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Exists[] ide = this.getExists(name);
        if (ide[0] != null && ide[0].exists) {
            return this.findObject(NameParserImpl.getInstance().parse(ide[0].id));
        }
        return this.findObject(NameParserImpl.getInstance().parse(ide[1].id));
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        long start = System.currentTimeMillis();
        String id = this.getMyComponents(name);
        if (id.indexOf(NAME_KEY_SEP) == -1) {
            String appData = (String)this.mEnv.get("__adf_share_ref_app_data__");
            if (appData != null) {
                id = id + NAME_KEY_SEP + appData;
            }
            name = this.getNameParser((Name)null).parse(id);
        }
        if (this.exists(id)) {
            throw new NameAlreadyBoundException(id);
        }
        this.bindObject(name, obj);
        Binding binding = new Binding(id, obj.getClass().getName(), obj, true);
        this.eventCtxHelper.fireObjectAddedEvent(binding);
        long end = System.currentTimeMillis();
        this.getLogger().finest(resBundle.getString("BINDING_PERFORMANCE"), new Object[]{name.toString(), end - start});
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(NameParserImpl.getInstance().parse(name), obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        String id = this.getMyComponents(name);
        if (id.indexOf(NAME_KEY_SEP) == -1) {
            String appData = (String)this.mEnv.get("__adf_share_ref_app_data__");
            if (appData != null) {
                id = id + NAME_KEY_SEP + appData;
            }
            name = this.getNameParser((Name)null).parse(id);
        }
        Object oldObj = null;
        Binding oldBinding = new Binding(id, (Object)null);
        if (this.exists(id)) {
            try {
                this.addToEnvironment("AdfJndiHelper_IsConnectionInitRequired", false);
                oldObj = this.lookup(name);
                oldBinding = new Binding(id, oldObj.getClass().getName(), oldObj, true);
            }
            catch (PartialResultException pre) {
                oldObj = pre.getResolvedObj();
            }
            catch (Exception e) {
            }
            finally {
                this.removeFromEnvironment("AdfJndiHelper_IsConnectionInitRequired");
            }
        }
        this.removeObject(name);
        this.bindObject(name, obj);
        Binding newBinding = new Binding(id, obj.getClass().getName(), obj, true);
        this.eventCtxHelper.fireObjectChangedEvent(newBinding, oldBinding);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(NameParserImpl.getInstance().parse(name), obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        String appData;
        Object oldObj = null;
        String id = this.getMyComponents(name);
        if (id.indexOf(NAME_KEY_SEP) == -1 && (appData = (String)this.mEnv.get("__adf_share_ref_app_data__")) != null) {
            id = id + NAME_KEY_SEP + appData;
            name = this.getNameParser((Name)null).parse(id);
        }
        Binding binding = new Binding(id, (Object)null);
        if (this.exists(id)) {
            try {
                oldObj = this.lookup(name);
                binding = new Binding(id, oldObj.getClass().getName(), oldObj, true);
            }
            catch (PartialResultException pre) {
                oldObj = pre.getResolvedObj();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.removeObject(name);
        this.eventCtxHelper.fireObjectRemovedEvent(binding);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(NameParserImpl.getInstance().parse(oldName), NameParserImpl.getInstance().parse(newName));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw new OperationNotSupportedException();
        }
        return new NameClassEnumerator(this);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(NameParserImpl.getInstance().parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw new OperationNotSupportedException();
        }
        return new BindingsEnumerator(this);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return NameParserImpl.getInstance();
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return null;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(NameParserImpl.getInstance().parse(name), NameParserImpl.getInstance().parse(prefix)).toString();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.mEnv.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.mEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.mEnv.clone();
    }

    @Override
    public void close() throws NamingException {
        this.saveDocument(this.getDocumentUrl());
        this.eventCtxHelper.clearAllNamingListeners();
        this.eventCtxHelper = null;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    private void init() throws NamingException {
        Map<String, Object> map;
        if (this.cacheEnabled()) {
            this.mBindings = new Hashtable(12);
        }
        this.initDocStoreAndEventContext();
        if (this.mEnv.get(APPLICATION_LEVEL_CACHE_KEY) != null && (map = ADFContext.getCurrent().getApplicationScope()).containsKey(APPLICATION_LEVEL_CACHE_KEY)) {
            this.referencesMap = (Map)map.get(APPLICATION_LEVEL_CACHE_KEY);
            this.mRefStore.init(null, this, this.mEnv);
            return;
        }
        try {
            this.load();
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
        }
    }

    private void initDocStoreAndEventContext() throws NamingException {
        String url = this.getDocumentUrl();
        this.mStore = this.createDocumentBackingStore();
        try {
            this.mStore.initialize(this.mEnv, url);
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        this.eventCtxHelper = new EventContextHelper(this);
    }

    protected DocumentBackingStore createDocumentBackingStore() throws NamingException {
        this.mEnv.put("oracle.adf.share.jndi.context", this);
        String storeClassName = (String)this.mEnv.get("oracle.adf.share.jndi.documentstore");
        if (this.getLogger().isFine()) {
            this.getLogger().log(Level.FINE, "Backing Store :" + storeClassName);
        }
        if (storeClassName != null && storeClassName.length() > 0) {
            try {
                Class cls = ClassUtils.forName((String)storeClassName);
                if (!DocumentBackingStore.class.isAssignableFrom(cls)) {
                    throw new NamingException(MessageFormat.format(resBundle.getString("NOT_ASSIGNABLE_DOC"), storeClassName, DocumentBackingStore.class.getName()));
                }
                return (DocumentBackingStore)cls.newInstance();
            }
            catch (InstantiationException ex) {
                this.throwNamingException(ex);
            }
            catch (IllegalAccessException ex) {
                this.throwNamingException(ex);
            }
            catch (ClassNotFoundException ex) {
                this.throwNamingException(ex);
            }
        }
        return new FileSystemBackingStore();
    }

    public ADFLogger getLogger() {
        if (this.mLogger == null) {
            this.mLogger = ADFLogger.createADFLogger(this.getClass());
        }
        return this.mLogger;
    }

    @Override
    public Map<String, Reference> getReferenceMap() throws NamingException {
        if (this.referencesMap != null) {
            return this.referencesMap;
        }
        this.referencesMap = this.mRefStore.getReferencesMap();
        return this.referencesMap;
    }

    private void throwNamingException(Exception ex) throws NamingException {
        NamingException nex;
        if (ex instanceof NamingException) {
            nex = (NamingException)ex;
        } else {
            nex = new NamingException();
            nex.setRootCause(ex);
        }
        throw nex;
    }

    private String getDocumentUrl() throws NamingException {
        String url = (String)this.mEnv.get("java.naming.provider.url");
        if (url == null) {
            throw new NamingException(resBundle.getString("MISSING_URL"));
        }
        this.getLogger().finest(resBundle.getString("PROVIDER_URL"), (Object)url);
        return url;
    }

    private String getMyComponents(Name name) throws NamingException {
        if (name instanceof CompositeName) {
            if (name.size() > 1) {
                throw new InvalidNameException(MessageFormat.format(resBundle.getString("EXTRA_NAME_COMPONENTS"), name.toString()));
            }
            return name.get(0);
        }
        return name.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object findObject(Name name) throws NamingException {
        Object refObj;
        String id = this.getMyComponents(name);
        Object bound = null;
        if (this.cacheEnabled() && (bound = (Object)this.mBindings.get(id)) != null) {
            return bound;
        }
        Reference ref = null;
        if (this.referencesMap != null) {
            refObj = this.referencesMap.get(id);
            if (refObj instanceof Throwable) {
                NamingException ne = new NamingException();
                ne.setRootCause((Throwable)refObj);
                throw ne;
            }
            ref = (Reference)refObj;
        }
        refObj = this.mRefStoreLock;
        synchronized (refObj) {
            try {
                bound = this.mRefStore.getObjectForReference(id, ref, true);
            }
            catch (Exception e) {
                this.throwNamingException(e);
            }
        }
        if (bound == null) {
            NameNotFoundException nnfe = new NameNotFoundException();
            nnfe.setRemainingName(name);
            throw nnfe;
        }
        if (bound instanceof ConnectionReference && ((ConnectionReference)bound).isPartial()) {
            PartialResultException pre = new PartialResultException(resBundle.getString("INCOMPLETE_RESULTS"));
            pre.setResolvedObj(bound);
            throw pre;
        }
        if (this.cacheEnabled()) {
            this.mBindings.put(id, bound);
        }
        return bound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindObject(Name name, Object obj) throws NamingException {
        if (this.mStore == null || this.mStore.isReadOnly()) {
            throw new NamingException(resBundle.getString("READ_ONLY_STORE"));
        }
        Reference reference = this.getObjectReference(obj);
        String id = this.getMyComponents(name);
        this.mRefStore.addReference(id, reference);
        Map map = this.referencesMap;
        synchronized (map) {
            this.referencesMap.put(id, reference);
        }
    }

    private Reference getObjectReference(Object obj) throws OperationNotSupportedException, NamingException {
        Reference reference = null;
        if (obj instanceof Reference) {
            reference = (Reference)obj;
        } else if (obj instanceof Referenceable) {
            reference = ((Referenceable)obj).getReference();
        } else {
            throw new OperationNotSupportedException(resBundle.getString("INVALID_OBJECT_TYPE"));
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeObject(Name name) throws NamingException {
        if (this.mStore == null || this.mStore.isReadOnly()) {
            throw new NamingException("READ_ONLY_STORE");
        }
        String id = this.getMyComponents(name);
        if (this.cacheEnabled()) {
            this.mBindings.remove(id);
        }
        Object object = this.mRefStoreLock;
        synchronized (object) {
            this.mRefStore.removeReference(id);
        }
        object = this.referencesMap;
        synchronized (object) {
            this.referencesMap.remove(id);
        }
    }

    private boolean exists(Name name) throws NamingException {
        String id = this.getMyComponents(name);
        return this.exists(id);
    }

    private boolean exists(String id) throws NamingException {
        Object bound;
        if (this.cacheEnabled() && (bound = this.mBindings.get(id)) != null) {
            return true;
        }
        if (this.referencesMap != null) {
            return this.referencesMap.containsKey(id);
        }
        return this.mRefStore.exists(id);
    }

    private ReferenceListType createReferenceListType(Document doc) {
        Element element = doc.getDocumentElement();
        NodeList childNodes = element.getChildNodes();
        if (childNodes.getLength() <= 0) {
            return null;
        }
        ReferenceListType references = new ReferenceListType();
        references.getReference().addAll(DocumentHelper.getReference(childNodes));
        return references;
    }

    private void initReferencesFromDocument(String url) throws Exception {
        Document doc = this.mStore.readDocument(url);
        this.mRefStore.init(this.createReferenceListType(doc), this, this.mEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws NamingException {
        block7: {
            try {
                Map<String, Object> applicationScope;
                String url = this.getDocumentUrl();
                if (this.mStore != null && this.mStore.documentExists(url)) {
                    this.initReferencesFromDocument(url);
                } else {
                    this.mRefStore.init(null, this, this.mEnv);
                }
                this.referencesMap = this.mRefStore.getReferencesMapEx(true);
                if (this.mEnv.get(APPLICATION_LEVEL_CACHE_KEY) == null) break block7;
                Map<String, Object> map = applicationScope = ADFContext.getCurrent().getApplicationScope();
                synchronized (map) {
                    applicationScope.put(APPLICATION_LEVEL_CACHE_KEY, this.referencesMap);
                }
            }
            catch (Exception ex) {
                this.throwNamingException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDocument(String url) throws NamingException {
        ReferenceListType saveableReferences;
        if (!this.mStore.isReadOnly() && (saveableReferences = this.mRefStore.getSaveableReferences()) != null) {
            try {
                this.mRefStore.saveCredentials();
                Document doc = this.mStore.createDocument(url);
                if (doc != null) {
                    DocumentHelper.buildConnectionsDocument(doc, saveableReferences);
                }
                this.mStore.writeDocument(doc, url);
                this.mStore.closeDocument(url);
                this.eventCtxHelper.fireContextSavedEvent();
            }
            catch (Exception ex) {
                this.throwNamingException(ex);
            }
            finally {
                saveableReferences = null;
            }
        }
    }

    @Override
    public void reload() throws NamingException {
        this.load();
    }

    @Override
    public void save() throws NamingException {
        this.saveDocument(this.getDocumentUrl());
    }

    @Override
    public void saveAs(String url) throws NamingException {
        this.saveDocument(url);
    }

    ReferenceStoreHelper getReferenceStoreHelper() {
        return this.mRefStore;
    }

    private boolean cacheEnabled() {
        return false;
    }

    @Override
    public void addNamingListener(Name target, int scope, NamingListener l) throws NamingException {
        this.eventCtxHelper.addNamingListener(target, scope, l);
    }

    @Override
    public void addNamingListener(String target, int scope, NamingListener l) throws NamingException {
        this.addNamingListener(NameParserImpl.getInstance().parse(target), scope, l);
    }

    @Override
    public void removeNamingListener(NamingListener l) throws NamingException {
        this.eventCtxHelper.removeNamingListener(l);
    }

    @Override
    public void addContextSaveListener(ContextSaveListener l) throws NamingException {
        this.addNamingListener("", 0, (NamingListener)l);
    }

    @Override
    public void removeContextSaveListener(ContextSaveListener l) throws NamingException {
        this.removeNamingListener(l);
    }

    @Override
    public boolean targetMustExist() {
        return true;
    }

    private static class Exists {
        String id = null;
        boolean exists = false;

        public Exists(String id) {
            this.id = id;
        }

        public final boolean isNull() {
            return this.id == null;
        }

        public Name getName() throws NamingException {
            return NameParserImpl.getInstance().parse(this.id);
        }
    }
}

