/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.config;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.adf.share.ADFSettings;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.config.ConfigHelper;
import oracle.adf.share.logging.ADFLogger;

public class ADFSettingsImpl
implements ADFSettings {
    public static final String CALLBACK_FILE = "META-INF/services/adf-settings.properties";
    public static final String ADF_CONFIG_CHILD = "adf-settings-child";
    public static final String CLASSNAME = "oracle.adf.share.config.ADFSettingsImpl";
    private static final String CALLBACK_METHOD = "parseADFSettings";
    private Map<String, Map> storedResults = new Hashtable<String, Map>(10);
    private static final ADFLogger mLogger = ADFLogger.createADFLogger((String)"oracle.adf.share.config.ADFSettingsImpl");
    private Map<String, String> callbackMap = null;
    private Map storeParsedElements = new Hashtable(10);

    ADFSettingsImpl() {
        this.callbackMap = ConfigHelper.registerCallbackListeners(CALLBACK_FILE);
        try {
            this.readConfig();
        }
        catch (IOException e) {
            mLogger.severe(CLASSNAME, (Throwable)e);
        }
    }

    @Override
    public Map getConfigObject(String namespace) {
        List res;
        if (this.storedResults.get(namespace) == null && (res = (List)this.storeParsedElements.get(namespace)) != null) {
            for (int i = 0; i < res.size(); ++i) {
                ConfigHelper.ADFIntialParseResult ps = (ConfigHelper.ADFIntialParseResult)res.get(i);
                Map mapResult = ConfigHelper.getResultFromComponent(CALLBACK_METHOD, this.callbackMap, ps.app, this.storedResults.get(namespace), ps.ctx, ps.resource, ps.filePath);
                if (mapResult == null) continue;
                this.storedResults.put(namespace, mapResult);
            }
        }
        if (this.storedResults.get(namespace) == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this.storedResults.get(namespace));
    }

    private void readConfig() throws IOException {
        Enumeration settingsFiles;
        if (System.getSecurityManager() == null) {
            settingsFiles = ClassUtils.getClassLoader().getResources("META-INF/adf-settings.xml");
        } else {
            try {
                settingsFiles = AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration>(){

                    @Override
                    public Enumeration run() throws IOException {
                        return ClassUtils.getClassLoader().getResources("META-INF/adf-settings.xml");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
        }
        while (settingsFiles.hasMoreElements()) {
            URL url = (URL)settingsFiles.nextElement();
            this.parseSettings(url);
        }
    }

    private void parseSettings(URL url) {
        Set<String> namespaceSet = this.callbackMap.keySet();
        if (namespaceSet == null || namespaceSet.isEmpty()) {
            return;
        }
        ConfigHelper.getParsedElements(url, namespaceSet, this.storeParsedElements);
    }
}

