/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share;

import java.beans.Beans;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.servlet.jsp.el.VariableResolver;
import oracle.adf.share.ADFConfig;
import oracle.adf.share.ADFConfigEx;
import oracle.adf.share.ADFContextManager;
import oracle.adf.share.ADFScope;
import oracle.adf.share.ADFSettings;
import oracle.adf.share.ContextInfo;
import oracle.adf.share.DefaultContext;
import oracle.adf.share.DefaultNamedContext;
import oracle.adf.share.Environment;
import oracle.adf.share.HashMapScopeAdapter;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.util.ADFPropertiesUtil;
import oracle.adf.share.config.ADFConfigFactory;
import oracle.adf.share.config.ADFContextMDSConfigHelper;
import oracle.adf.share.config.ConfigContainerFactory;
import oracle.adf.share.config.resources.Messages;
import oracle.adf.share.el.ADFContextVariableResolverImpl;
import oracle.adf.share.el.ADFExpressionEvaluator;
import oracle.adf.share.el.OracleExpressionEvaluatorImpl;
import oracle.adf.share.exception.PageFlowScopeException;
import oracle.adf.share.exception.ViewScopeException;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.JAASInitialContextFactory;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.identitymanagement.UserProfile;
import oracle.adf.share.statemanager.StateManagerScopeAdapter;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.ServerPlatformSupportFactory;

public abstract class ADFContext {
    public static final int TYPE_GENERIC = 1;
    public static final int TYPE_HTTP = 2;
    public static final int TYPE_PORTLET = 3;
    public static final int TYPE_NAMED = 4;
    public static final String MDS_PARTITION_APPID = "partition_customizations_by_application_id";
    public static final String MDS_SESSION_OPTIONS_FACTORY = "oracle.adf.share.mds.SessionOptionsFactory";
    public static final String SESSION_SCOPE = "sessionScope";
    public static final String REQUEST_SCOPE = "requestScope";
    public static final String APPLICATION_SCOPE = "applicationScope";
    public static final String VIEW_SCOPE = "viewScope";
    public static final String SESSIONDEF_BASE_PACKAGE = "sessiondef";
    public static final String PERSDEF_BASE_PACKAGE = "persdef";
    public static final String OVERRIDE_RES_BUNDLE_PACKAGE = "xliffBundles";
    private static final String SKIP_LEVEL_ID = "#$skip$#";
    private static final String ENTERPRISE_ID = "ENTERPRISE_ID";
    private static final String SESSION_ENTERPRISE_ID = "SESSION_ENTERPRISE_ID";
    private static final String SESSION_ENTERPRISE_NAME = "SESSION_ENTERPRISE_NAME";
    private static final String SESSION_KEY_CACHED = "CACHED";
    private static final String SESSION_KEY_VALUE = "VALUE";
    private static final String SESSION_KEY_SEPARATOR = "_";
    private static final String TENANT_GUID = "orclMTTenantGUID";
    private static final String TENANT_NAME = "orclMTTenantUName";
    private static final String TENANT_UID_SEPARATOR = ".";
    public static final String NAMED_CONTEXT_ENV = "named.adf.context";
    public static final String USE_ROLE_BASED_CUST_CLASS = "useRoleBasedCustClass";
    public static final String USER_CUST_CLASSES = "mds.cust.classes";
    public static final String ADF_SESSIONDEF_PACKAGES = "adf.sessiondef.packages";
    public static final String MDS_CC_VALUES_FOR_EDIT = "mds.cc.values.for.edit";
    public static final String OVERRIDDEN_RES_BUNDLES = "overriddenResBundles";
    public static final String APPLICATION_DATA_KEY = "__adf_share_ref_app_data__";
    public static final String APPLICATION_DATA_SEP = "@$$@";
    protected static final String APPLICATION_NAME_SCOPE_KEY = "__adf_applicationname_scope__";
    public static final String CONNECTIONS_RESOURCE = "META-INF/connections.xml";
    public static final String ADF_PROPERTY_NS = "http://xmlns.oracle.com/adf/config/properties";
    public static final String APPLICATION_UID = "adfAppUID";
    private static final String FACES_CONTEXT_CLASS = "AdfFacesContextClass";
    private static final String SEARCHED_FACES_CONTEXT_CLASS = "SearchedAlready";
    private static final String FACES_CLASS = "oracle.adf.view.rich.context.AdfFacesContext";
    private static final String IS_TRINIDAD = "_adfctx_IsTrinidadInUse_";
    private static final String TRINIDAD_CLASS = "org.apache.myfaces.trinidad.context.RequestContext";
    private static final String GET_VIEW_MAP = "getViewMap";
    private static final String GET_VIEW_SCOPE = "getViewScope";
    private static final String GET_PAGEFLOW_SCOPE = "getPageFlowScope";
    private static final String GET_CURRENT_INSTANCE = "getCurrentInstance";
    public static final String ORACLE_MULTITENANT_ENABLED = "oracle.multitenant.enabled";
    public static final String ATTRIBUTE_FORMATTER_MAP_KEY = "attributeFormatterMap";
    private SecurityContext securityContext;
    private String mLoginStr = null;
    private Object mdsSession = null;
    private List sessDefPackages = null;
    private Locale mLocale = null;
    private boolean mIsAuthChecked = false;
    private boolean mIsAuthEnabled = false;
    private static volatile Boolean mIsJEE = null;
    private transient Map<String, Map<String, Object>> scopeMap = new HashMap<String, Map<String, Object>>(4);
    private static Map<Object, Map<String, Object>> mApplicationScopeMap = new WeakHashMap<Object, Map<String, Object>>(4);
    private transient ADFExpressionEvaluator mExpressionEvaluator = new OracleExpressionEvaluatorImpl();
    private transient VariableResolver mVariableResolver = null;
    private transient ExpressionFactory mExpressionFactory = null;
    private static ThreadLocal contextStore = null;
    private static transient Map<String, ContextInfo> contextInfos = new HashMap<String, ContextInfo>();
    private static transient Map<String, ADFContext> namedContextMap = new HashMap<String, ADFContext>();
    private static transient Object namedContextLock = new Object();
    private static final ADFLogger logger = ADFLogger.createADFLogger(ADFContext.class);
    private static final String className = ADFContext.class.getName();
    private static ADFContextMDSConfigHelper _mdsConfigHelper = null;
    private Map mThreadLocalMap = new HashMap(4);
    private static final String resourceBundle = Messages.class.getName();
    private static final ResourceBundle resBundle = ResourceBundle.getBundle(resourceBundle);
    private static final String JBOSS_CONNECTION_WRAPPER = "org.jboss.resource.adapter.jdbc.WrappedConnection";
    private static Class jBossConnectionWrapperClass = null;
    private static boolean alreadyCheckedForJBoss = false;
    private static boolean isJBossRuntime = false;

    protected ADFContext() {
        ADFContextManager.manageADFContext(this);
    }

    protected abstract Environment loadEnvironment();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putScope(String name, Map<String, Object> scope) {
        if (scope != null && !(scope instanceof ADFScope) && logger.isSevere()) {
            logger.severe("Error:  Registered a scope that does not implement ADFScope:  " + name);
        }
        if (APPLICATION_SCOPE.equals(name)) {
            this.putApplicationScopeMap(scope);
        } else if (VIEW_SCOPE.equals(name)) {
            throw new RuntimeException("ADFCONTEXT_CANT_REGISTER_VIEW_SCOPE");
        }
        Map<String, Map<String, Object>> map = this.scopeMap;
        synchronized (map) {
            this.scopeMap.put(name, scope);
        }
    }

    void connectionsChanged(String filePath) {
        URL url = ClassUtils.getClassLoader().getResource(CONNECTIONS_RESOURCE);
        if (url != null && url.getPath().equals(filePath)) {
            this.getApplicationScope().remove("_cache_application_scope_");
        }
    }

    public boolean isDesignTime() {
        return Beans.isDesignTime();
    }

    public Map<String, Object> getScope(String name) {
        Map scope = this.findScope(name);
        if (scope == null) {
            if (APPLICATION_SCOPE.equals(name)) {
                scope = this.getApplicationScopeMap();
            } else if (!VIEW_SCOPE.equals(name)) {
                scope = this.createScope(name);
                this.putScope(name, scope);
            } else {
                return this.getViewScope();
            }
        }
        return scope;
    }

    public Map<String, Object> findScope(String name) {
        if (APPLICATION_SCOPE.equals(name)) {
            return this.findApplicationScopeMap();
        }
        if (VIEW_SCOPE.equals(name)) {
            Map<String, Object> context = this.findScope(APPLICATION_SCOPE);
            if (context != null) {
                if (context.get(SEARCHED_FACES_CONTEXT_CLASS) == null) {
                    return null;
                }
                return this.getViewScope();
            }
            return null;
        }
        return this.scopeMap.get(name);
    }

    protected Object getApplicationScopekey() {
        return this.getADFConfig().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putApplicationScopeMap(Map<String, Object> scope) {
        Object key = this.getApplicationScopekey();
        Map<Object, Map<String, Object>> map = mApplicationScopeMap;
        synchronized (map) {
            mApplicationScopeMap.put(key, scope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> getApplicationScopeMap() {
        Map<String, Object> scope = null;
        Map<Object, Map<String, Object>> map = mApplicationScopeMap;
        synchronized (map) {
            scope = this.findScope(APPLICATION_SCOPE);
            if (scope == null) {
                scope = this.createScope(APPLICATION_SCOPE, true);
                mApplicationScopeMap.put(this.getApplicationScopekey(), scope);
            }
        }
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> findApplicationScopeMap() {
        Object key = this.getApplicationScopekey();
        Map<Object, Map<String, Object>> map = mApplicationScopeMap;
        synchronized (map) {
            return mApplicationScopeMap.get(key);
        }
    }

    public Map<String, Object> getViewScope() {
        Map<String, Object> map = this.getADFFacesViewScopeMap();
        if (map == null && logger.isFine()) {
            logger.fine("Null viewScope found ");
        }
        return map;
    }

    private Object getCurrentInstance(Class contextClass) throws Exception {
        Class[] argTypes = new Class[]{};
        Object[] args = new Object[]{};
        Method getCurrentInstanceMethod = contextClass.getDeclaredMethod(GET_CURRENT_INSTANCE, argTypes);
        return getCurrentInstanceMethod.invoke(null, args);
    }

    public Map<String, Object> getADFFacesViewScopeMap() {
        Class contextClass = null;
        try {
            contextClass = this.findFacesOrTrinidadContextClass();
            if (contextClass != null) {
                String methodName;
                Object adfFacesContext;
                block13: {
                    adfFacesContext = null;
                    methodName = GET_VIEW_SCOPE;
                    Map<String, Object> appScope = this.getScope(APPLICATION_SCOPE);
                    Boolean isTrinidad = null;
                    try {
                        adfFacesContext = this.getCurrentInstance(contextClass);
                        isTrinidad = (Boolean)appScope.get(IS_TRINIDAD);
                        if (isTrinidad != null && isTrinidad.booleanValue()) {
                            methodName = GET_VIEW_MAP;
                        }
                        if (logger.isFine()) {
                            logger.fine("oracle.adf.view.rich.context.AdfFacesContext used to get ViewScope");
                        }
                    }
                    catch (Throwable ex) {
                        if (isTrinidad == null || isTrinidad.booleanValue()) break block13;
                        try {
                            Class trinidadContextClass = ClassUtils.forName((String)TRINIDAD_CLASS);
                            if (appScope != null) {
                                appScope.put(FACES_CONTEXT_CLASS, trinidadContextClass);
                                appScope.put(IS_TRINIDAD, true);
                            }
                            adfFacesContext = this.getCurrentInstance(trinidadContextClass);
                            methodName = GET_VIEW_MAP;
                            if (logger.isFine()) {
                                logger.fine("org.apache.myfaces.trinidad.context.RequestContext used to get ViewScope");
                            }
                        }
                        catch (Exception e) {
                            throw new ViewScopeException(e);
                        }
                    }
                }
                if (adfFacesContext != null) {
                    Object[] args = new Object[]{};
                    return (Map)adfFacesContext.getClass().getMethod(methodName, new Class[0]).invoke(adfFacesContext, args);
                }
                return null;
            }
            throw new ViewScopeException(resBundle.getString("ADFCONTEXT_VIEW_SCOPE_NOT_FOUND"));
        }
        catch (ViewScopeException ve) {
            throw ve;
        }
        catch (Throwable e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class findFacesOrTrinidadContextClass() throws ClassNotFoundException {
        Class contextClass = null;
        Map<String, Object> appScope = this.findScope(APPLICATION_SCOPE);
        if (appScope != null && (contextClass = (Class)appScope.get(FACES_CONTEXT_CLASS)) == null && appScope.get(SEARCHED_FACES_CONTEXT_CLASS) == null) {
            try {
                contextClass = this.testFacesOrTrinidadInstance(FACES_CLASS, appScope, false);
                if (contextClass == null) {
                    contextClass = this.testFacesOrTrinidadInstance(TRINIDAD_CLASS, appScope, true);
                }
            }
            catch (ClassNotFoundException e) {
                contextClass = this.testFacesOrTrinidadInstance(TRINIDAD_CLASS, appScope, true);
            }
            finally {
                appScope.put(SEARCHED_FACES_CONTEXT_CLASS, true);
            }
        }
        return contextClass;
    }

    private Class testFacesOrTrinidadInstance(String className, Map<String, Object> appScope, boolean isTrinidad) throws ClassNotFoundException {
        Class viewProviderClass = ClassUtils.forName((String)className);
        try {
            if (this.getCurrentInstance(viewProviderClass) != null) {
                if (appScope == null) {
                    appScope = this.getApplicationScope();
                }
                appScope.put(FACES_CONTEXT_CLASS, viewProviderClass);
                appScope.put(IS_TRINIDAD, isTrinidad);
            } else {
                viewProviderClass = null;
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return viewProviderClass;
    }

    public Map createScope(String name) {
        return this.createScope(name, false);
    }

    protected Map<String, Object> createScope(String name, boolean concurrent) {
        if (VIEW_SCOPE.equals(name)) {
            throw new RuntimeException(resBundle.getString("ADFCONTEXT_CANT_CREATE_VIEW_SCOPE"));
        }
        if (concurrent) {
            return new HashMapScopeAdapter(name, new ConcurrentHashMap(4));
        }
        return new HashMapScopeAdapter(name, new HashMap(4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> removeScope(String name) {
        if (APPLICATION_SCOPE.equals(name)) {
            Object key = this.getApplicationScopekey();
            Map<Object, Map<String, Object>> map = mApplicationScopeMap;
            synchronized (map) {
                return mApplicationScopeMap.remove(key);
            }
        }
        Map<String, Map<String, Object>> map = this.scopeMap;
        synchronized (map) {
            return this.scopeMap.remove(name);
        }
    }

    public Set getScopeNames() {
        Set<String> set = this.scopeMap.keySet();
        if (this.findScope(APPLICATION_SCOPE) != null) {
            HashSet<String> aSet = new HashSet<String>(set);
            aSet.add(APPLICATION_SCOPE);
            return Collections.unmodifiableSet(aSet);
        }
        return set;
    }

    public Map<String, Object> getApplicationScope() {
        return this.getScope(APPLICATION_SCOPE);
    }

    public Map getSessionScope() {
        return this.getScope(SESSION_SCOPE);
    }

    public Map getRequestScope() {
        return this.getScope(REQUEST_SCOPE);
    }

    public ADFConfig getApplication() {
        return this.getADFConfig();
    }

    public ADFConfig getADFConfig() {
        return this.getADFConfigEx();
    }

    private String getSessionKey(String prefix, String body, String suffix) {
        StringBuilder builder = new StringBuilder();
        if (prefix != null) {
            builder.append(prefix);
        }
        builder.append(SESSION_KEY_SEPARATOR);
        if (body != null) {
            builder.append(body);
            builder.append(SESSION_KEY_SEPARATOR);
        }
        if (suffix != null) {
            builder.append(suffix);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEnterpriseId() {
        Map map;
        String eid;
        block13: {
            eid = null;
            map = this.getSessionScope();
            try {
                Map map2 = map;
                synchronized (map2) {
                    SecurityContext context = this.getSecurityContext();
                    if (context != null && context.isAuthenticated()) {
                        String userName = context.getUserName();
                        String cachedKey = this.getSessionKey(SESSION_ENTERPRISE_ID, SESSION_KEY_CACHED, userName);
                        String valueKey = this.getSessionKey(SESSION_ENTERPRISE_ID, SESSION_KEY_VALUE, userName);
                        if (Boolean.TRUE.equals(map.get(cachedKey))) {
                            eid = (String)map.get(valueKey);
                        } else {
                            block12: {
                                try {
                                    UserProfile userProfile = context.getUserProfile();
                                    if (userProfile != null && (eid = (String)userProfile.getProperty(TENANT_GUID)) != null) {
                                        map.put(valueKey, eid);
                                    }
                                }
                                catch (Exception e) {
                                    if (!logger.isFinest()) break block12;
                                    logger.finest("Failed to lookup property orclMTTenantGUID for user " + userName, (Throwable)e);
                                }
                            }
                            map.put(cachedKey, Boolean.TRUE);
                        }
                    }
                }
            }
            catch (Throwable t) {
                if (!logger.isFinest()) break block13;
                logger.finest("Failed to lookup enterprise id", t);
            }
        }
        if (eid == null) {
            eid = (String)map.get(ENTERPRISE_ID);
        }
        return eid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEnterpriseName() {
        String name;
        block13: {
            name = "";
            Map map = this.getSessionScope();
            try {
                Map map2 = map;
                synchronized (map2) {
                    SecurityContext context = this.getSecurityContext();
                    if (context != null && context.isAuthenticated()) {
                        String userName = context.getUserName();
                        String cachedKey = this.getSessionKey(SESSION_ENTERPRISE_NAME, SESSION_KEY_CACHED, userName);
                        String valueKey = this.getSessionKey(SESSION_ENTERPRISE_NAME, SESSION_KEY_VALUE, userName);
                        if (Boolean.TRUE.equals(map.get(cachedKey))) {
                            if (map.get(valueKey) != null) {
                                name = (String)map.get(valueKey);
                            }
                        } else {
                            block12: {
                                try {
                                    String tenantName;
                                    UserProfile userProfile = context.getUserProfile();
                                    if (userProfile != null && (tenantName = (String)userProfile.getProperty(TENANT_NAME)) != null && tenantName.length() > 0) {
                                        name = tenantName + TENANT_UID_SEPARATOR;
                                        map.put(valueKey, name);
                                    }
                                }
                                catch (Exception e) {
                                    if (!logger.isFinest()) break block12;
                                    logger.finest("Failed to lookup property orclMTTenantUName for user " + userName, (Throwable)e);
                                }
                            }
                            map.put(cachedKey, Boolean.TRUE);
                        }
                    }
                }
            }
            catch (Throwable t) {
                if (!logger.isFinest()) break block13;
                logger.finest("Failed to lookup enterprise name", t);
            }
        }
        return name;
    }

    public void setEnterpriseId(String eid) {
        Map map = this.getSessionScope();
        map.put(ENTERPRISE_ID, eid);
    }

    public ADFConfigEx getADFConfigEx() {
        return ADFConfigFactory.findOrCreateADFConfig();
    }

    public ADFSettings getADFSettings() {
        return ConfigContainerFactory.findOrCreateConfig("oracle.adf.share.ADFSettings");
    }

    public SecurityContext getSecurityContext() {
        if (this.securityContext == null) {
            try {
                this.securityContext = (SecurityContext)this.getADFConfig().getSecurityContext();
                this.setSecurityContext(this.securityContext);
            }
            catch (NamingException ne) {
                ne.printStackTrace();
            }
        }
        return this.securityContext;
    }

    public boolean hasSecurityContext() {
        if (!this.mIsAuthChecked) {
            this.mIsAuthEnabled = ADFSecurityUtil.isAuthorizationEnabled();
            this.mIsAuthChecked = true;
        }
        if (this.mIsAuthEnabled) {
            return true;
        }
        return this.securityContext != null;
    }

    public Context getConnectionsContext() throws NamingException {
        return this.getADFConfig().getConnectionsContext();
    }

    public static boolean hasCurrent() {
        ADFContext ctx = ADFContext.getCurrentInternal();
        return ctx != null;
    }

    public static ADFContext findCurrent() {
        ADFContext ctx = ADFContext.getCurrentInternal();
        if (ctx == null) {
            throw new RuntimeException("A current ADFContext is not available.");
        }
        return ctx;
    }

    public static ADFContext getCurrent() {
        ADFContext ctx = ADFContext.getCurrentInternal();
        if (ctx == null) {
            boolean designTime = Beans.isDesignTime();
            if (!designTime && logger.isWarning()) {
                logger.warning(className, "getCurrent", "Automatically initializing a DefaultContext for getCurrent.\nCaller should ensure that a DefaultContext is proper for this use.\nMemory leaks and/or unexpected behaviour may occur if the automatic initialization is performed improperly.\nThis message may be avoided by performing initADFContext before using getCurrent().\nTo see the stack trace for thread that is initializing this, set the logging level of oracle.adf.share.ADFContext to FINEST");
            }
            if (logger.isFinest()) {
                StringBuilder sb = new StringBuilder("getCurrent stack trace:\n");
                for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                    sb.append(ste.toString());
                    sb.append("\n");
                }
                logger.finest(sb.toString());
            }
            ctx = ADFContext.createDefaultContext();
        }
        return ctx;
    }

    private static final ADFContext createDefaultContext() {
        DefaultContext ctx = new DefaultContext();
        ctx.setAsCurrent();
        if (logger.isFine()) {
            logger.fine(className, "getCurrent", "DefaultContext is set as current");
        }
        return ctx;
    }

    private static ADFContext getCurrentInternal() {
        return (ADFContext)ADFContext.getContextStore().get();
    }

    public boolean isMultiTenantEnabled() {
        String v = ADFPropertiesUtil.getSystemProperty((String)ORACLE_MULTITENANT_ENABLED);
        if (v == null) {
            return false;
        }
        return v.equalsIgnoreCase("true");
    }

    public String getADFContextProperty(String propName) {
        ADFConfig adfConfig = this.getADFConfig();
        if (adfConfig == null) {
            return null;
        }
        Map propertyMap = adfConfig.getConfigObject(ADF_PROPERTY_NS);
        if (propertyMap == null) {
            return null;
        }
        return (String)propertyMap.get(propName);
    }

    public String getADFApplicationUID() {
        return this.getADFContextProperty(APPLICATION_UID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerNamedContext(String name, URL url, Class implClass) throws NameAlreadyBoundException {
        if (contextInfos.containsKey(name)) {
            throw new NameAlreadyBoundException("NamedContext for this name alreadyexists " + contextInfos);
        }
        ContextInfo info = new ContextInfo(name, url, implClass);
        Object object = namedContextLock;
        synchronized (object) {
            contextInfos.put(name, info);
        }
    }

    public static void registerNamedContext(String name, URL url) throws NameAlreadyBoundException {
        ADFContext.registerNamedContext(name, url, DefaultNamedContext.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterNamedContext(String name) {
        if (!contextInfos.containsKey(name)) {
            if (logger.isFine()) {
                logger.fine(className, "unregisterNamedContext", "Name not found " + name);
            }
            return;
        }
        Object object = namedContextLock;
        synchronized (object) {
            contextInfos.remove(name);
            namedContextMap.remove(name);
        }
        ADFConfigFactory.unregisterNamedConfig(name);
    }

    public static boolean isNamedContextRegistered(String name) {
        return contextInfos.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ADFContext get(String name) throws Exception {
        if (name == null || name.length() == 0) {
            return ADFContext.getCurrent();
        }
        if (!contextInfos.containsKey(name)) {
            throw new RuntimeException("Named ADFContext for " + name + " has not been created");
        }
        ADFContext ctx = namedContextMap.get(name);
        if (ctx == null) {
            ContextInfo info = contextInfos.get(name);
            ctx = info.createContext();
            Object object = namedContextLock;
            synchronized (object) {
                if (ctx != null) {
                    namedContextMap.put(name, ctx);
                }
            }
        }
        return ctx;
    }

    public URL getURL() {
        throw new UnsupportedOperationException();
    }

    public String getApplicationName() {
        Map<String, Object> scope;
        String appName;
        if (logger.isFine()) {
            logger.fine(className, "getApplicationName", "Returns default Name");
        }
        if ((appName = (String)(scope = this.getScope(APPLICATION_SCOPE)).get(APPLICATION_NAME_SCOPE_KEY)) == null) {
            appName = this.getDeployedAppName();
            if (appName == null) {
                appName = "defaultApplicationName";
            }
            scope.put(APPLICATION_NAME_SCOPE_KEY, appName);
        }
        return appName;
    }

    protected String getDeployedAppName() {
        return null;
    }

    public void setAsCurrent() {
        ADFContext oldContext = (ADFContext)ADFContext.getContextStore().get();
        if (oldContext != null) {
            ADFContextManager.removeADFContext(oldContext);
        }
        ADFContext.getContextStore().set(this);
    }

    public void removeAsCurrent() {
        ADFContextManager.removeADFContext(this);
        ADFContext.getContextStore().remove();
    }

    public void setSecurityContext(SecurityContext ctx) {
        this.securityContext = ctx;
    }

    public String getMDSLogin() {
        new UnsupportedOperationException("getMDSLogin() is not supported.  Please don't call this method").printStackTrace();
        return this.mLoginStr;
    }

    public void setMDSLogin(String loginStr) {
        new UnsupportedOperationException("setMDSLogin() is not supported.  Please don't call this method").printStackTrace();
        this.mLoginStr = loginStr;
    }

    protected SecurityContext loadSecurityContext() {
        JAASInitialContextFactory factory = new JAASInitialContextFactory();
        SecurityContext secCtx = null;
        try {
            secCtx = (SecurityContext)factory.getInitialContext((Hashtable)null);
            this.setSecurityContext(secCtx);
        }
        catch (NamingException ne) {
            logger.fine((Throwable)ne);
        }
        return secCtx;
    }

    public Context getConfigSecurityContext() throws NamingException {
        return this.getADFConfig().getSecurityContext();
    }

    public Locale getLocale() {
        if (this.hasEnvironment()) {
            return this.getEnvironment().getRequestLocale();
        }
        return this.mLocale;
    }

    public void setLocale(Locale locale) {
        if (this.mLocale == null) {
            this.mLocale = locale;
        }
    }

    public void clearCachedLocale() {
        this.mLocale = null;
        if (this.hasEnvironment()) {
            this.getEnvironment().clearCachedLocale();
        }
    }

    public final Environment getEnvironment() {
        return this.loadEnvironment();
    }

    public boolean hasEnvironment() {
        return false;
    }

    public VariableResolver getVariableResolver() {
        if (this.mVariableResolver == null) {
            this.mVariableResolver = new ADFContextVariableResolverImpl();
        }
        return this.mVariableResolver;
    }

    public void setVariableResolver(VariableResolver variableResolver) {
        if (variableResolver != null) {
            this.mVariableResolver = variableResolver;
        }
    }

    public ADFExpressionEvaluator getExpressionEvaluator() {
        return this.mExpressionEvaluator;
    }

    public void setExpressionEvaluator(ADFExpressionEvaluator expressionEvaluator) {
        if (expressionEvaluator != null) {
            this.mExpressionEvaluator = expressionEvaluator;
        }
    }

    public ELContext getELContext() {
        ELContext elContext;
        block3: {
            elContext = null;
            try {
                Object facesContext = this.getEnvironment().getFacesContext();
                if (facesContext != null) {
                    Class<?> facesContextClz = facesContext.getClass();
                    Method getELContext = facesContextClz.getMethod("getELContext", null);
                    elContext = (ELContext)getELContext.invoke(facesContext, null);
                }
            }
            catch (Exception e) {
                if (!logger.isFine()) break block3;
                logger.fine("ADFContext.getELContext unable to locate a FacesContext");
            }
        }
        return elContext;
    }

    public ExpressionFactory getExpressionFactory() {
        block4: {
            if (this.mExpressionFactory != null) {
                return this.mExpressionFactory;
            }
            try {
                Object facesContext = this.getEnvironment().getFacesContext();
                if (facesContext != null) {
                    Class<?> facesContextClz = facesContext.getClass();
                    Method getApplication = facesContextClz.getMethod("getApplication", null);
                    Object application = getApplication.invoke(facesContext, null);
                    Class<?> facesApplicationClz = Class.forName("javax.faces.application.Application", true, Thread.currentThread().getContextClassLoader());
                    Method getExpressionFactory = facesApplicationClz.getMethod("getExpressionFactory", null);
                    this.mExpressionFactory = (ExpressionFactory)getExpressionFactory.invoke(application, null);
                }
            }
            catch (Exception e) {
                if (!logger.isFine()) break block4;
                logger.fine("ADFContext.getExpressionFactory unable to locate an expression factory from faces");
            }
        }
        return this.mExpressionFactory;
    }

    protected void setExpressionFactory(ExpressionFactory expressionFactory) {
        if (expressionFactory != null) {
            this.mExpressionFactory = expressionFactory;
        }
    }

    public Map getStateManager(String scopeName, Hashtable env) {
        return new StateManagerScopeAdapter(scopeName, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isJEE() {
        if (mIsJEE != null) return mIsJEE;
        Class<ADFContext> clazz = ADFContext.class;
        synchronized (ADFContext.class) {
            mIsJEE = ADFContext.isJEEUsingJRF();
            if (mIsJEE.booleanValue()) return mIsJEE;
            int contextType = this.getContextType();
            mIsJEE = contextType == 2 || contextType == 3;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mIsJEE;
        }
    }

    public abstract int getContextType();

    public boolean isHttpContext() {
        return false;
    }

    public boolean hasSession() {
        return false;
    }

    public Object getMDSInstanceAsObject() {
        return this.getMDSConfigHelper().getMDSInstance(this);
    }

    public synchronized Object getMDSSessionAsObject() {
        ADFContextMDSConfigHelper helper;
        if (this.mdsSession == null && (helper = this.getMDSConfigHelper()) != null) {
            this.mdsSession = helper.createMDSSession(this);
        }
        return this.mdsSession;
    }

    public synchronized List getSessionDefPackages() {
        if (this.sessDefPackages == null) {
            this.sessDefPackages = this.getADFConfig().getSessionDefPackages();
        }
        return this.sessDefPackages;
    }

    public boolean hasMDSSession() {
        return this.mdsSession != null;
    }

    public void releaseMDSSession() {
        if (this.mdsSession != null) {
            this.mdsSession = null;
        }
    }

    public void releaseMDSInstance() {
        this.releaseMDSSession();
        this.getMDSConfigHelper().releaseMDSInstance(this);
    }

    public Object getSkipLevelIdentifier() {
        return SKIP_LEVEL_ID;
    }

    private static ThreadLocal getContextStore() {
        if (contextStore == null) {
            if (ADFContext.isJEEUsingJRF()) {
                if (logger.isFine()) {
                    logger.fine("Using ThreadLocal variable environment is JEE ");
                }
                contextStore = new ThreadLocal();
            } else {
                if (logger.isFine()) {
                    logger.fine("Using InheritableThreadLocal variable");
                }
                contextStore = new InheritableThreadLocal();
            }
        }
        return contextStore;
    }

    public boolean isWebsphereRuntime() {
        try {
            ServerPlatformSupport helper = ServerPlatformSupportFactory.getInstance();
            if (helper != null) {
                return helper.isWebSphere();
            }
        }
        finally {
            return false;
        }
        {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJBossRuntime() {
        if (alreadyCheckedForJBoss) {
            return isJBossRuntime;
        }
        try {
            jBossConnectionWrapperClass = ClassUtils.getClassLoader().loadClass(JBOSS_CONNECTION_WRAPPER);
            if (jBossConnectionWrapperClass != null) {
                isJBossRuntime = true;
            }
        }
        catch (Throwable t) {
            isJBossRuntime = false;
        }
        finally {
            alreadyCheckedForJBoss = true;
        }
        return isJBossRuntime;
    }

    public Connection getNativeJdbcConnection(Connection datasourceJdbcConnection) {
        if (this.isWebsphereRuntime()) {
            try {
                Class<?> WSJdbcUtilCls = ClassUtils.getClassLoader().loadClass("com.ibm.ws.rsadapter.jdbc.WSJdbcUtil");
                Class<?> WSJdbcConnectionCls = ClassUtils.getClassLoader().loadClass("com.ibm.ws.rsadapter.jdbc.WSJdbcConnection");
                if (WSJdbcConnectionCls.isAssignableFrom(datasourceJdbcConnection.getClass())) {
                    Method getNativeConnection = WSJdbcUtilCls.getMethod("getNativeConnection", WSJdbcConnectionCls);
                    return (Connection)getNativeConnection.invoke(null, datasourceJdbcConnection);
                }
                return datasourceJdbcConnection;
            }
            catch (Throwable e) {
                logger.info(e);
            }
        } else if (this.isJBossRuntime() && jBossConnectionWrapperClass.isAssignableFrom(datasourceJdbcConnection.getClass())) {
            try {
                Method getUnderlyingConnection = jBossConnectionWrapperClass.getMethod("getUnderlyingConnection", null);
                return (Connection)getUnderlyingConnection.invoke((Object)getUnderlyingConnection, datasourceJdbcConnection);
            }
            catch (Exception e) {
                logger.info((Throwable)e);
            }
        }
        return datasourceJdbcConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isJEEUsingJRF() {
        if (mIsJEE != null) return mIsJEE;
        Class<ADFContext> clazz = ADFContext.class;
        synchronized (ADFContext.class) {
            if (mIsJEE != null) return mIsJEE;
            try {
                ServerPlatformSupport helper = ServerPlatformSupportFactory.getInstance();
                mIsJEE = helper.isWebLogic();
                if (!mIsJEE.booleanValue()) {
                    mIsJEE = helper.isWebSphere();
                    if (!mIsJEE.booleanValue() || !logger.isFine()) return mIsJEE;
                    logger.fine("Websphere platform discovered.");
                } else {
                    if (!logger.isFine()) return mIsJEE;
                    logger.fine("Weblogic platform discovered.");
                }
            }
            catch (Throwable t) {
                mIsJEE = false;
            }
            return mIsJEE;
        }
    }

    protected ADFContextMDSConfigHelper getMDSConfigHelper() {
        try {
            if (_mdsConfigHelper != null) {
                return _mdsConfigHelper;
            }
            Class MDSHelperClass = ClassUtils.forName((String)"oracle.adf.share.config.ADFContextMDSConfigHelperImpl", this.getClass());
            _mdsConfigHelper = (ADFContextMDSConfigHelper)MDSHelperClass.newInstance();
            return _mdsConfigHelper;
        }
        catch (Exception e) {
            logger.fine((Throwable)e);
            return null;
        }
    }

    public static Object getThreadLocalValue(Object key) {
        ADFContext ctx = ADFContext.getCurrentInternal();
        if (ctx != null) {
            return ctx.mThreadLocalMap.get(key);
        }
        return null;
    }

    public static void setThreadLocalValue(Object key, Object value) {
        ADFContext.getCurrent().mThreadLocalMap.put(key, value);
    }

    public static Object removeThreadLocalValue(Object key) {
        ADFContext ctx = ADFContext.getCurrentInternal();
        if (ctx != null) {
            return ctx.mThreadLocalMap.remove(key);
        }
        return null;
    }

    protected void initialize() {
    }

    public static ADFContext initADFContext(Object context, Object session, Object request, Object response) {
        ADFContext newContext;
        ADFContext oldContext;
        block8: {
            oldContext = ADFContext.getCurrentInternal();
            newContext = null;
            if (context != null) {
                try {
                    Class<?> adfCtxClz;
                    Class<?> ctxClz = Class.forName("javax.servlet.ServletContext", true, Thread.currentThread().getContextClassLoader());
                    if (ctxClz != null && ctxClz.isInstance(context)) {
                        adfCtxClz = Class.forName("oracle.adf.share.http.ServletADFContext", true, Thread.currentThread().getContextClassLoader());
                        Method init = adfCtxClz.getMethod("initThreadContextIfNeeded", ctxClz);
                        init.invoke(null, context);
                        newContext = ADFContext.getCurrentInternal();
                    }
                    if (newContext != null) break block8;
                    try {
                        ctxClz = Class.forName("javax.portlet.PortletContext", true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException cnfe) {
                        // empty catch block
                    }
                    if (ctxClz != null && ctxClz.isInstance(context)) {
                        adfCtxClz = Class.forName("oracle.adf.share.portlet.PortletADFContext", true, Thread.currentThread().getContextClassLoader());
                        Class<?> reqClz = Class.forName("javax.portlet.PortletRequest", true, Thread.currentThread().getContextClassLoader());
                        Class<?> resClz = Class.forName("javax.portlet.PortletResponse", true, Thread.currentThread().getContextClassLoader());
                        Method init = adfCtxClz.getMethod("initThreadContext", ctxClz, reqClz, resClz);
                        init.invoke(null, context, request, response);
                        newContext = ADFContext.getCurrentInternal();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (newContext == null) {
            newContext = ADFContext.createDefaultContext();
        }
        newContext.initialize();
        return oldContext;
    }

    public static void resetADFContext(ADFContext ctx) {
        if (ctx == null) {
            ADFContext current = ADFContext.getCurrentInternal();
            if (current != null) {
                current.removeAsCurrent();
            }
        } else {
            ctx.setAsCurrent();
        }
    }

    public Map<String, Object> getPageFlowScope() {
        Class contextClass = null;
        try {
            contextClass = this.findFacesOrTrinidadContextClass();
            if (contextClass != null) {
                String methodName;
                Object adfFacesContext;
                block10: {
                    adfFacesContext = null;
                    methodName = GET_PAGEFLOW_SCOPE;
                    Map<String, Object> appScope = this.getScope(APPLICATION_SCOPE);
                    Boolean isTrinidad = null;
                    try {
                        adfFacesContext = this.getCurrentInstance(contextClass);
                        isTrinidad = (Boolean)appScope.get(IS_TRINIDAD);
                    }
                    catch (Throwable ex) {
                        if (isTrinidad == null || isTrinidad.booleanValue()) break block10;
                        try {
                            Class trinidadContextClass = ClassUtils.forName((String)TRINIDAD_CLASS, this.getClass());
                            if (appScope != null) {
                                appScope.put(FACES_CONTEXT_CLASS, trinidadContextClass);
                                appScope.put(IS_TRINIDAD, true);
                            }
                            adfFacesContext = this.getCurrentInstance(trinidadContextClass);
                        }
                        catch (Exception e) {
                            throw new PageFlowScopeException(e);
                        }
                    }
                }
                if (adfFacesContext != null) {
                    Object[] args = new Object[]{};
                    Method method = adfFacesContext.getClass().getMethod(methodName, new Class[0]);
                    Map mapa = (Map)method.invoke(adfFacesContext, args);
                    return mapa;
                }
                return null;
            }
            throw new PageFlowScopeException(resBundle.getString("ADFCONTEXT_PAGEFLOW_SCOPE_NOT_FOUND"));
        }
        catch (PageFlowScopeException ve) {
            throw ve;
        }
        catch (Throwable e) {
            return null;
        }
    }
}

