/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.datamove.offline.Offline3rdPartyPrintStream;
import oracle.dbtools.migration.workbench.core.AbstractMigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.Quoter;
import oracle.dbtools.migration.workbench.core.StatementProvider;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPluginPreferences;
import oracle.dbtools.migration.workbench.offline.Db2OfflineCapturer;
import oracle.dbtools.migration.workbench.plugin.DB2Capturer;
import oracle.dbtools.migration.workbench.plugin.DB2OnlineCapturer;
import oracle.dbtools.migration.workbench.plugin.DB2Provider;
import oracle.dbtools.migration.workbench.plugin.DB2Quoter;
import oracle.dbtools.migration.workbench.plugin.Db2Converter;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;

public abstract class DB2Plugin
extends AbstractMigrationPlugin {
    private static final String EXPORT_COLUMN_DELIMITER = "#";
    private static final String DB2_PLATFORM_NAME = "DB2";
    public static final String DRIVER_CLASS = "com.ibm.db2.jcc.DB2Driver";
    private static boolean s_driverLoaded = false;

    protected String getSupportedMapsXMLFileName() {
        return "/oracle/dbtools/migration/workbench/plugin/DB2SupportedDataTypesMap.xml";
    }

    public ThirdPartyDbProvider getProvider(String string) throws MigrationPluginException {
        try {
            DB2Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string);
            return new DB2Provider(this, connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    public ThirdPartyDbProvider getProvider(String string, Properties properties) throws MigrationPluginException {
        try {
            DB2Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string, properties);
            return new DB2Provider(this, connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    public String getIconFileName() {
        return "/oracle/dbtools/migration/workbench/plugin/db2actions/images/ibmdb2.png";
    }

    public ThirdPartyDbProvider getProvider(String string, String string2, String string3) throws MigrationPluginException {
        try {
            DB2Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string, string2, string3);
            return new DB2Provider(this, connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    public ThirdPartyDbProvider getProvider(Connection connection) throws MigrationPluginException {
        return new DB2Provider(this, connection);
    }

    protected static void loadDriver() throws MigrationPluginException {
        if (!s_driverLoaded) {
            try {
                Class.forName(DRIVER_CLASS).newInstance();
                s_driverLoaded = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MigrationPluginException((Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new MigrationPluginException((Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MigrationPluginException((Throwable)illegalAccessException);
            }
        }
    }

    public MigrationPluginPreferences getPreferencePanel() {
        return null;
    }

    public OfflineCapturer getOfflineCapturer() {
        return new Db2OfflineCapturer();
    }

    public String getPlatformName() {
        return DB2_PLATFORM_NAME;
    }

    public String getPluginName() {
        return this.getPlatformName() + " " + this.getVersionNumber();
    }

    public void registerMenuItems() {
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.migration.workbench.plugin.db2actions");
    }

    public String formatSQLLoaderColumn(MdColumn mdColumn, MdColumn mdColumn2) {
        String string = "";
        String string2 = mdColumn.getColumnType();
        String string3 = mdColumn2.getColumnName();
        String string4 = mdColumn2.getColumnType();
        Integer n = mdColumn2.getPrecision();
        int n2 = 0;
        n2 = n == null ? 0 : n;
        if ((string4.equalsIgnoreCase("CHAR") || string4.equalsIgnoreCase("NCHAR") || string4.equalsIgnoreCase("VARCHAR2") || string4.equalsIgnoreCase("NVARCHAR2")) && n2 >= 255) {
            string = "CHAR(" + n2 + ")";
        }
        if (string2.equalsIgnoreCase("BLOB") || string2.equalsIgnoreCase("CLOB") || string2.equalsIgnoreCase("XML")) {
            string = "CHAR(1000000000)";
        }
        if (string2.equalsIgnoreCase("TIME") || string2.equalsIgnoreCase("TIMESTAMP")) {
            string = "\"TO_TIMESTAMP(:" + string3 + ", '" + MigrationAddin.getMigrationConfig().getTimeStampOfflineDateMask() + "')\"";
        } else if (string2.equalsIgnoreCase("DATE")) {
            string = "\"TO_DATE(:" + string3 + ", '" + MigrationAddin.getMigrationConfig().getDateOfflineDateMask() + "')\"";
        }
        return string;
    }

    public StatementProvider getStatementProviderForDataMove() {
        return new StatementProvider(){

            public Object getColumnValue(ResultSet resultSet, String string) throws SQLException {
                Object object = resultSet.getObject(string);
                if (object != null) {
                    Class<?>[] classArray;
                    for (Class<?> clazz : classArray = object.getClass().getInterfaces()) {
                        if (!clazz.getName().endsWith("DB2Xml")) continue;
                        return resultSet.getString(string);
                    }
                }
                return super.getColumnValue(resultSet, string);
            }
        };
    }

    public Converter getConverter() {
        return new Db2Converter();
    }

    public boolean getDataExportCommmand(String string, MdColumn[] mdColumnArray, String string2, Offline3rdPartyPrintStream offline3rdPartyPrintStream) {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        offline3rdPartyPrintStream.startTable(string);
        try {
            String string3 = string;
            String string4 = string2;
            String string5 = migrationConfig.getEndColumnDelimiter();
            String string6 = "'" + string5 + "'";
            String string7 = migrationConfig.getEndRowDelimiter();
            StringBuffer stringBuffer = new StringBuffer();
            for (MdColumn mdColumn : mdColumnArray) {
                String string8 = mdColumn.getColumnName();
                if ("XML".equals(mdColumn.getColumnType())) {
                    string8 = "XMLSERIALIZE(" + string8 + " AS CLOB)";
                }
                stringBuffer.append(string8).append(",").append(string6).append(",");
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            StringBuffer stringBuffer2 = new StringBuffer("db2 export to ");
            stringBuffer2.append("data\\");
            stringBuffer2.append(string4);
            stringBuffer2.append(" of DEL lobs to ." + File.separator + " modified by " + this.getLobFileOption());
            stringBuffer2.append(" coldel\"#\"");
            stringBuffer2.append(" datesiso nochardel \"select ").append(stringBuffer);
            stringBuffer2.append(", '" + string7).append("' from ").append(this.addQuotesToFileName(string3)).append("\"");
            offline3rdPartyPrintStream.println(stringBuffer2.toString());
            offline3rdPartyPrintStream.endTable();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected String getLobFileOption() {
        return "";
    }

    public String getDataMoveColumnDelimiter() {
        String string = super.getDataMoveColumnDelimiter();
        return EXPORT_COLUMN_DELIMITER + string + EXPORT_COLUMN_DELIMITER;
    }

    public String getDataMoveRowDelimiter() {
        String string = super.getDataMoveRowDelimiter();
        String string2 = this.getNewLineString();
        return string + string2;
    }

    private String getNewLineString() {
        String string = System.getProperty("line.separator");
        string = string.length() == 2 ? "\\r\\n" : "\\n";
        return string;
    }

    private String addQuotesToFileName(String string) {
        String string2 = string.trim();
        String string3 = "\\\"";
        int n = string2.lastIndexOf(46);
        String string4 = new StringBuffer(string2).insert(n + 1, string3).toString();
        string2 = string4 + string3;
        return string2;
    }

    public String getPlatformNameforNavigator() {
        return this.getPlatformName();
    }

    public DB2Capturer getCapturer(MigrationStorer migrationStorer, Connection connection) {
        return new DB2Capturer(migrationStorer, connection){

            @Override
            protected DB2OnlineCapturer getOnlineCapturer(MigrationStorer migrationStorer, Connection connection) {
                return new DB2OnlineCapturer(migrationStorer, connection);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectStatement(Offline3rdPartyPrintStream offline3rdPartyPrintStream) {
        String string = offline3rdPartyPrintStream.getFilePathAndName();
        string = string.substring(0, string.lastIndexOf(".")) + ".sh";
        String string2 = "";
        String string3 = string.substring(0, string.lastIndexOf(".")) + ".tmp";
        File file = new File(string);
        File file2 = new File(string3);
        String string4 = "args=(\"$@\")\n";
        string4 = string4 + "db2 connect to ${args[0]} user ${args[1]} using ${args[2]}";
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            bufferedWriter = new BufferedWriter(new FileWriter(file2));
            if (!file.exists()) {
                return;
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.contains("/\"")) {
                    String string5 = "\\\\\"";
                    string2 = string2.replaceAll("/\"", string5);
                }
                bufferedWriter.append(string2 + '\n');
                if (!string2.contains("mkdir -p log")) continue;
                bufferedWriter.append(string4 + '\n');
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                    file.delete();
                    file2.renameTo(new File(string));
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String createDataFileName(String string, String string2) {
        return this.replaceBlankSpaceWithUnderscoreInFileName(string) + ".dat";
    }

    private String replaceBlankSpaceWithUnderscoreInFileName(String string) {
        String string2 = string.trim();
        String string3 = "\\.";
        String[] stringArray = string2.split(string3);
        String string4 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string4 = i < stringArray.length - 1 ? string4 + stringArray[i].trim() + "." : string4 + stringArray[i];
        }
        string2 = string4.length() > 0 ? string4 : string2;
        String string5 = "_";
        if (string2.contains(" ")) {
            string2 = string2.replaceAll(" ", string5);
        }
        return string2;
    }

    public Quoter getQuoter() {
        return new DB2Quoter();
    }
}

