/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.util.Iterator;
import oracle.ide.vhv.model.Branch;
import oracle.ide.vhv.model.ContextElement;
import oracle.ide.vhv.model.GraphElement;
import oracle.ide.vhv.model.SuccessorElement;
import oracle.ide.vhv.resource.VHVArb;
import oracle.ide.vhv.view.GraphShape;
import oracle.ide.vhv.view.VersionTreeDiagram;

public class SuccessorShape
extends GraphShape {
    private Ellipse2D m_shape;

    SuccessorShape(String label, Point location, int size, GraphShape parent, int connectionSide, GraphElement clientObject) {
        super(label, parent, connectionSide, clientObject);
        this.m_shape = new Ellipse2D.Double(location.x - size / 2, location.y - size / 2, size, size);
    }

    @Override
    public String getToolTipText() {
        String type = VHVArb.getString(69);
        try {
            if (((SuccessorElement)this.getGraphElement()).isMajor()) {
                type = VHVArb.getString(70);
            }
            if (((SuccessorElement)this.getGraphElement()).isTip()) {
                type = VHVArb.getString(71);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String versionLabel = null;
        try {
            versionLabel = ((ContextElement)this.getGraphElement()).getVersionableResource().getVersionLabel();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (((SuccessorElement)this.getGraphElement()).isInContext()) {
                if (versionLabel != null) {
                    return VHVArb.format(75, new String[]{versionLabel, ((ContextElement)this.getGraphElement()).getVersionableResource().getWorkareaName()});
                }
                return VHVArb.format(74, new String[]{((ContextElement)this.getGraphElement()).getVersionableResource().getWorkareaName()});
            }
            if (versionLabel != null) {
                return VHVArb.format(73, new String[]{type, versionLabel, this.getGraphElement().getUserResource().getName(), DateFormat.getDateTimeInstance().format(this.getGraphElement().getDatestamp())});
            }
            return VHVArb.format(72, new String[]{type, this.getGraphElement().getUserResource().getName(), DateFormat.getDateTimeInstance().format(this.getGraphElement().getDatestamp())});
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void paint(Graphics2D g, boolean paintText) {
        if (g.getClip().intersects(this.getBounds2D())) {
            double size;
            GeneralPath gp;
            Color c = VersionTreeDiagram.getDefaultNodeColor();
            SuccessorElement se = (SuccessorElement)this.getGraphElement();
            if (VersionTreeDiagram.getInContextNodeColor() != null && se.isInContext()) {
                c = VersionTreeDiagram.getInContextNodeColor();
            } else if (VersionTreeDiagram.getHidingChildrenNodeColor() != null && this.isHidingChildren()) {
                c = VersionTreeDiagram.getHidingChildrenNodeColor();
            } else if (VersionTreeDiagram.getLeafNodeColor() != null && se.isTip()) {
                c = VersionTreeDiagram.getLeafNodeColor();
            } else if (VersionTreeDiagram.getMajorNodeColor() != null && se.isMajor()) {
                c = VersionTreeDiagram.getMajorNodeColor();
            }
            g.setColor(c);
            g.fill(this.m_shape);
            g.setColor(Color.black);
            if (this.isSelected()) {
                g.setStroke(new BasicStroke(2.0f));
                gp = new GeneralPath();
                size = (this.m_shape.getMaxX() - this.m_shape.getMinX()) / 6.0;
                gp.moveTo((float)this.m_shape.getMinX(), (float)(this.m_shape.getMinY() + size));
                gp.lineTo((float)this.m_shape.getMinX(), (float)this.m_shape.getMinY());
                gp.lineTo((float)(this.m_shape.getMinX() + size), (float)this.m_shape.getMinY());
                gp.moveTo((float)this.m_shape.getMaxX(), (float)(this.m_shape.getMinY() + size));
                gp.lineTo((float)this.m_shape.getMaxX(), (float)this.m_shape.getMinY());
                gp.lineTo((float)(this.m_shape.getMaxX() - size), (float)this.m_shape.getMinY());
                gp.moveTo((float)this.m_shape.getMaxX(), (float)(this.m_shape.getMaxY() - size));
                gp.lineTo((float)this.m_shape.getMaxX(), (float)this.m_shape.getMaxY());
                gp.lineTo((float)(this.m_shape.getMaxX() - size), (float)this.m_shape.getMaxY());
                gp.moveTo((float)this.m_shape.getMinX(), (float)(this.m_shape.getMaxY() - size));
                gp.lineTo((float)this.m_shape.getMinX(), (float)this.m_shape.getMaxY());
                gp.lineTo((float)(this.m_shape.getMinX() + size), (float)this.m_shape.getMaxY());
                g.draw(gp);
                g.setStroke(new BasicStroke(1.0f));
            }
            if (se.isInContext()) {
                gp = new GeneralPath();
                size = this.getVisibleVersionArrowSize();
                gp.moveTo((float)this.m_shape.getMinX() - 2.0f, (float)this.m_shape.getCenterY());
                gp.lineTo((float)(this.m_shape.getMinX() - 2.0 - size), (float)(this.m_shape.getCenterY() - size));
                gp.lineTo((float)(this.m_shape.getMinX() - 2.0 - size), (float)(this.m_shape.getCenterY() - size));
                gp.lineTo((float)(this.m_shape.getMinX() - 2.0 - size), (float)(this.m_shape.getCenterY() - size / 2.0));
                gp.lineTo((float)(this.m_shape.getMinX() - 2.0 - 2.0 * size), (float)(this.m_shape.getCenterY() - size / 2.0));
                gp.lineTo((float)(this.m_shape.getMinX() - 2.0 - 2.0 * size), (float)(this.m_shape.getCenterY() + size / 2.0));
                gp.lineTo((float)(this.m_shape.getMinX() - 2.0 - size), (float)(this.m_shape.getCenterY() + size / 2.0));
                gp.lineTo((float)(this.m_shape.getMinX() - 2.0 - size), (float)(this.m_shape.getCenterY() + size));
                gp.closePath();
                g.setColor(c);
                g.fill(gp);
                g.setColor(Color.black);
                g.draw(gp);
            }
            if (this.isHighlighted()) {
                g.setStroke(new BasicStroke(3.0f));
            }
            g.draw(this.m_shape);
            g.setStroke(new BasicStroke(1.0f));
            if (paintText) {
                g.setFont(VersionTreeDiagram.getDisplayFont());
                Rectangle2D labelBounds = g.getFontMetrics().getStringBounds(this.getLabel(), g);
                int labelWidth = (int)Math.round(Math.ceil(labelBounds.getWidth()));
                int labelHeight = (int)Math.round(Math.floor(g.getFontMetrics().getLineMetrics(this.getLabel(), g).getAscent() - g.getFontMetrics().getLineMetrics(this.getLabel(), g).getLeading()));
                g.setFont(VersionTreeDiagram.getDisplayFont());
                if (SuccessorShape.isDarkColor(c)) {
                    g.setColor(Color.white);
                }
                int x = (int)Math.round(this.m_shape.getCenterX() - (double)(labelWidth / 2));
                int y = (int)Math.round(this.m_shape.getCenterY() + (double)(labelHeight / 2));
                g.drawString(this.getLabel(), x, y);
            }
        }
        if (this.getParentShape() != null) {
            g.setColor(Color.black);
            Point2D cp = this.getTopConnectionPoint();
            Point2D pcp = this.getConnectionPoint();
            Line2D.Double line = new Line2D.Double(cp, pcp);
            if (g.getClip().getBounds2D().intersectsLine(line)) {
                g.draw(line);
            }
        }
        if (this.isHidingChildren()) {
            this.paintStub(g);
        }
    }

    @Override
    public boolean contains(double x, double y) {
        return this.m_shape.contains(x, y);
    }

    @Override
    public void move(double dX, double dY) {
        this.m_shape.setFrame(this.m_shape.getX() + dX, this.m_shape.getY() + dY, this.m_shape.getWidth(), this.m_shape.getHeight());
    }

    @Override
    public Rectangle2D getBounds2D() {
        int border = 5;
        double minX = this.m_shape.getMinX() - (double)border;
        double minY = this.m_shape.getMinY() - (double)border;
        double maxX = this.m_shape.getMaxX() + (double)border;
        double maxY = this.m_shape.getMaxY() + (double)border;
        if (((SuccessorElement)this.getGraphElement()).isInContext()) {
            minX -= 2.0 + 2.0 * this.getVisibleVersionArrowSize();
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public Rectangle2D getTotalBounds2D() {
        Iterator i;
        Rectangle2D bounds = this.getBounds2D();
        SuccessorElement se = (SuccessorElement)this.getGraphElement();
        bounds.add(this.getConnectionPoint());
        if (se.getDisplayedChildElement() != null) {
            bounds.add(se.getDisplayedChildElement().getShape().getTopConnectionPoint());
        }
        if (se.getReservedCheckOut() != null) {
            bounds.add(se.getReservedCheckOut().getShape().getTopConnectionPoint());
        }
        if (se.getTargetMerges() != null) {
            i = se.getTargetMerges().iterator();
            while (i.hasNext()) {
                bounds.add(((GraphShape)((GraphElement)i.next()).getShape()).getBounds2D());
            }
        }
        if (se.getSourceMerges() != null) {
            i = se.getSourceMerges().iterator();
            while (i.hasNext()) {
                bounds.add(((GraphShape)((GraphElement)i.next()).getShape()).getBounds2D());
            }
        }
        if (se.getBranches() != null) {
            i = se.getBranches().iterator();
            while (i.hasNext()) {
                bounds.add(((Branch)i.next()).getBranchElement().getShape().getRightConnectionPoint());
            }
        }
        return bounds;
    }

    @Override
    public Shape getShape() {
        return this.m_shape;
    }

    @Override
    public Point2D getLocation() {
        return new Point2D.Double(this.m_shape.getCenterX(), this.m_shape.getCenterY());
    }

    @Override
    public Point2D getTopConnectionPoint() {
        return new Point2D.Double(this.m_shape.getCenterX(), this.m_shape.getMinY());
    }

    @Override
    public Point2D getBottomConnectionPoint() {
        return new Point2D.Double(this.m_shape.getCenterX(), this.m_shape.getMaxY());
    }

    @Override
    public Point2D getLeftConnectionPoint() {
        return new Point2D.Double(this.m_shape.getMinX(), this.m_shape.getCenterY());
    }

    @Override
    public Point2D getRightConnectionPoint() {
        return new Point2D.Double(this.m_shape.getMaxX(), this.m_shape.getCenterY());
    }

    @Override
    public int getScrollX() {
        return (int)Math.ceil(this.m_shape.getMaxX() + 32.0);
    }

    @Override
    public int getScrollY() {
        return (int)Math.ceil(this.m_shape.getMaxY() + 32.0);
    }

    private double getVisibleVersionArrowSize() {
        return (this.m_shape.getMaxX() - this.m_shape.getMinX()) / 3.0;
    }

    @Override
    public GraphShape getBelow() {
        SuccessorElement se = (SuccessorElement)this.getGraphElement();
        if (se.getReservedCheckOut() != null) {
            return (GraphShape)se.getReservedCheckOut().getShape();
        }
        if (se.getUnreservedCheckOuts() != null) {
            return (GraphShape)((GraphElement)se.getUnreservedCheckOuts().get(0)).getShape();
        }
        if (this.getGraphElement().getDisplayedChildElement() != null) {
            return (GraphShape)this.getGraphElement().getDisplayedChildElement().getShape();
        }
        return this;
    }

    @Override
    public GraphShape getRight() {
        SuccessorElement se = (SuccessorElement)this.getGraphElement();
        if (se.hasBranches()) {
            return (GraphShape)((Branch)se.getBranches().get(0)).getBranchElement().getShape();
        }
        return this;
    }

    @Override
    public GraphShape getLeft() {
        SuccessorElement se = (SuccessorElement)this.getGraphElement();
        if (se.hasBranches()) {
            Branch b = (Branch)se.getBranches().get(se.getBranches().size() - 1);
            return (GraphShape)b.getBranchElement().getShape();
        }
        return this;
    }
}

