/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.Collator;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import oracle.ide.vhv.VHVResourceException;
import oracle.ide.vhv.model.BranchElement;
import oracle.ide.vhv.model.CheckOutElement;
import oracle.ide.vhv.model.GraphElement;
import oracle.ide.vhv.model.INameHelper;
import oracle.ide.vhv.model.MergeElement;
import oracle.ide.vhv.model.MergeSource;
import oracle.ide.vhv.model.MergeTarget;
import oracle.ide.vhv.model.SuccessorElement;
import oracle.ide.vhv.resource.VHVArb;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.javatools.controls.nicetable.NiceTableModel;

public class VHVPropertiesPanel {
    private static VHVPropertiesPanel _instance;
    public static final String GUI_PROPERTIES = "properties";
    public static final String GUI_BLANK = "blank";
    private INameHelper _nameHelper;
    private GraphElement _currentGraphElement;
    private Component _gui;
    private JPanel _mainPanel;
    private PropertiesTable _propertiesTable;
    private JScrollPane _propertiesTableScrollPane;

    public static final VHVPropertiesPanel getInstance() {
        if (_instance == null) {
            _instance = new VHVPropertiesPanel();
        }
        return _instance;
    }

    public void setINameHelper(INameHelper nameHelper) {
        this._nameHelper = nameHelper;
    }

    public Component getGUI() {
        if (this._gui != null) {
            return this._gui;
        }
        this._propertiesTable = new PropertiesTable();
        this._propertiesTable.setBorder(null);
        this._propertiesTableScrollPane = new JScrollPane((Component)((Object)this._propertiesTable));
        PropertiesTableModel propertiesTableModel = new PropertiesTableModel();
        propertiesTableModel.addColumn(VHVArb.getString(94));
        propertiesTableModel.addColumn(VHVArb.getString(95));
        this._propertiesTable.setModel(propertiesTableModel);
        this._propertiesTable.setSorted(true);
        this._propertiesTable.getTableHeader().setReorderingAllowed(false);
        for (int i = 0; i < this._propertiesTable.getColumnCount(); ++i) {
            this._propertiesTable.getColumnModel().getColumn(i).setHeaderRenderer(this._propertiesTable.getTableHeader().getDefaultRenderer());
        }
        this._propertiesTable.setAutoResizeMode(4);
        this._propertiesTable.getColumn(VHVArb.getString(95)).setCellRenderer((TableCellRenderer)((Object)new StringCellRenderer()));
        this._mainPanel = new JPanel(new BorderLayout());
        this._mainPanel.add((Component)this._propertiesTableScrollPane, "Center");
        this._gui = this._mainPanel;
        return this._gui;
    }

    void setGraphElement(GraphElement graphElement) {
        if (this._nameHelper == null) {
            return;
        }
        if (this._currentGraphElement == graphElement) {
            return;
        }
        this.getGUI();
        this._currentGraphElement = graphElement;
        if (this._currentGraphElement == null) {
            this._propertiesTable.installModel(new HashMap<String, String>());
        } else {
            this.updateProperties(graphElement);
        }
        this._mainPanel.revalidate();
        this._mainPanel.repaint();
    }

    private void updateProperties(GraphElement graphElement) {
        String comments;
        String author;
        Date date;
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        if (graphElement instanceof MergeElement) {
            try {
                String name = graphElement.getResource().getName();
                if (name != null) {
                    properties.put(VHVArb.getString(104), name);
                }
            }
            catch (VHVResourceException vhvre) {
                vhvre.printStackTrace();
            }
        }
        if (graphElement instanceof BranchElement) {
            properties.put(VHVArb.getString(96), graphElement.getDisplayName(this._nameHelper));
        }
        if (graphElement instanceof MergeElement) {
            properties.put(VHVArb.getString(97), ((MergeSource)((Object)graphElement.getParentElement())).getDisplayVersion(this._nameHelper));
            properties.put(VHVArb.getString(98), ((MergeTarget)((Object)graphElement.getChildElement())).getDisplayVersion(this._nameHelper));
        }
        String version = null;
        if (graphElement instanceof CheckOutElement) {
            version = ((CheckOutElement)graphElement).getDisplayVersion(this._nameHelper);
        }
        if (graphElement instanceof SuccessorElement) {
            version = ((SuccessorElement)graphElement).getDisplayVersion(this._nameHelper);
        }
        if (version != null) {
            properties.put(VHVArb.getString(99), version);
        }
        if ((date = graphElement.getDatestamp()) != null) {
            properties.put(VHVArb.getString(100), DateFormat.getDateTimeInstance().format(date));
        }
        if ((author = this._nameHelper.getUserName(graphElement)) != null) {
            properties.put(VHVArb.getString(101), author);
        }
        String status = null;
        if (graphElement instanceof BranchElement) {
            status = ((BranchElement)graphElement).isFrozen() ? VHVArb.getString(79) : (((BranchElement)graphElement).isLocked() ? VHVArb.getString(80) : (((BranchElement)graphElement).isObsolete() ? VHVArb.getString(82) : (((BranchElement)graphElement).isPrivate() ? VHVArb.getString(83) : VHVArb.getString(81))));
        }
        if (graphElement instanceof CheckOutElement) {
            status = ((CheckOutElement)graphElement).isReservedCheckOut() ? VHVArb.getString(77) : VHVArb.getString(78);
        }
        if (graphElement instanceof MergeElement) {
            status = ((MergeElement)graphElement).isSystemMerge() ? VHVArb.getString(85) : VHVArb.getString(84);
        }
        if (graphElement instanceof SuccessorElement) {
            status = VHVArb.getString(76);
        }
        if (status != null) {
            properties.put(VHVArb.getString(102), status);
        }
        if ((comments = graphElement.getNotes()) != null && !comments.trim().equals("")) {
            properties.put(VHVArb.getString(103), comments.trim());
        }
        try {
            Map<String, String> properties0 = graphElement.getResource().getProperties();
            if (properties0 != null) {
                properties.putAll(properties0);
            }
        }
        catch (VHVResourceException vhvre) {
            vhvre.printStackTrace();
        }
        this._propertiesTable.installModel(properties);
    }

    private class PropertiesTableModel
    extends DefaultTableModel
    implements NiceTableModel {
        private PropertiesTableModel() {
        }

        public int getColumnAlignment(int column) {
            return 2;
        }

        public Comparator getColumnSortComparator(int column) {
            return Collator.getInstance();
        }
    }

    private class PropertiesTable
    extends NiceTable {
        private PropertiesTable() {
            this.setSelectionMode(0);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void installModel(Map<String, String> properties) {
            DefaultTableModel model = (DefaultTableModel)this.getBaseModel();
            model.setNumRows(0);
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                model.addRow(new Object[]{entry.getKey(), entry.getValue()});
            }
            ((DefaultTableModel)this.getBaseModel()).fireTableDataChanged();
            this.setSortColumn(this.getSortColumn(), this.isSortAscending());
            if (model.getRowCount() > 0) {
                this.setSelectedRow(0);
            }
        }

        private void setSelectedRow(int i) {
            if (i < 0 || i >= this.getRowCount()) {
                return;
            }
            this.setRowSelectionInterval(i, i);
            this.scrollToSelection();
        }

        public String getToolTipText(MouseEvent event) {
            if (!this.isShowToolTips()) {
                return super.getToolTipText(event);
            }
            Point mousePos = event.getPoint();
            int column = this.columnAtPoint(mousePos);
            int row = this.rowAtPoint(mousePos);
            if (column == -1 || row == -1) {
                return super.getToolTipText(event);
            }
            int modelColumn = this.convertColumnIndexToModel(column);
            Object o = this.getModel().getValueAt(row, modelColumn);
            if (o == null) {
                return super.getToolTipText(event);
            }
            if (o instanceof String && o.toString().trim().indexOf(10) >= 0) {
                StringBuffer htmlBuffer = new StringBuffer();
                BufferedReader br = new BufferedReader(new StringReader(o.toString()));
                try {
                    String s;
                    while ((s = br.readLine()) != null) {
                        if (htmlBuffer.length() > 0) {
                            htmlBuffer.append("<br>");
                        }
                        htmlBuffer.append(s);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                htmlBuffer.append("</html>");
                htmlBuffer.insert(0, "<html>");
                return htmlBuffer.toString();
            }
            return super.getToolTipText(event);
        }
    }

    private class StringCellRenderer
    extends NiceTableCellRenderer {
        private StringCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof String) {
                value = this.formatStringForRendering(value.toString());
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        private String formatStringForRendering(String s) {
            if (s.indexOf(10) < 0 && s.indexOf(13) < 0 && s.indexOf(12) < 0) {
                return s;
            }
            s = s.trim();
            StringBuffer singleLineMesageBuffer = new StringBuffer();
            BufferedReader br = new BufferedReader(new StringReader(s));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    if (singleLineMesageBuffer.length() > 0) {
                        singleLineMesageBuffer.append("\\ ");
                    }
                    singleLineMesageBuffer.append(line.trim());
                }
                return singleLineMesageBuffer.toString();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return s;
            }
        }
    }
}

