/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.javadoc.util;

import java.util.StringTokenizer;

public final class URLUtils {
    private URLUtils() {
    }

    public static String createRelativePathToRoot(String relativeName) {
        StringBuffer sb = new StringBuffer();
        int n = new StringTokenizer(relativeName, "/").countTokens() - 1;
        for (int i = 0; i < n; ++i) {
            sb.append("../");
        }
        String pathToRoot = sb.toString();
        return pathToRoot;
    }

    public static String appendSuffix(String path, String extension) {
        int hashIndex = URLUtils.hashNMarkIndex(path);
        if (hashIndex != -1) {
            return path.substring(0, hashIndex) + extension + path.substring(hashIndex, path.length());
        }
        return path + extension;
    }

    private static int hashNMarkIndex(String path) {
        int hashIndex = path.indexOf(35);
        int questionIndex = path.indexOf(63);
        if (hashIndex != -1) {
            if (questionIndex != -1) {
                return Math.min(hashIndex, questionIndex);
            }
            return hashIndex;
        }
        if (questionIndex != -1) {
            return questionIndex;
        }
        return -1;
    }
}

