/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.javadoc.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bm.util.ResourcePicker;
import oracle.diagram.javadoc.DiagramJavaDocOptions;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;

public final class DiagramJavaDocConfigPanel
extends ProjectSettingsTraversablePanel {
    GridBagLayout gbLayout = new GridBagLayout();
    JCheckBox chkGenDiagramDoc = new JCheckBox();
    JComboBox cmbImageFormat = new JComboBox();
    JComboBox cmbEmbedDiagrams = new JComboBox();
    JLabel lblImageFormat = new JLabel();
    JLabel lblEmbedDiagrams = new JLabel();
    JPanel pnlGenerate = new JPanel();
    ResourcePicker m_resource = new ResourcePicker(ResourceBundle.getBundle("oracle.diagram.javadoc.res.JavaDocResource"));
    private static final String[] PROPERTY_KEYS = new String[]{"genDiagramDoc", "embedDiagram", "imageFormat"};
    private static final PropertyHolder[] IMAGE_FORMAT_OPTIONS = new PropertyHolder[]{new PropertyHolder(0), new PropertyHolder(1), new PropertyHolder(2), new PropertyHolder(3)};
    private static final PropertyHolder[] EMBED_DIAGRAM_OPTIONS = new PropertyHolder[]{new PropertyHolder(5), new PropertyHolder(4)};

    public DiagramJavaDocConfigPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resButton((AbstractButton)this.chkGenDiagramDoc, (String)this.m_resource.getStringResource("DocumentDiagram", "text"));
        ResourceUtils.resLabel((JLabel)this.lblImageFormat, (Component)this.cmbImageFormat, (String)this.m_resource.getStringResource("ImageFormat", "text"));
        ResourceUtils.resLabel((JLabel)this.lblEmbedDiagrams, (Component)this.cmbEmbedDiagrams, (String)this.m_resource.getStringResource("IntegrateDiagrams", "text"));
        this.chkGenDiagramDoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enable = DiagramJavaDocConfigPanel.this.chkGenDiagramDoc.isSelected();
                DiagramJavaDocConfigPanel.this.lblImageFormat.setEnabled(enable);
                DiagramJavaDocConfigPanel.this.cmbImageFormat.setEnabled(enable);
                DiagramJavaDocConfigPanel.this.lblEmbedDiagrams.setEnabled(enable);
                DiagramJavaDocConfigPanel.this.cmbEmbedDiagrams.setEnabled(enable);
            }
        });
        this.pnlGenerate.setLayout(this.gbLayout);
        this.pnlGenerate.add((Component)this.chkGenDiagramDoc, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 4, 0), 0, 0));
        this.pnlGenerate.add((Component)this.lblImageFormat, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 4, 8), 0, 0));
        this.pnlGenerate.add((Component)this.lblEmbedDiagrams, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 4, 8), 0, 0));
        this.pnlGenerate.add((Component)this.cmbImageFormat, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 4, 0), 10, 0));
        this.pnlGenerate.add((Component)this.cmbEmbedDiagrams, new GridBagConstraints(1, -1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 10, 0));
        this.setLayout(this.gbLayout);
        this.add(this.pnlGenerate, new GridBagConstraints(2, -1, 2, 1, 1.0, 1.0, 18, 2, new Insets(8, 0, 8, 0), 0, 0));
    }

    public String getDataKey() {
        return DiagramJavaDocOptions.DATA_KEY;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        boolean isUserProperties = DiagramJavaDocConfigPanel.editingUserProperties((Namespace)tc);
        boolean isDefaultProject = DiagramJavaDocConfigPanel.isDefaultProject((Namespace)tc);
        if (isDefaultProject) {
            this.setHelpID("f1_idedprojsetjavadocdiagdpp_html");
        } else {
            this.setHelpID("f1_idedprojsetjavadocdiag_html");
        }
        DiagramJavaDocOptions javadocSettings = DiagramJavaDocConfigPanel.getDiagramJavadocOptions(tc);
        this.loadFrom(javadocSettings, isDefaultProject, isUserProperties);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        boolean isDefaultProject = DiagramJavaDocConfigPanel.isDefaultProject((Namespace)tc);
        boolean isUserProperties = DiagramJavaDocConfigPanel.editingUserProperties((Namespace)tc);
        DiagramJavaDocOptions doc = DiagramJavaDocConfigPanel.getDiagramJavadocOptions(tc);
        this.commitTo(doc, isDefaultProject, isUserProperties);
    }

    private static DiagramJavaDocOptions getDiagramJavadocOptions(TraversableContext tc) {
        PropertyStorage propertyData = DiagramJavaDocConfigPanel.getPropertyData((Namespace)tc);
        return DiagramJavaDocOptions.getInstance(propertyData);
    }

    private void loadFrom(DiagramJavaDocOptions doc, boolean isDefaultProject, boolean editingUserData) {
        boolean genDiagramDoc = doc.isGenDiagramDoc();
        this.chkGenDiagramDoc.setSelected(genDiagramDoc);
        this.lblImageFormat.setEnabled(genDiagramDoc);
        this.cmbImageFormat.setEnabled(genDiagramDoc);
        this.lblEmbedDiagrams.setEnabled(genDiagramDoc);
        this.cmbEmbedDiagrams.setEnabled(genDiagramDoc);
        this.cmbImageFormat.setEnabled(genDiagramDoc);
        this.cmbEmbedDiagrams.setEnabled(genDiagramDoc);
        NonNullableComboBoxModel imgModel = new NonNullableComboBoxModel((Object[])IMAGE_FORMAT_OPTIONS);
        this.cmbImageFormat.setModel(imgModel);
        int imageOption = doc.getImageFormat();
        for (int i = 0; i < IMAGE_FORMAT_OPTIONS.length; ++i) {
            if (IMAGE_FORMAT_OPTIONS[i].getId() != imageOption) continue;
            this.cmbImageFormat.setSelectedItem(IMAGE_FORMAT_OPTIONS[i]);
            break;
        }
        NonNullableComboBoxModel embedModel = new NonNullableComboBoxModel((Object[])EMBED_DIAGRAM_OPTIONS);
        this.cmbEmbedDiagrams.setModel(embedModel);
        int embedOption = doc.getEmbedDiagram();
        for (int i = 0; i < EMBED_DIAGRAM_OPTIONS.length; ++i) {
            if (EMBED_DIAGRAM_OPTIONS[i].getId() != embedOption) continue;
            this.cmbEmbedDiagrams.setSelectedItem(EMBED_DIAGRAM_OPTIONS[i]);
            break;
        }
    }

    private void commitTo(DiagramJavaDocOptions doc, boolean isDefaultProject, boolean userData) throws TraversalException {
        doc.setGenDiagramDoc(this.chkGenDiagramDoc.isSelected());
        PropertyHolder embedProperty = (PropertyHolder)this.cmbEmbedDiagrams.getSelectedItem();
        doc.setEmbedDiagram(embedProperty.getId());
        PropertyHolder imageProperty = (PropertyHolder)this.cmbImageFormat.getSelectedItem();
        doc.setImageFormat(imageProperty.getId());
    }

    private static class PropertyHolder {
        int id;
        String name;

        public PropertyHolder(int id) {
            this.id = id;
            ResourcePicker resource = new ResourcePicker(ResourceBundle.getBundle("oracle.diagram.javadoc.res.JavaDocResource"));
            switch (id) {
                case 0: {
                    this.name = "JPEG";
                    break;
                }
                case 1: {
                    this.name = "PNG";
                    break;
                }
                case 2: {
                    this.name = "SVG";
                    break;
                }
                case 3: {
                    this.name = "SVGZ";
                    break;
                }
                case 5: {
                    this.name = resource.getStringResource("EmbedInLine", "text");
                    break;
                }
                case 4: {
                    this.name = resource.getStringResource("EmbedInFrame", "text");
                    break;
                }
                default: {
                    this.name = "";
                }
            }
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return this.name;
        }
    }
}

