/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.javadoc.addin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import oracle.diagram.javadoc.DiagramJavaDocGenerator;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.panels.Navigable;
import oracle.javatools.data.HashStructure;

public final class DiagramJavaDocHook
extends HashStructureHook {
    public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "diagram-javadoc");
    private static String GENERATOR_TAG = "generator";
    private static String CLASS_TAG = "class";
    private static String NAVIGABLE_TAG = "navigable";
    private static String TRAVERSABLE_TAG = "traversable-class";
    private static String LABEL_TAG = "title";

    private DiagramJavaDocHook() {
    }

    static DiagramJavaDocHook getHook() {
        return (DiagramJavaDocHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT);
    }

    public Collection<Navigable> getNavigables() {
        List navigables = this.getHashStructure().getAsList(NAVIGABLE_TAG);
        if (navigables == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Navigable> result = new ArrayList<Navigable>(navigables.size());
        for (Object n : navigables) {
            Navigable navigable;
            MetaClass mc;
            HashStructure hs = (HashStructure)n;
            String navigableClass = hs.getString(CLASS_TAG);
            String traversableClass = hs.getString(TRAVERSABLE_TAG);
            String label = hs.getString(LABEL_TAG, "<no-label>");
            if (navigableClass == null && traversableClass == null) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Must supply one of class or traversable-class");
                continue;
            }
            if (navigableClass != null && traversableClass != null) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Must supply only one of class or traversable-class");
                continue;
            }
            if (navigableClass != null) {
                mc = LazyClassAdapter.getInstance((HashStructure)hs).getMetaClass(CLASS_TAG);
                if (mc == null) continue;
                try {
                    navigable = (Navigable)mc.newInstance();
                    result.add(navigable);
                }
                catch (InstantiationException ex) {
                    ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Unable to instantiate: " + mc.getClassName() + " due to: " + ex.getMessage());
                }
                catch (IllegalAccessException ex) {
                    ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Unable to instantiate: " + mc.getClassName() + " due to: " + ex.getMessage());
                }
                catch (ClassNotFoundException ex) {
                    ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Unable to instantiate: " + mc.getClassName() + " due to: " + ex.getMessage());
                }
                continue;
            }
            if (traversableClass == null) continue;
            mc = LazyClassAdapter.getInstance((HashStructure)hs).getMetaClass(TRAVERSABLE_TAG);
            try {
                navigable = new Navigable(label, mc.toClass());
                result.add(navigable);
            }
            catch (ClassNotFoundException ex) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Unable to instantiate: " + mc.getClassName() + " due to: " + ex.getMessage());
            }
        }
        Collections.sort(result, new Comparator<Navigable>(){

            @Override
            public int compare(Navigable o1, Navigable o2) {
                return o1.getShortLabel().compareTo(o2.getShortLabel());
            }
        });
        return result;
    }

    public Collection<DiagramJavaDocGenerator> getGenerators() {
        List generators = this.getHashStructure().getAsList(GENERATOR_TAG);
        if (generators == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DiagramJavaDocGenerator> result = new ArrayList<DiagramJavaDocGenerator>(generators.size());
        for (Object p : generators) {
            HashStructure hs = (HashStructure)p;
            MetaClass mc = LazyClassAdapter.getInstance((HashStructure)hs).getMetaClass(CLASS_TAG);
            if (mc == null) continue;
            try {
                DiagramJavaDocGenerator generator = (DiagramJavaDocGenerator)mc.newInstance();
                result.add(generator);
            }
            catch (InstantiationException ex) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Unable to instantiate: " + mc.getClassName() + " due to: " + ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Unable to instantiate: " + mc.getClassName() + " due to: " + ex.getMessage());
            }
            catch (ClassNotFoundException ex) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Unable to instantiate: " + mc.getClassName() + " due to: " + ex.getMessage());
            }
        }
        return result;
    }
}

