/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.javadoc.addin;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import oracle.bm.javatools.util.MultivaluedMap;
import oracle.diagram.javadoc.ContentItem;
import oracle.diagram.javadoc.DiagramJavaDocGenerator;
import oracle.diagram.javadoc.DiagramJavaDocOptions;
import oracle.diagram.javadoc.GenerationContext;
import oracle.diagram.javadoc.util.HTMLFragments;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Encodings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.BundleLoader;
import oracle.jdeveloper.javadoc.JProjectJavadoc;
import oracle.jdeveloper.javadoc.gen.JDGenHelper;

public final class DiagramJavaDocEngine
implements JDGenHelper {
    private final Context _context;
    private final JProjectJavadoc _coreOptions;
    private final PrintWriter _logWriter;
    private final Collection<DiagramJavaDocGenerator> _generators;
    private URLFilter _ignore = GlobalIgnoreList.getURLFilter();
    private final ResourceBundle _rb;
    private final HTMLFragments _htmlFragments;

    public DiagramJavaDocEngine(Context context, JProjectJavadoc coreOptions, PrintWriter logWriter, Collection<DiagramJavaDocGenerator> generators) {
        this._context = context;
        this._coreOptions = coreOptions;
        this._logWriter = logWriter;
        this._generators = generators;
        this._rb = BundleLoader.getBundle((String)"oracle.diagram.javadoc.res.JavaDocResource");
        this._htmlFragments = new HTMLFragments();
    }

    public void generationStarting() {
    }

    public void generationComplete() {
        String resourceToCopy;
        EnvironOptions environOptions = EnvironOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        String encoding = environOptions.getEncoding();
        String rawEncoding = encoding != null ? encoding : System.getProperty("file.encoding");
        String encodingType = Encodings.convertJdk2IanaEncoding((String)rawEncoding);
        Project project = this._context.getProject();
        HashStructure hs = project.getProperties().getOrCreateHashStructure(JProjectJavadoc.DATA_KEY);
        DiagramJavaDocOptions options = new DiagramJavaDocOptions(hs);
        if (!options.isGenDiagramDoc()) {
            return;
        }
        GenerationContext gc = new GenerationContext(this._context, this._coreOptions, this._logWriter, encodingType, options, this._htmlFragments, Collections.EMPTY_LIST);
        MultivaluedMap results = new MultivaluedMap(HashMap.class, HashSet.class);
        for (DiagramJavaDocGenerator generator : this._generators) {
            GenerationContext tmpGC;
            Collection<ContentItem> content;
            final ArrayList<Editor> openEditors = new ArrayList<Editor>();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        openEditors.addAll(EditorManager.getEditorManager().getAllEditors());
                    }
                });
            }
            catch (InterruptedException ex) {
            }
            catch (InvocationTargetException ex) {
                // empty catch block
            }
            if ((content = generator.generate(tmpGC = new GenerationContext(this._context, this._coreOptions, this._logWriter, encodingType, options, this._htmlFragments, openEditors))) == null) continue;
            for (ContentItem item : content) {
                results.put((Object)item.getSection(), (Object)item);
            }
        }
        if (results.isEmpty()) {
            return;
        }
        URL javadocRoot = gc.getOutputDirectory();
        boolean anyJavaDoc = true;
        if (URLFileSystem.exists((URL)URLFactory.newURL((URL)javadocRoot, (String)"overview-frame.html"))) {
            resourceToCopy = "index-npackage.html";
        } else if (URLFileSystem.exists((URL)URLFactory.newURL((URL)javadocRoot, (String)"allclasses-noframe.html"))) {
            resourceToCopy = "index-1package.html";
        } else {
            resourceToCopy = "index-0package.html";
            anyJavaDoc = false;
        }
        if (anyJavaDoc || !results.isEmpty() || URLFileSystem.exists((URL)URLFactory.newURL((URL)javadocRoot, (String)"alldiagrams-frame.html")) || URLFileSystem.exists((URL)URLFactory.newURL((URL)javadocRoot, (String)"index.html"))) {
            try {
                this.publishContentsList(gc, (MultivaluedMap<String, ContentItem>)results, javadocRoot);
                this.publishIndexDotHtml(gc, javadocRoot, resourceToCopy);
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
            this.publishStyleSheet(gc, anyJavaDoc, javadocRoot);
        }
    }

    public void generationDisposed() {
    }

    public void generationCanceled() {
    }

    public boolean waitForFinish() {
        return true;
    }

    protected final boolean isEmbedInline(GenerationContext gc) {
        return gc.getDiagramOptions().getEmbedDiagram() == 5;
    }

    private void publishIndexDotHtml(GenerationContext gc, URL javadocRoot, String resourceToCopy) throws Exception {
        String resourceDirectory = this.isEmbedInline(gc) ? "embed" : "framed";
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        URL extensionUserHome = er.getSystemDirectory("oracle.diagram.javadoc");
        URL templatesURL = URLFactory.newDirURL((URL)extensionUserHome, (String)"templates/javadoc");
        URL resourceURL = URLFactory.newDirURL((URL)templatesURL, (String)resourceDirectory);
        URL sourceURL = URLFactory.newDirURL((URL)resourceURL, (String)resourceToCopy);
        URL targetURL = URLFactory.newURL((URL)javadocRoot, (String)"index.html");
        boolean exists = URLFileSystem.exists((URL)targetURL);
        if (exists) {
            this.logUpdatingFile(gc.getLogWriter(), targetURL);
        } else {
            this.logGeneratingFile(gc.getLogWriter(), targetURL);
        }
        URLFileSystem.copy((URL)sourceURL, (URL)targetURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishStyleSheet(GenerationContext gc, boolean anyJavaDoc, URL javadocRoot) {
        URL javaDocRootStyleSheet = URLFactory.newURL((URL)javadocRoot, (String)"stylesheet.css");
        if (!anyJavaDoc) {
            try {
                String miscOptions = gc.getJavaDocOptions().getMiscOptions();
                StringTokenizer st = new StringTokenizer(miscOptions);
                String stylesheetPath = null;
                while (st.hasMoreTokens()) {
                    String nextToken = st.nextToken();
                    if (!nextToken.equals("-stylesheetfile") || !st.hasMoreTokens()) continue;
                    stylesheetPath = st.nextToken();
                }
                URL stylesheetURL = null;
                if (stylesheetPath != null) {
                    stylesheetURL = URLFactory.newURL(stylesheetPath);
                }
                if (stylesheetURL == null || !URLFileSystem.exists((URL)stylesheetURL)) {
                    stylesheetURL = this.getClass().getResource("/oracle/diagram/javadoc/res/javadoc-stylesheet.css");
                }
                boolean exists = URLFileSystem.exists((URL)javaDocRootStyleSheet);
                URLFileSystem.copy((URL)stylesheetURL, (URL)javaDocRootStyleSheet);
                if (exists) {
                    this.logUpdatingFile(gc.getLogWriter(), javaDocRootStyleSheet);
                } else {
                    this.logGeneratingFile(gc.getLogWriter(), javaDocRootStyleSheet);
                }
            }
            catch (Exception ex) {
                FeedbackManager.reportException((Throwable)ex);
            }
        }
        try {
            File javaDocRootStyleSheetFile = new File(javaDocRootStyleSheet.getPath());
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(javaDocRootStyleSheetFile, true));
            InputStream is = this.getClass().getResourceAsStream("/oracle/diagram/javadoc/res/extensions-stylesheet.css");
            try {
                int count;
                byte[] buffer = new byte[255];
                while ((count = is.read(buffer)) > -1) {
                    ((OutputStream)os).write(buffer, 0, count);
                }
            }
            catch (Throwable t) {
            }
            finally {
                ((OutputStream)os).close();
                if (is != null) {
                    is.close();
                }
            }
            this.logUpdatingFile(gc.getLogWriter(), javaDocRootStyleSheet);
        }
        catch (Exception ex) {
            FeedbackManager.reportException((Throwable)ex);
        }
    }

    private void publishContentsList(GenerationContext gc, MultivaluedMap<String, ContentItem> results, URL javadocRoot) throws Exception {
        URL contentsURL = URLFactory.newURL((URL)javadocRoot, (String)"alldiagrams-frame.html");
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(URLFileSystem.openOutputStream((URL)contentsURL), gc.getEncodingType())));
        this.logGeneratingFile(gc.getLogWriter(), contentsURL);
        pw.println(this._htmlFragments.getHeaderBlock(this._rb.getString("MainTitle.text"), "", gc.getEncodingType()));
        for (String section : results.keySet()) {
            this.traceOutSection(pw, results.get((Object)section), section, !this.isEmbedInline(gc) ? "diagramFrame" : "classFrame");
        }
        pw.println(this._htmlFragments.getFooterBlock());
        pw.flush();
        pw.close();
    }

    private void traceOutSection(PrintWriter pw, Collection<ContentItem> items, String sectionKey, String target) {
        pw.println(this._htmlFragments.getAllContentPrologue(sectionKey));
        HashMap<String, HashMap<String, String>> packageMap = new HashMap<String, HashMap<String, String>>();
        for (ContentItem item : items) {
            String name = item.getName();
            String relative = item.getRelativeURL();
            StringBuffer sb = new StringBuffer();
            sb.append("<a href=\"");
            sb.append(relative);
            sb.append("\" TARGET=\"");
            sb.append(target);
            sb.append("\">");
            sb.append(name);
            sb.append("</a>");
            sb.append("<br />");
            String packageName = item.getPackageName();
            HashMap<String, String> packageContents = (HashMap<String, String>)packageMap.get(packageName);
            if (packageContents == null) {
                packageContents = new HashMap<String, String>();
                packageMap.put(packageName, packageContents);
            }
            packageContents.put(name, sb.toString());
        }
        ArrayList sortedPackageList = new ArrayList(packageMap.keySet());
        Collections.sort(sortedPackageList);
        for (String packageName : sortedPackageList) {
            if (sortedPackageList.size() > 1) {
                StringBuffer sb = new StringBuffer();
                sb.append("<font size='-2'>");
                sb.append(packageName);
                sb.append("</font>");
                sb.append("<br />");
                pw.println(sb);
            }
            Map nameMap = (Map)packageMap.get(packageName);
            ArrayList sortedNameList = new ArrayList(nameMap.keySet());
            Collections.sort(sortedNameList);
            for (String name : sortedNameList) {
                pw.println((String)nameMap.get(name));
            }
        }
        pw.println(this._htmlFragments.getAllContentEpilogue());
    }

    protected void logGeneratingFile(PrintWriter printWriter, URL url) {
        printWriter.println(MessageFormat.format(this._rb.getString("Generating.text"), URLFileSystem.getPlatformPathName((URL)url)));
    }

    protected void logUpdatingFile(PrintWriter printWriter, URL url) {
        printWriter.println(MessageFormat.format(this._rb.getString("Updating.text"), URLFileSystem.getPlatformPathName((URL)url)));
    }
}

