/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.javadoc;

import java.io.PrintWriter;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import oracle.diagram.javadoc.DiagramJavaDocOptions;
import oracle.diagram.javadoc.util.HTMLFragments;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.javadoc.JProjectJavadoc;

public final class GenerationContext {
    private final Context _context;
    private final JProjectJavadoc _coreOptions;
    private final PrintWriter _logWriter;
    private final String _encodingType;
    private final DiagramJavaDocOptions _diagramOptions;
    private final Collection<Editor> _openEditors;
    private final HTMLFragments _fragments;

    public GenerationContext(Context context, JProjectJavadoc coreOptions, PrintWriter logWriter, String encodingType, DiagramJavaDocOptions diagramOptions, HTMLFragments fragments, Collection<Editor> openEditors) {
        this._context = context;
        this._coreOptions = coreOptions;
        this._logWriter = logWriter;
        this._encodingType = encodingType;
        this._diagramOptions = diagramOptions;
        this._fragments = fragments;
        this._openEditors = Collections.unmodifiableCollection(openEditors);
    }

    public final Context getContext() {
        return this._context;
    }

    public final JProjectJavadoc getJavaDocOptions() {
        return this._coreOptions;
    }

    public final PrintWriter getLogWriter() {
        return this._logWriter;
    }

    public final String getEncodingType() {
        return this._encodingType;
    }

    public final DiagramJavaDocOptions getDiagramOptions() {
        return this._diagramOptions;
    }

    public final String getImageSuffix() {
        switch (this._diagramOptions.getImageFormat()) {
            case 0: {
                return ".jpg";
            }
            case 1: {
                return ".png";
            }
            case 2: {
                return ".svg";
            }
            case 3: {
                return ".svgz";
            }
        }
        return ".svg";
    }

    public final URL getOutputDirectory() {
        Project project = this.getContext().getProject();
        URL javadocRoot = this.getJavaDocOptions().getOutputDirectory();
        if (javadocRoot == null) {
            URL dir = URLFileSystem.getParent((URL)project.getURL());
            javadocRoot = URLFactory.newDirURL((URL)dir, (String)"javadoc");
        }
        return javadocRoot;
    }

    public final boolean wasStandardJavaDocGenerated() {
        URL root = this.getOutputDirectory();
        if (URLFileSystem.exists((URL)URLFactory.newURL((URL)root, (String)"overview-frame.html"))) {
            return true;
        }
        return URLFileSystem.exists((URL)URLFactory.newURL((URL)root, (String)"allclasses-noframe.html"));
    }

    public final boolean wasEditorAlreadyOpen(Editor editor) {
        return this._openEditors.contains(editor);
    }

    public final Collection<Editor> getOpenedEditors() {
        return this._openEditors;
    }

    public final HTMLFragments getFragments() {
        return this._fragments;
    }
}

