/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.javadoc;

import java.io.PrintWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.ResourceBundle;
import oracle.diagram.javadoc.ContentItem;
import oracle.diagram.javadoc.DiagramJavaDocGenerator;
import oracle.diagram.javadoc.GenerationContext;
import oracle.diagram.javadoc.util.URLUtils;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryElement;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.BundleLoader;

public abstract class AbstractDiagramJavaDocGenerator
implements DiagramJavaDocGenerator {
    protected static final ResourceBundle RESOURCES = BundleLoader.getBundle((String)"oracle.diagram.javadoc.res.JavaDocResource");

    @Override
    public Collection<ContentItem> generate(GenerationContext context) {
        String relPath = this.getRelativePath(context);
        ArrayList<ContentItem> allResults = new ArrayList<ContentItem>(256);
        Collection<ContentSet> contentSets = this.getContentSets(context);
        if (contentSets != null) {
            for (ContentSet s : contentSets) {
                Collection<ContentItem> results = this.generateContentSet(context, s, relPath);
                if (results == null || results.isEmpty()) continue;
                allResults.addAll(results);
            }
        }
        return allResults;
    }

    protected Collection<ContentSet> getContentSets(GenerationContext gc) {
        ArrayList<ContentSet> results = new ArrayList<ContentSet>();
        ListStructure contentSets = gc.getContext().getProject().getProperties().getOrCreateListStructure("contentSets");
        for (Object value : contentSets) {
            if (!(value instanceof String)) continue;
            HashStructure contentSetHash = gc.getContext().getProject().getProperties().getOrCreateHashStructure((String)value);
            ContentSet contentSet = new ContentSet(contentSetHash);
            results.add(contentSet);
        }
        return results;
    }

    protected String getRelativePath(GenerationContext context) {
        String relPath = null;
        Element selection = context.getContext().getElement();
        if (selection != null && !(selection instanceof Project)) {
            if (selection instanceof RelativeDirectoryElement) {
                relPath = ((RelativeDirectoryElement)selection).getRelativePath();
            } else if (selection instanceof Node) {
                URL nodeURL = ((Node)selection).getURL();
                relPath = URLFileSystem.toRelativeSpec((URL)nodeURL, (URL)context.getContext().getProject().getURL(), (boolean)true);
            }
        }
        return relPath;
    }

    protected Collection<ContentItem> generateContentSet(GenerationContext context, ContentSet contentSet, String relPath) {
        ArrayList<ContentItem> allResults = new ArrayList<ContentItem>();
        Iterator i = contentSet.urlIterator(relPath);
        while (i.hasNext()) {
            URL url = (URL)i.next();
            if (!this.isRecognizedURL(context, contentSet, relPath, url)) continue;
            try {
                Collection<ContentItem> result = this.generateContentSetURL(context, contentSet, relPath, url);
                if (result == null || result.isEmpty()) continue;
                allResults.addAll(result);
            }
            catch (Exception ex) {
                ex.printStackTrace(context.getLogWriter());
            }
        }
        return allResults;
    }

    protected Collection<ContentItem> generateContentSetURL(GenerationContext context, ContentSet contentSet, String relPath, URL url) throws Exception {
        context.getLogWriter().println(MessageFormat.format(RESOURCES.getString("Generating.text"), URLFileSystem.getPlatformPathName((URL)url)));
        return Collections.EMPTY_LIST;
    }

    protected abstract boolean isRecognizedURL(GenerationContext var1, ContentSet var2, String var3, URL var4);

    protected void writeHeader(GenerationContext gc, PrintWriter pw, String name, String relURL) {
        String pathToRoot = URLUtils.createRelativePathToRoot(relURL);
        pw.println(gc.getFragments().getHeaderBlock(name, pathToRoot, gc.getEncodingType()));
    }

    protected void writeFooter(GenerationContext gc, PrintWriter pw, String name, String relURL) {
        pw.println(gc.getFragments().getFooterBlock());
    }

    protected void writeNavigationBar(GenerationContext gc, PrintWriter pw, String name, String relURL) {
        String pathToRoot = URLUtils.createRelativePathToRoot(relURL);
        boolean anyJavaDoc = gc.wasStandardJavaDocGenerated();
        if (!anyJavaDoc) {
            return;
        }
        pw.println(gc.getFragments().getNavigationBarTop(name, pathToRoot));
        pw.println(anyJavaDoc ? gc.getFragments().getNavigationBarMiddleNPackage(name, pathToRoot) : gc.getFragments().getNavigationBarMiddle0Package(name, pathToRoot));
        pw.println(gc.getFragments().getNavigationBarBottom(name, pathToRoot));
    }

    protected void writeBody(GenerationContext context, PrintWriter pw, String packageName, String name, URL diagramImageURL, int imageWidth, int imageHeight, String imageMap) {
        pw.print("<h2><font SIZE=\"-1\">" + packageName + "</font><br>" + name + "</h2>");
        pw.print("<p align=\"center\">");
        String imageType = context.getImageSuffix();
        if (imageType.equals(".svg") || imageType.equals(".svgz")) {
            pw.print("<embed src=\"");
            pw.print(URLFileSystem.getFileName((URL)diagramImageURL));
            pw.print("\" height=\"");
            pw.print(imageHeight);
            pw.print("\" width=\"");
            pw.print(imageWidth);
            pw.print("\" type=\"image/svg+xml\" pluginspage=\"http://www.adobe.com/svg/viewer/install/\" >");
        } else {
            pw.print("<img name=\"diagram\" src=\"");
            pw.print(URLFileSystem.getFileName((URL)diagramImageURL));
            pw.print("\" height=\"");
            pw.print(imageHeight);
            pw.print("\" width=\"");
            pw.print(imageWidth);
            pw.print("\" border=0 usemap=\"#diagram\">");
            pw.println("<MAP name=\"diagram\">");
            pw.println(imageMap);
            pw.println("</MAP>");
        }
        pw.print("</p>");
        pw.println("<hr>");
    }

    protected void logGeneratingFile(PrintWriter printWriter, URL url) {
        printWriter.println(MessageFormat.format(RESOURCES.getString("Generating.text"), URLFileSystem.getPlatformPathName((URL)url)));
    }

    protected String getFullyQualifiedPackageName(GenerationContext gc, ContentSet contentSet, String scopeRelPath, String relativeURL) {
        if (relativeURL == null) {
            return "";
        }
        int lastIndexOfSlash = relativeURL.lastIndexOf(47);
        String packageName = lastIndexOfSlash != -1 ? relativeURL.substring(0, lastIndexOfSlash).replace('/', '.') : "";
        return packageName;
    }
}

