/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.thumbnail;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.diagram.thumbnail.ThumbnailConstants;
import oracle.javatools.util.BundleLoader;

class ThumbnailViewProxy
extends JPanel {
    private static final ResourceBundle BUNDLE = BundleLoader.getBundle((String)"oracle.diagram.thumbnail.res.ThumbnailResource");
    private final JPanel _blankPanel;
    private Component _view = null;

    public ThumbnailViewProxy() {
        this.setLayout(new BorderLayout());
        this._blankPanel = new JPanel(new GridLayout(1, 1));
        String text = BUNDLE.getString("ThumbnailInactive.text");
        JLabel label = new JLabel(text, 0);
        label.setEnabled(false);
        this._blankPanel.add(label);
        this.setBlankView();
    }

    public Component getView() {
        return this._view;
    }

    public void setView(Component view) {
        if (view == null) {
            this.setBlankView();
            return;
        }
        this.clearUp();
        this._view = view;
        this.add(this._view);
    }

    public void setBlankView() {
        this.clearUp();
        this._view = this._blankPanel;
        this.add(this._view);
    }

    private void clearUp() {
        if (this._view != null) {
            this.remove(this._view);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(ThumbnailConstants.THUMBNAIL_RENDERING_HINT, Boolean.TRUE);
        }
        super.paint(g);
    }
}

