/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.thumbnail;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import oracle.diagram.thumbnail.ThumbnailClient;
import oracle.diagram.thumbnail.ThumbnailClientListener;
import oracle.diagram.thumbnail.ThumbnailClientView;
import oracle.diagram.thumbnail.ThumbnailViewFactory;
import oracle.diagram.thumbnail.ThumbnailViewProxy;
import oracle.ide.Ide;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableWindow;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.ide.util.BitField;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.util.BundleLoader;

public final class ThumbnailDockable
extends DockableWindow
implements ActiveViewListener,
ViewListener {
    private static final ResourceBundle BUNDLE = BundleLoader.getBundle((String)"oracle.diagram.thumbnail.res.ThumbnailResource");
    private static final Map<Class, ThumbnailViewFactory> _factories = new HashMap<Class, ThumbnailViewFactory>();
    public static final String VIEW_NAME = "UnifiedThumbnailDockable";
    public static final ViewId VIEW_ID = new ViewId("UnifiedThumbnailDockable", "UnifiedThumbnailDockable");
    public static final String LAYOUT_SHOW_THUMBNAIL = "Layout.ShowUnifiedThumbnail";
    private View _owningView = null;
    private Component _thumbnailView = null;
    private ThumbnailViewProxy _viewProxy = null;
    private ThumbnailClientListener _clientListener = new ThumbnailClientListener(){

        @Override
        public void clientViewChanged(ThumbnailClient source) {
            if (ThumbnailDockable.this._owningView != null) {
                ThumbnailDockable.this.changeViewIfRequired(ThumbnailDockable.this._owningView);
            }
        }
    };
    private ThumbnailClient _thumbnailClient = null;

    public static final void registerThumbnailViewFactory(Class editorClass, ThumbnailViewFactory factory) {
        if (editorClass == null) {
            throw new IllegalArgumentException("editorClass must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        _factories.put(editorClass, factory);
    }

    protected static final ThumbnailViewFactory getFactory(Class editorClass) {
        ThumbnailViewFactory factory = null;
        if (editorClass == null) {
            return null;
        }
        if (Editor.class.isAssignableFrom(editorClass)) {
            factory = _factories.get(editorClass);
            if (factory != null) {
                return factory;
            }
            return ThumbnailDockable.getFactory(editorClass.getSuperclass());
        }
        return null;
    }

    public ThumbnailDockable() {
        super(VIEW_ID.getId());
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
    }

    public boolean equals(Object other) {
        return other == this;
    }

    public void setOwningEditor(Editor editor) {
        this.changeViewIfRequired((View)editor);
    }

    public void changeViewIfRequired(View view) {
        ThumbnailViewFactory fac;
        boolean change = false;
        Component newThumbnail = null;
        ThumbnailClient client = null;
        if (view instanceof ThumbnailClientView) {
            newThumbnail = ((ThumbnailClientView)view).getThumbnailComponent();
            if (view instanceof ThumbnailClient) {
                client = (ThumbnailClient)view;
            }
            change = true;
        } else if (view instanceof Editor && (fac = ThumbnailDockable.getFactory(view.getClass())) != null) {
            newThumbnail = fac.getThumbnailComponent((Editor)view);
            if (view instanceof ThumbnailClient) {
                client = (ThumbnailClient)view;
            }
            change = true;
        }
        if (change) {
            this.cleanupForThumbnailChange();
            if (client != null) {
                this._thumbnailClient = client;
                this._thumbnailClient.addThumbnailClientListener(this._clientListener);
            }
            if (newThumbnail == null) {
                this._owningView = null;
                this.setBlankView();
            } else {
                this._owningView = view;
                this._owningView.addViewListener((ViewListener)this);
                this._thumbnailView = newThumbnail;
                this.getThumbnailViewProxy().setView(this._thumbnailView);
                this.updateTitle(this.getTitleName());
                this.updateAccessibleName();
            }
        }
    }

    protected void cleanupForThumbnailChange() {
        if (this._owningView != null) {
            this._owningView.removeViewListener((ViewListener)this);
        }
        if (this._thumbnailClient != null) {
            this._thumbnailClient.removeThumbnailClientListener(this._clientListener);
            this._thumbnailClient = null;
        }
        if (this._thumbnailView != null) {
            this._thumbnailView.removeNotify();
            this._thumbnailView = null;
        }
        this._owningView = null;
    }

    public void setBlankView() {
        this.cleanupForThumbnailChange();
        if (this._viewProxy != null) {
            this.getThumbnailViewProxy().setBlankView();
        }
        this.updateTitle(this.getTitleName());
        this.updateAccessibleName();
    }

    public Component getGUI() {
        return this.getThumbnailViewProxy();
    }

    public void dockableHidden(DockableEvent e) {
        super.dockableHidden(e);
        if (BitField.isSet((int)e.getContext(), (int)16)) {
            this.cleanupForThumbnailChange();
            this._viewProxy = null;
        }
    }

    public String getTitleName() {
        return this.getTabName();
    }

    public int getType() {
        return 0;
    }

    protected String getClientName() {
        if (this._owningView instanceof ThumbnailClientView) {
            return ((ThumbnailClientView)this._owningView).getThumbnailDisplayName();
        }
        if (this._owningView instanceof Editor) {
            return ((Editor)this._owningView).getTabLabel();
        }
        return BUNDLE.getString("Blank.text");
    }

    public String getTabName() {
        String text = BUNDLE.getString("Thumbnail.text");
        return text;
    }

    public Icon getTabIcon() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("/oracle/diagram/thumbnail/icons/thumbnail.gif"));
    }

    public int getDefaultVisibility(Layout layout) {
        String property = layout.getProperty(LAYOUT_SHOW_THUMBNAIL, Boolean.FALSE.toString());
        boolean show = Boolean.valueOf(property);
        return show ? 1 : 0;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_mcomthumbnailview_html");
    }

    public void activeViewChanged(ActiveViewEvent event) {
        View view = event.getNewView();
        if (view != null) {
            if (view != this._owningView) {
                this.changeViewIfRequired(view);
            }
        } else {
            this.setBlankView();
        }
    }

    protected void updateAccessibleName() {
        String name = this.getClientName();
        String adaTitle = MessageFormat.format(BUNDLE.getString("ThumbnailADAName.text"), name);
        AccessibleContext ac = null;
        if (this._thumbnailView != null) {
            ac = this._thumbnailView.getAccessibleContext();
        } else {
            Component c = this.getThumbnailViewProxy().getView();
            if (c != null) {
                ac = c.getAccessibleContext();
            }
        }
        if (ac != null) {
            ac.setAccessibleName(adaTitle);
        }
    }

    protected final ThumbnailViewProxy getThumbnailViewProxy() {
        if (this._viewProxy == null) {
            this._viewProxy = new ThumbnailViewProxy();
        }
        return this._viewProxy;
    }

    public void viewActivated(ViewEvent e) {
    }

    public void viewDeactivated(ViewEvent e) {
    }

    public void viewClosed(ViewEvent e) {
        final View view = e.getView();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (view == ThumbnailDockable.this._owningView) {
                    ThumbnailDockable.this.setBlankView();
                }
            }
        });
    }
}

