/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.transx;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.transx.DuplicateException;
import oracle.xml.transx.LangTag;
import oracle.xml.transx.QueryParser;
import oracle.xml.transx.TransXDoc;
import oracle.xml.transx.TransXImpl;
import oracle.xml.transx.TxuErrMsg;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class DefaultDoc
implements TransXDoc {
    XMLDocument m_srcdoc;
    XMLDocument m_xsudoc;
    XMLDocument m_upddoc;
    Vector m_lookup_keys;
    Vector m_xsu_columns;
    Vector m_update_columns;
    Vector m_virtual_columns;
    Vector m_date_columns;
    Vector m_datetime_columns;
    Vector m_binary_columns;
    Vector m_space_columns;
    Hashtable m_key_constant_columns;
    static final String TRANSX_ARCHIVE = "transx.zip";
    static final String SCHEMA_PATH_DLF = "oracle/xml/transx/dlf.xsd";
    static final String SCHEMA_PATH_XML = "oracle/xml/transx/xml.xsd";
    static final String SCHEMA_FILENAME_DLF = "dlf.xsd";
    static final String SCHEMA_FILENAME_XML = "xml.xsd";
    static final String SCHEMA_NAMESPACE_DLF = "http://www.oracle.com/xml/transx/dlf";
    static final String SCHEMA_LOCATION_XML = "http://www.w3.org/2001/xml.xsd";
    static final String JAVA_DATE_FORMAT = "yyyy'-'MM'-'dd'T'HH:mm:ss";
    static final String ORACLE_DATE_FORMAT = "YYYY-MM-DD\"T\"hh24:mi:ss";
    static final int VALID_DATE_LENGTH = 10;
    static final int VALID_DATETIME_LENGTH = 19;

    DefaultDoc() {
        this(null);
    }

    DefaultDoc(XMLDocument xMLDocument) {
        this.m_srcdoc = xMLDocument;
    }

    String[] getKeyColumns() {
        int n = this.m_lookup_keys.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.m_lookup_keys.elementAt(i);
        }
        return stringArray;
    }

    String[] getUpdateColumns() throws XSLException {
        if (this.m_upddoc == null) {
            return null;
        }
        String string = "/table/columns/column[not(@useforupdate=\"no\")][not(@virtual=\"yes\")]";
        NodeList nodeList = this.m_srcdoc.selectNodes(string);
        int n = nodeList.getLength();
        this.m_xsu_columns = new Vector();
        this.m_update_columns = new Vector();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            String string2 = element.getAttribute("name");
            this.m_xsu_columns.addElement(string2);
            if (this.m_lookup_keys.indexOf(string2) != -1) continue;
            this.m_update_columns.addElement(string2);
        }
        return this.toStringArray(this.m_update_columns);
    }

    boolean isVirtual(String string) throws XSLException {
        if (this.m_virtual_columns == null) {
            this.m_virtual_columns = new Vector();
            String string2 = "/table/columns/column[@virtual=\"yes\"]";
            NodeList nodeList = this.m_srcdoc.selectNodes(string2);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                String string3 = element.getAttribute("name");
                this.m_virtual_columns.addElement(string3);
            }
        }
        return this.m_virtual_columns.contains(string);
    }

    boolean isDate(String string) throws XSLException {
        if (this.m_date_columns == null) {
            this.m_date_columns = new Vector();
            String string2 = "/table/columns/column[@type=\"date\"]";
            NodeList nodeList = this.m_srcdoc.selectNodes(string2);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                String string3 = element.getAttribute("name");
                this.m_date_columns.addElement(string3);
            }
        }
        return this.m_date_columns.contains(string);
    }

    boolean isBinary(String string) throws XSLException {
        if (this.m_binary_columns == null) {
            this.m_binary_columns = new Vector();
            String string2 = "/table/columns/column[@type=\"binary\"]";
            NodeList nodeList = this.m_srcdoc.selectNodes(string2);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                String string3 = element.getAttribute("name");
                this.m_binary_columns.addElement(string3);
            }
        }
        return this.m_binary_columns.contains(string);
    }

    boolean isPreserveSpace(String string, boolean bl) throws XSLException {
        if (this.m_space_columns == null) {
            this.m_space_columns = new Vector();
            String string2 = bl ? "default" : "preserve";
            String string3 = "/table/columns/column[@space=\"" + string2 + "\"]";
            NodeList nodeList = this.m_srcdoc.selectNodes(string3);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                String string4 = element.getAttribute("name");
                this.m_space_columns.addElement(string4);
            }
        }
        boolean bl2 = this.m_space_columns.contains(string);
        return bl ? !bl2 : bl2;
    }

    boolean isDateTime(String string) throws XSLException {
        if (this.m_datetime_columns == null) {
            this.m_datetime_columns = new Vector();
            String string2 = "/table/columns/column[@type=\"dateTime\"]";
            NodeList nodeList = this.m_srcdoc.selectNodes(string2);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                String string3 = element.getAttribute("name");
                this.m_datetime_columns.addElement(string3);
            }
        }
        return this.m_datetime_columns.contains(string);
    }

    private String[] toStringArray(Vector vector) {
        int n = vector.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    Document getInsertDoc() {
        return this.m_xsudoc;
    }

    Document getUpdateDoc() {
        return this.m_upddoc;
    }

    void printInsertDoc(PrintStream printStream) {
        try {
            this.m_xsudoc.print((OutputStream)printStream, "UTF-8");
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    void printUpdateDoc(PrintStream printStream) {
        if (this.m_upddoc == null) {
            System.out.println("<?xml version=\"1.0\"?>");
            System.out.println("<!--nothing to update-->");
            return;
        }
        try {
            this.m_upddoc.print((OutputStream)printStream, "UTF-8");
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    void printSourceDoc(PrintStream printStream) {
        try {
            this.m_srcdoc.print((OutputStream)printStream, "UTF-8");
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public void transform() throws DOMException, XSLException {
        this.transform(false);
    }

    public void transform(boolean bl) throws DOMException, XSLException {
        XMLDocument xMLDocument = new XMLDocument();
        Element element = xMLDocument.createElement("rowset");
        Node node = xMLDocument.appendChild((Node)element);
        Vector<String> vector = new Vector<String>();
        String string = "/table/columns/column[@virtual=\"yes\"]";
        NodeList nodeList = this.m_srcdoc.selectNodes(string);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string2 = element2.getAttribute("virtual");
            vector.addElement(element2.getAttribute("name"));
        }
        NodeList nodeList2 = this.m_srcdoc.selectNodes("/table/dataset/row");
        int n2 = nodeList2.getLength();
        for (int i = 0; i < n2; ++i) {
            element = xMLDocument.createElement("row");
            Node node2 = node.appendChild(element);
            NodeList nodeList3 = nodeList2.item(i).getChildNodes();
            n = nodeList3.getLength();
            for (int j = 0; j < n; ++j) {
                Object object;
                String string3;
                Node node3 = nodeList3.item(j);
                if (!(node3 instanceof Element) || vector.contains(string3 = ((Element)node3).getAttribute("name"))) continue;
                element = xMLDocument.createElement(string3);
                Node node4 = node2.appendChild(element);
                Node node5 = node3.getFirstChild();
                if (node5 == null) continue;
                String string4 = node5.getNodeValue();
                if (this.isDate(string3)) {
                    if (string4.length() != 10) {
                        object = TxuErrMsg.getMessage(115, string4);
                        throw new RuntimeException((String)object);
                    }
                    string4 = string4 + "T00:00:00";
                } else if (this.isDateTime(string3)) {
                    if (string4.length() != 19) {
                        object = TxuErrMsg.getMessage(115, string4);
                        throw new RuntimeException((String)object);
                    }
                } else if (this.isBinary(string3)) {
                    object = string4;
                    InputStream inputStream = this.getBufferedBinaryInputStream((String)object);
                    String string5 = null;
                    try {
                        string5 = this.toHexDigitString(inputStream);
                    }
                    catch (IOException iOException) {
                        String string6 = TxuErrMsg.getMessage(301, (String)object);
                        throw new RuntimeException(string6);
                    }
                    if (string5 == null) {
                        String string7 = TxuErrMsg.getMessage(404, "NULL_HEX_STRING");
                        throw new RuntimeException(string7);
                    }
                    string4 = string5;
                } else {
                    object = ((Element)node3).getAttribute("space");
                    if (object != null && ((String)object).length() > 0) {
                        if (!((String)object).equals("preserve")) {
                            string4 = TransXImpl.removeReadabilityWhitespace(string4);
                        }
                    } else if (!this.isPreserveSpace(string3, bl)) {
                        string4 = TransXImpl.removeReadabilityWhitespace(string4);
                    }
                }
                object = xMLDocument.createTextNode(string4);
                node4.appendChild((Node)object);
            }
        }
        this.m_xsudoc = xMLDocument;
    }

    private String toHexDigitString(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = inputStream.available();
        byte[] byArray = new byte[n2];
        do {
            n = inputStream.read(byArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(this.toHexString(byArray[i]));
            }
        } while (n != -1);
        return stringBuffer.toString();
    }

    private String toHexString(byte by) {
        StringBuffer stringBuffer = new StringBuffer(2);
        stringBuffer.setLength(2);
        stringBuffer.setCharAt(0, "0123456789ABCDEF".charAt((by & 0xF0) >> 4));
        stringBuffer.setCharAt(1, "0123456789ABCDEF".charAt(by & 0xF));
        return stringBuffer.toString();
    }

    private InputStream getBufferedBinaryInputStream(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = TxuErrMsg.getMessage(308, string);
            throw new RuntimeException(string2);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        return bufferedInputStream;
    }

    void doLanguage(int n) throws XSLException {
        Element element;
        try {
            element = (Element)this.m_srcdoc.selectSingleNode("/table");
        }
        catch (XSLException xSLException) {
            String string = TxuErrMsg.getMessage(404, xSLException.getMessage());
            throw new RuntimeException(string);
        }
        String string = element.getAttribute("xml:lang");
        LangTag langTag = n != 0 ? LangTag.getInstance(n) : this.getLangTag();
        String string2 = "/table/columns/column[@language]";
        NodeList nodeList = this.m_srcdoc.selectNodes(string2);
        if (nodeList == null) {
            return;
        }
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string3 = element2.getAttribute("language");
            String string4 = langTag.getLangId(string3, string);
            element2.setAttribute("constant", string4);
            element2.removeAttribute("language");
        }
    }

    LangTag getLangTag() throws XSLException {
        String string = "/table[@normalize-langtag]";
        Element element = (Element)this.m_srcdoc.selectSingleNode(string);
        if (element == null) {
            return LangTag.getInstance(0);
        }
        String string2 = element.getAttribute("normalize-langtag");
        if (string2.equals("standard")) {
            return LangTag.getInstance(1);
        }
        if (string2.equals("uppercase")) {
            return LangTag.getInstance(2);
        }
        if (string2.equals("lowercase")) {
            return LangTag.getInstance(3);
        }
        return LangTag.getInstance(0);
    }

    void doConstant() throws XSLException {
        NodeList nodeList = this.m_xsudoc.selectNodes("/rowset/row");
        int n = nodeList.getLength();
        String string = "/table/columns/column[@constant]";
        NodeList nodeList2 = this.m_srcdoc.selectNodes(string);
        DocumentFragment documentFragment = this.m_xsudoc.createDocumentFragment();
        int n2 = nodeList2.getLength();
        if (n2 > 0) {
            this.m_key_constant_columns = new Hashtable();
        }
        for (int i = 0; i < n2; ++i) {
            Object object;
            Node node;
            Element element = (Element)nodeList2.item(i);
            String string2 = element.getAttribute("name");
            String string3 = element.getAttribute("constant");
            string = "/table/lookup-key/column[@name=\"" + string2 + "\"]";
            try {
                node = this.m_srcdoc.selectSingleNode(string);
            }
            catch (XSLException xSLException) {
                object = TxuErrMsg.getMessage(404, xSLException.getMessage());
                throw new RuntimeException((String)object);
            }
            if (node != null && element.getAttribute("type").equals("string")) {
                this.m_key_constant_columns.put(string2, string3);
            }
            for (int j = 0; j < n; ++j) {
                object = this.m_xsudoc.createElement(string2);
                Text text = this.m_xsudoc.createTextNode(string3);
                documentFragment.appendChild((Node)object).appendChild(text);
                Node node2 = nodeList.item(j);
                node2.appendChild(documentFragment);
            }
        }
        if (this.m_key_constant_columns == null) {
            return;
        }
        if (this.m_key_constant_columns.size() <= 0) {
            this.m_key_constant_columns = null;
        }
    }

    void doSequence(Connection connection, XMLDocument xMLDocument) throws XSLException, SQLException {
        if (xMLDocument == null) {
            return;
        }
        Statement statement = connection.createStatement();
        NodeList nodeList = xMLDocument.selectNodes("/rowset/row");
        int n = nodeList.getLength();
        String string = "/table/columns/column[@sequence]";
        NodeList nodeList2 = this.m_srcdoc.selectNodes(string);
        DocumentFragment documentFragment = xMLDocument.createDocumentFragment();
        int n2 = nodeList2.getLength();
        for (int i = 0; i < n2; ++i) {
            Element element = (Element)nodeList2.item(i);
            String string2 = element.getAttribute("name");
            String string3 = element.getAttribute("sequence");
            String string4 = "select " + string3 + ".NEXTVAL from dual";
            for (int j = 0; j < n; ++j) {
                ResultSet resultSet = statement.executeQuery(string4);
                resultSet.next();
                String string5 = resultSet.getString(1);
                Element element2 = xMLDocument.createElement(string2);
                Text text = xMLDocument.createTextNode(string5);
                documentFragment.appendChild(element2).appendChild(text);
                Node node = nodeList.item(j);
                node.appendChild(documentFragment);
                resultSet.close();
            }
        }
        statement.close();
    }

    void evaluateDuplicates(Connection connection, boolean bl) throws XSLException, SQLException, DuplicateException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.m_lookup_keys = new Vector();
        String string = "/table/lookup-key/column[@name]";
        NodeList nodeList = this.m_srcdoc.selectNodes(string);
        int n = nodeList.getLength();
        if (n == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("select unique ");
        for (int i = 0; i < n; ++i) {
            object4 = (Element)nodeList.item(i);
            object3 = object4.getAttribute("name");
            if (i > 0) {
                stringBuffer.append(", ");
            }
            object2 = this.isDate((String)object3) || this.isDateTime((String)object3) ? "TO_CHAR(" + (String)object3 + ",'" + ORACLE_DATE_FORMAT + "')" : object3;
            stringBuffer.append((String)object2);
            this.m_lookup_keys.addElement(object3);
        }
        stringBuffer.append(" from ");
        Element element = (Element)this.m_srcdoc.selectSingleNode("/table");
        object4 = element.getAttribute("name");
        if (object4 == null) {
            object3 = TxuErrMsg.getMessage(401, "/table@name");
            throw new RuntimeException((String)object3);
        }
        stringBuffer.append((String)object4);
        if (this.m_key_constant_columns != null) {
            stringBuffer.append(" where ");
            object3 = this.m_key_constant_columns.keySet().iterator();
            while (true) {
                object2 = (String)object3.next();
                object = (String)this.m_key_constant_columns.get(object2);
                stringBuffer.append((String)object2);
                stringBuffer.append(" = '");
                stringBuffer.append((String)object);
                stringBuffer.append('\'');
                if (!object3.hasNext()) break;
                stringBuffer.append(" AND ");
            }
        }
        this.m_upddoc = new XMLDocument();
        object3 = this.m_upddoc.createElement("rowset");
        object2 = this.m_upddoc.appendChild((Node)object3);
        object = connection.createStatement();
        ResultSet resultSet = object.executeQuery(stringBuffer.toString());
        boolean bl2 = false;
        while (resultSet.next()) {
            string = "/rowset/row";
            for (int i = 0; i < this.m_lookup_keys.size(); ++i) {
                String string2 = resultSet.getString(i + 1);
                if (string2.indexOf(34) != -1) {
                    string2 = DefaultDoc.escape(string2, 34, "&quot;");
                }
                string = string + "[" + this.m_lookup_keys.elementAt(i) + "=\"" + string2 + "\"]";
            }
            NodeList nodeList2 = this.m_xsudoc.selectNodes(string);
            if (nodeList2 == null) continue;
            int n2 = nodeList2.getLength();
            if (bl && n2 > 0) {
                String string3 = TxuErrMsg.getMessage(200, string);
                throw new DuplicateException(string3);
            }
            for (int i = 0; i < n2; ++i) {
                Node node = nodeList2.item(i);
                if (node == null) continue;
                String string4 = node.getNodeName();
                Node node2 = this.m_upddoc.adoptNode(node);
                object2.appendChild(node2);
                bl2 = true;
            }
        }
        resultSet.close();
        object.close();
        bl2 |= this.removeDuplicates(this.m_xsudoc);
        if (!(bl2 |= this.removeDuplicates(this.m_upddoc))) {
            this.m_upddoc = null;
        }
    }

    private boolean removeDuplicates(XMLDocument xMLDocument) throws XSLException {
        boolean bl = false;
        NodeList nodeList = xMLDocument.selectNodes("/rowset/row");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            String string = "/rowset/row";
            Node node2 = nodeList.item(i);
            if (node2.getParentNode() == null) continue;
            for (int j = 0; j < this.m_lookup_keys.size(); ++j) {
                String string2 = (String)this.m_lookup_keys.elementAt(j);
                node = ((XMLNode)node2).selectSingleNode(string2);
                String string3 = ((XMLNode)node).getText();
                string = string + '[' + string2 + "=\"" + string3 + "\"]";
            }
            NodeList nodeList2 = xMLDocument.selectNodes(string);
            int n = nodeList2.getLength() - 1;
            node = nodeList2.item(0).getParentNode();
            for (int j = 0; j < n; ++j) {
                node.removeChild(nodeList2.item(j));
                bl = true;
            }
        }
        return bl;
    }

    static String escape(String string, int n, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        while ((n3 = string.indexOf(34, n2)) != -1) {
            stringBuffer.append(string.substring(n2, n3));
            stringBuffer.append(string2);
            n2 = n3 + 1;
        }
        stringBuffer.append(string.substring(n2, n4));
        return stringBuffer.toString();
    }

    void doQuery(Connection connection) throws XSLException, SQLException {
        this.doQuery(connection, false);
    }

    void doQuery(Connection connection, boolean bl) throws XSLException, SQLException {
        String string = "query";
        NodeList nodeList = this.m_xsudoc.selectNodes("/rowset/row");
        int n = this.m_srcdoc.selectNodes("/table/dataset/row").getLength();
        String string2 = "/table/columns/column[query]";
        NodeList nodeList2 = this.m_srcdoc.selectNodes(string2);
        DocumentFragment documentFragment = this.m_xsudoc.createDocumentFragment();
        int n2 = nodeList2.getLength();
        if (n2 == 0 && (n2 = (nodeList2 = this.m_srcdoc.selectNodes(string2 = "/table/columns/column[sql]")).getLength()) > 0) {
            string = "sql";
        }
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        Calendar calendar = Calendar.getInstance(timeZone);
        for (int i = 0; i < n2; ++i) {
            Object object;
            Object object2;
            Object object3;
            int n3;
            Object object4;
            Element element = (Element)nodeList2.item(i);
            String string3 = element.getAttribute("name");
            XMLNode xMLNode = null;
            NodeList nodeList3 = element.getChildNodes();
            int n4 = nodeList3.getLength();
            for (int j = 0; j < n4; ++j) {
                object4 = nodeList3.item(j);
                if (!(object4 instanceof Element)) continue;
                xMLNode = (XMLNode)object4;
                break;
            }
            if (xMLNode == null) {
                String string4 = TxuErrMsg.getMessage(400, string3);
                throw new RuntimeException(string4);
            }
            String string5 = ((Element)xMLNode).getAttribute("text");
            object4 = new QueryParser(string5);
            String string6 = ((QueryParser)object4).getStatement();
            PreparedStatement preparedStatement = connection.prepareStatement(string6);
            for (n3 = 0; n3 < ((QueryParser)object4).getParamCount(); ++n3) {
                object3 = ((QueryParser)object4).getParameter(n3);
                string2 = "parameter/attribute::id[.=\"" + (String)object3 + "\"]";
                object2 = xMLNode.selectNodes(string2);
                int n5 = object2.getLength();
                if (n5 == 1) continue;
                object = TxuErrMsg.getMessage(100, (String)object3, string6);
                throw new RuntimeException((String)object);
            }
            for (n3 = 0; n3 < n; ++n3) {
                Object object5;
                Object object6;
                for (int j = 0; j < ((QueryParser)object4).getParamCount(); ++j) {
                    Object object7;
                    Object object8;
                    object2 = ((QueryParser)object4).getParameter(j);
                    string2 = "/table/columns/column[@name=\"" + string3 + "\"]" + "/" + string + "/parameter" + "[@id=\"" + (String)object2 + "\"]";
                    object6 = this.m_srcdoc.selectSingleNode(string2);
                    if (object6 == null) {
                        object = TxuErrMsg.getMessage(401, string2);
                        throw new RuntimeException((String)object);
                    }
                    object = ((Element)object6).getAttribute("col");
                    object5 = ((Element)object6).getAttribute("constant");
                    if (((String)object).length() > 0 && ((String)object5).length() > 0) {
                        object8 = TxuErrMsg.getMessage(101, string2, string6);
                        throw new RuntimeException((String)object8);
                    }
                    if (((String)object).length() != 0) {
                        int n6 = n3 + 1;
                        string2 = "/table/dataset/row[position()=" + n6 + "]" + "/col" + "[@name=\"" + (String)object + "\"]";
                        object7 = this.m_srcdoc.selectSingleNode(string2);
                        if (object7 == null) {
                            String string7 = TxuErrMsg.getMessage(102, string2);
                            throw new RuntimeException(string7);
                        }
                        Node node = object7.getFirstChild();
                        if (node == null) {
                            String string8 = TxuErrMsg.getMessage(103, string2);
                            throw new RuntimeException(string8);
                        }
                        object8 = node.getNodeValue();
                    } else if (((String)object5).length() != 0) {
                        object8 = object5;
                    } else {
                        String string9 = TxuErrMsg.getMessage(104, string2, string6);
                        throw new RuntimeException(string9);
                    }
                    if (this.isDate((String)object)) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(JAVA_DATE_FORMAT);
                        object7 = (String)object8 + "T00:00:00";
                        simpleDateFormat.setTimeZone(timeZone);
                        java.util.Date date = ((DateFormat)simpleDateFormat).parse((String)object7, new ParsePosition(0));
                        long l = date.getTime();
                        Date date2 = new Date(l);
                        preparedStatement.setDate(j + 1, date2, calendar);
                        continue;
                    }
                    if (this.isDateTime((String)object)) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(JAVA_DATE_FORMAT);
                        simpleDateFormat.setTimeZone(timeZone);
                        object7 = ((DateFormat)simpleDateFormat).parse((String)object8, new ParsePosition(0));
                        long l = ((java.util.Date)object7).getTime();
                        Date date = new Date(l);
                        preparedStatement.setDate(j + 1, date, calendar);
                        continue;
                    }
                    if (!bl) {
                        object8 = TransXImpl.removeReadabilityWhitespace((String)object8);
                    }
                    preparedStatement.setString(j + 1, (String)object8);
                }
                object3 = null;
                try {
                    object3 = preparedStatement.executeQuery();
                }
                catch (SQLException sQLException) {
                    String string10 = TxuErrMsg.chomp(sQLException.getMessage());
                    object = TxuErrMsg.getMessage(105, string10, string6);
                    throw new RuntimeException((String)object);
                }
                if (!object3.next()) {
                    object2 = null;
                } else if (this.isDate(string3) || this.isDateTime(string3)) {
                    object6 = object3.getTimestamp(1);
                    object = new SimpleDateFormat(JAVA_DATE_FORMAT);
                    ((DateFormat)object).setTimeZone(timeZone);
                    object2 = ((DateFormat)object).format((java.util.Date)object6);
                } else {
                    object2 = object3.getString(1);
                }
                object3.close();
                if (this.isVirtual(string3) || object2 == null) continue;
                object6 = this.m_xsudoc.createElement(string3);
                object = this.m_xsudoc.createTextNode((String)object2);
                documentFragment.appendChild((Node)object6).appendChild((Node)object);
                object5 = nodeList.item(n3);
                object5.appendChild(documentFragment);
            }
            preparedStatement.close();
        }
    }
}

